/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public interface NSCoding {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation.NSCoding");

    public Class classForCoder();

    public void encodeWithCoder(NSCoder var1);

    public static class _BigDecimalSupport
    extends _BigIntegerSupport {
        private static final int _MaxMantissaSize = 16;
        private static final int _MaxByteDifference = 127;
        private static final double _LnTen = Math.log(10.0);

        private double _logBaseTen(double value) {
            return Math.log(value) / _LnTen;
        }

        public void encodeWithCoder(Object receiver, NSCoder coder) {
            int byteLength;
            int scale = ((BigDecimal)receiver).scale();
            BigInteger mantissa = ((BigDecimal)receiver).movePointRight(scale).toBigInteger();
            while ((byteLength = mantissa.bitLength() / 8 + 1) > 16) {
                int byteDifference = byteLength - 16;
                if (byteDifference > 127) {
                    byteDifference = 127;
                }
                int exponentDelta = (int)this._logBaseTen(Math.pow(2.0, 8 * byteDifference));
                BigInteger divisor = new BigInteger("10").pow(exponentDelta);
                scale -= exponentDelta;
                mantissa = mantissa.divide(divisor);
            }
            coder.encodeInt(-scale);
            _BigDecimalSupport._encodeBigInteger(coder, mantissa);
        }

        public Object decodeObject(NSCoder coder) {
            int exponent = coder.decodeInt();
            BigInteger mantissa = _BigDecimalSupport._decodeBigInteger(coder, exponent > 0 ? exponent : 0);
            return new BigDecimal(mantissa, exponent > 0 ? 0 : -exponent);
        }
    }

    public static class _BigIntegerSupport
    extends Support {
        private static final int _MaxShortArrayLength = 8;

        public void encodeWithCoder(Object receiver, NSCoder coder) {
            coder.encodeInt(0);
            _BigIntegerSupport._encodeBigInteger(coder, (BigInteger)receiver);
        }

        public Object decodeObject(NSCoder coder) {
            int exponent = coder.decodeInt();
            return _BigIntegerSupport._decodeBigInteger(coder, exponent);
        }

        private static void _copyIntToByteArray(int anInt, byte[] bytes, int offset) {
            bytes[offset] = (byte)(anInt >>> 24 & 0xFF);
            bytes[offset + 1] = (byte)(anInt >>> 16 & 0xFF);
            bytes[offset + 2] = (byte)(anInt >>> 8 & 0xFF);
            bytes[offset + 3] = (byte)(anInt & 0xFF);
        }

        private static void _copyShortToByteArray(short aShort, byte[] bytes, int offset) {
            bytes[offset] = (byte)(aShort >>> 8);
            bytes[offset + 1] = (byte)aShort;
        }

        private static short _shortFromByteArray(byte[] bytes, int offset) {
            int high = offset >= 0 ? (int)bytes[offset] : 0;
            short low = bytes[offset + 1];
            if (low < 0) {
                low = (short)(low + 256);
            }
            return (short)((high << 8) + low);
        }

        protected static void _encodeBigInteger(NSCoder coder, BigInteger integer) {
            boolean isNegative;
            boolean bl = isNegative = integer.signum() < 0;
            if (isNegative) {
                integer = integer.negate();
            }
            byte[] bytes = integer.toByteArray();
            int length = bytes.length;
            int shortCount = length / 2 + length % 2;
            coder.encodeShort((short)shortCount);
            coder.encodeBoolean(isNegative);
            coder.encodeBoolean(false);
            coder.encodeInt(8);
            for (int i = 0; i < 8; ++i) {
                if (i < shortCount) {
                    coder.encodeShort(_BigIntegerSupport._shortFromByteArray(bytes, length - 2 * (i + 1)));
                    continue;
                }
                coder.encodeShort((short)0);
            }
        }

        protected static BigInteger _decodeBigInteger(NSCoder coder, int exponent) {
            int i;
            short length = coder.decodeShort();
            boolean isNegative = coder.decodeBoolean();
            coder.decodeBoolean();
            int shortCount = coder.decodeInt();
            byte[] bytes = new byte[length * 2];
            for (i = 0; i < shortCount; ++i) {
                short part = coder.decodeShort();
                if (i >= length) continue;
                _BigIntegerSupport._copyShortToByteArray(part, bytes, (length - (i + 1)) * 2);
            }
            BigInteger result = new BigInteger(isNegative ? -1 : 1, bytes);
            if (exponent != 0) {
                bytes = new byte[4];
                int powerOfTen = 10;
                for (i = 1; i < exponent; ++i) {
                    powerOfTen *= 10;
                }
                _BigIntegerSupport._copyIntToByteArray(powerOfTen, bytes, 0);
                BigInteger factor = new BigInteger(bytes);
                result = exponent > 0 ? result.multiply(factor) : result.divide(factor);
            }
            return result;
        }
    }

    public static class _DoubleSupport
    extends _NumberSupport {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            _DoubleSupport._encodeUTF8("d", coder);
            coder.encodeDouble((Double)receiver);
        }
    }

    public static class _FloatSupport
    extends _NumberSupport {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            _FloatSupport._encodeUTF8("f", coder);
            coder.encodeFloat(((Float)receiver).floatValue());
        }
    }

    public static class _LongSupport
    extends _NumberSupport {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            _LongSupport._encodeUTF8("l", coder);
            coder.encodeLong((Long)receiver);
        }
    }

    public static class _IntegerSupport
    extends _NumberSupport {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            _IntegerSupport._encodeUTF8("i", coder);
            coder.encodeInt((Integer)receiver);
        }
    }

    public static class _ShortSupport
    extends _NumberSupport {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            _ShortSupport._encodeUTF8("s", coder);
            coder.encodeShort((Short)receiver);
        }
    }

    public static class _ByteSupport
    extends _NumberSupport {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            _ByteSupport._encodeUTF8("c", coder);
            coder.encodeByte((Byte)receiver);
        }
    }

    public static class _NumberSupport
    extends Support {
        public Class classForCoder(Object receiver) {
            return _NSUtilities._NumberClass;
        }

        public void encodeWithCoder(Object receiver, NSCoder coder) {
        }

        public Object decodeObject(NSCoder coder) {
            String type = _NumberSupport._decodeUTF8(coder);
            switch (type.charAt(0)) {
                case 'c': {
                    return new Byte(coder.decodeByte());
                }
                case 's': {
                    return new Short(coder.decodeShort());
                }
                case 'i': {
                    return new Integer(coder.decodeInt());
                }
                case 'l': {
                    return new Long(coder.decodeLong());
                }
                case 'f': {
                    return new Float(coder.decodeFloat());
                }
                case 'd': {
                    return new Double(coder.decodeDouble());
                }
            }
            throw new IllegalStateException("decodeObject: unsupported number type: " + type);
        }
    }

    public static class _CharacterSupport
    extends Support {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            coder.encodeChar(((Character)receiver).charValue());
        }

        public Object decodeObject(NSCoder coder) {
            return new Character(coder.decodeChar());
        }
    }

    public static class _DateSupport
    extends Support {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            long milliseconds = ((Date)receiver).getTime();
            double seconds = milliseconds / 1000L;
            coder.encodeDouble(seconds);
        }

        public Object decodeObject(NSCoder coder) {
            double seconds = coder.decodeDouble();
            long milliseconds = (long)seconds * 1000L;
            return new Date(milliseconds);
        }
    }

    public static class _StringSupport
    extends Support {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            _StringSupport._encodeUTF8((String)receiver, coder);
        }

        public Object decodeObject(NSCoder coder) {
            return _StringSupport._decodeUTF8(coder);
        }
    }

    public static class _BooleanSupport
    extends Support {
        public void encodeWithCoder(Object receiver, NSCoder coder) {
            coder.encodeBoolean((Boolean)receiver);
        }

        public Object decodeObject(NSCoder coder) {
            return coder.decodeBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static abstract class Support {
        private static NSMutableDictionary _supportByClass = new NSMutableDictionary(16);
        private static final String _UTF8StringEncoding = "UTF8";

        public static Support supportForClass(Class aClass) {
            Support result = null;
            Class currentClass = aClass;
            while (result == null && currentClass != null) {
                result = (Support)_supportByClass.objectForKey(currentClass);
                if (result == null) {
                    currentClass = currentClass.getSuperclass();
                    continue;
                }
                if (currentClass == aClass) continue;
                _supportByClass.setObjectForKey(result, aClass);
            }
            return result;
        }

        public static void setSupportForClass(Support support, Class aClass) {
            _supportByClass.setObjectForKey(support, aClass);
        }

        public Class classForCoder(Object receiver) {
            return receiver.getClass();
        }

        public abstract void encodeWithCoder(Object var1, NSCoder var2);

        public abstract Object decodeObject(NSCoder var1);

        protected static void _encodeUTF8(String string, NSCoder coder) {
            byte[] bytes = null;
            try {
                bytes = string.getBytes(_UTF8StringEncoding);
            }
            catch (UnsupportedEncodingException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
            coder.encodeBytes(bytes);
        }

        protected static String _decodeUTF8(NSCoder coder) {
            String result;
            byte[] bytes = coder.decodeBytes();
            try {
                result = new String(bytes, _UTF8StringEncoding);
            }
            catch (UnsupportedEncodingException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
            return result;
        }

        static {
            Support.setSupportForClass(new _StringSupport(), _NSUtilities._StringClass);
            Support.setSupportForClass(new _BooleanSupport(), _NSUtilities._BooleanClass);
            Support.setSupportForClass(new _NumberSupport(), _NSUtilities._NumberClass);
            Support.setSupportForClass(new _ByteSupport(), _NSUtilities._ByteClass);
            Support.setSupportForClass(new _ShortSupport(), _NSUtilities._ShortClass);
            Support.setSupportForClass(new _IntegerSupport(), _NSUtilities._IntegerClass);
            Support.setSupportForClass(new _LongSupport(), _NSUtilities._LongClass);
            Support.setSupportForClass(new _FloatSupport(), _NSUtilities._FloatClass);
            Support.setSupportForClass(new _DoubleSupport(), _NSUtilities._DoubleClass);
            Support.setSupportForClass(new _BigIntegerSupport(), _NSUtilities._BigIntegerClass);
            Support.setSupportForClass(new _BigDecimalSupport(), _NSUtilities._BigDecimalClass);
            Support.setSupportForClass(new _DateSupport(), _NSUtilities._DateClass);
            Support.setSupportForClass(new _CharacterSupport(), _NSUtilities._CharacterClass);
        }
    }
}

