/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSJavaArrayEnumerator;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSWeakMutableCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Enumeration;

public class _NSWeakValueMutableDictionary
extends _NSWeakMutableCollection
implements Serializable {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation._NSWeakValueMutableDictionary");
    static final long serialVersionUID = 2670319059934557103L;
    private static final String SerializationKeysFieldKey = "keys";
    private static final String SerializationValuesFieldKey = "objects";
    NSMutableDictionary dictionary;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("keys", _NSUtilities._NoObjectArray.getClass()), new ObjectStreamField("objects", _NSUtilities._NoObjectArray.getClass())};

    public _NSWeakValueMutableDictionary() {
        this.dictionary = new NSMutableDictionary(16);
    }

    public _NSWeakValueMutableDictionary(int capacity) {
        this.dictionary = new NSMutableDictionary(capacity);
    }

    public Object[] allReferencesNoCopy() {
        this.processQueue();
        return this.dictionary.objectsNoCopy();
    }

    public NSArray allKeys() {
        this.processQueue();
        return this.dictionary.allKeys();
    }

    public NSArray allValues() {
        Object[] objs = this.dictionary.objectsNoCopy();
        Object[] retVal = new Object[objs.length];
        int j = 0;
        for (int i = 0; i < objs.length; ++i) {
            Object temp = objs[i];
            if (temp == null || (temp = ((_NSWeakMutableCollection._NSWeakMutableCollectionReference)temp).get()) == null) continue;
            retVal[j] = temp;
            ++j;
        }
        return new NSArray(retVal, new NSRange(0, j));
    }

    public NSArray allObjects() {
        return this.allValues();
    }

    public int count() {
        return this.dictionary.count();
    }

    public Object[] objects() {
        return this.allValues().objects();
    }

    public Enumeration keyEnumerator() {
        return new _NSJavaArrayEnumerator(this.dictionary.keysNoCopy(), false);
    }

    public Enumeration objectEnumerator() {
        return new _NSWeakMutableCollection._NSWeakMutableCollectionEnumerator(this.allReferencesNoCopy());
    }

    public Enumeration referenceEnumerator() {
        return new _NSWeakMutableCollection._NSWeakMutableCollectionReferenceEnumerator(this.allReferencesNoCopy());
    }

    public void setObjectForKey(Object object, Object key) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null object into an NSDictionary");
        }
        if (key == null) {
            throw new IllegalArgumentException("Attempt to insert null key into an NSDictionary");
        }
        this.processQueue();
        this.dictionary.setObjectForKey(new _NSWeakMutableCollection._NSWeakMutableCollectionReference(object, this.queue, key), key);
    }

    public Object removeObjectForKey(Object key) {
        this.processQueue();
        return this.dictionary.removeObjectForKey(key);
    }

    public void removeAllObjects() {
        this.processQueue();
        this.dictionary.removeAllObjects();
    }

    public Object objectForKey(Object key) {
        this.processQueue();
        if (this.dictionary.count() == 0 || key == null) {
            return null;
        }
        Object temp = this.dictionary.objectForKey(key);
        return temp == null ? temp : ((_NSWeakMutableCollection._NSWeakMutableCollectionReference)temp).get();
    }

    public WeakReference referenceForKey(Object key) {
        if (this.dictionary.count() == 0 || key == null) {
            return null;
        }
        return (WeakReference)this.dictionary.objectForKey(key);
    }

    public void addObject(Object anObject) {
        throw new UnsupportedOperationException("_NSWeakValueMutableDictionary does not support addObject(Object)");
    }

    public void addReference(Object anObject) {
        throw new UnsupportedOperationException("_NSWeakValueMutableDictionary does not support addReference(Object)");
    }

    public void removeObject(Object object) {
        throw new UnsupportedOperationException("_NSWeakValueMutableDictionary does not support removeObject(Object)");
    }

    public void removeReference(Object object) {
        this.dictionary.removeObjectForKey(((_NSWeakMutableCollection._NSWeakMutableCollectionReference)object).key());
    }

    public String toString() {
        this.processQueue();
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("{");
        Object[] keys = this.dictionary.keysNoCopy();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            WeakReference object = this.referenceForKey(key);
            buffer.append(key.toString());
            buffer.append(" = ");
            buffer.append(object == null ? "gc'd" : object.toString());
            buffer.append("; ");
        }
        buffer.append("}");
        return new String(buffer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        Object[] keys = this.allKeys().objects();
        int c = keys.length;
        Object[] values = new Object[c];
        for (int i = 0; i < c; ++i) {
            values[i] = this.objectForKey(keys[i]);
        }
        fields.put(SerializationKeysFieldKey, keys);
        fields.put(SerializationValuesFieldKey, values);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        keys = keys == null ? _NSUtilities._NoObjectArray : keys;
        values = values == null ? _NSUtilities._NoObjectArray : values;
        int c = keys.length;
        for (int i = 0; i < c; ++i) {
            this.setObjectForKey(values[i], keys[i]);
        }
    }
}

