/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.message.DirectError;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class AssociationError
extends DirectError {
    private static Log _log = LogFactory.getLog((Class)AssociationError.class);
    public static final String ASSOC_ERR = "unsupported-type";
    protected static final List requiredFields = Arrays.asList("ns", "error_code", "error", "session_type");
    protected static final List optionalFields = Arrays.asList("assoc_type");

    protected AssociationError(String msg, AssociationSessionType type) {
        super(msg);
        this.set("ns", "http://specs.openid.net/auth/2.0");
        this.set("error_code", ASSOC_ERR);
        this.set("session_type", type.getSessionType());
        this.set("assoc_type", type.getAssociationType());
    }

    protected AssociationError(ParameterList params) {
        super(params);
    }

    public static AssociationError createAssociationError(String msg, AssociationSessionType type) {
        AssociationError err = new AssociationError(msg, type);
        try {
            err.validate();
        }
        catch (MessageException e) {
            _log.error((Object)("Invalid association error message created, type: " + type + " message: " + msg), (Throwable)e);
        }
        return err;
    }

    public static AssociationError createAssociationError(ParameterList params) {
        AssociationError err = new AssociationError(params);
        try {
            err.validate();
        }
        catch (MessageException e) {
            _log.error((Object)("Invalid association error message created: " + err.keyValueFormEncoding()), (Throwable)e);
        }
        return err;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public void setAssociationSessionType(AssociationSessionType type) {
        this.set("session_type", type.getSessionType());
        this.set("assoc_type", type.getAssociationType());
    }

    public String getSessionType() {
        return this.getParameterValue("session_type");
    }

    public String getAssocType() {
        return this.getParameterValue("assoc_type");
    }

    private String getErrorCode() {
        return this.getParameterValue("error_code");
    }

    public void validate() throws MessageException {
        super.validate();
        if (!ASSOC_ERR.equals(this.getErrorCode()) || !"http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"))) {
            throw new MessageException("Invalid Association Error: invalid error_code or missing ns param.", 512);
        }
    }
}

