/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class AuthImmediateFailure
extends Message {
    private static Log _log = LogFactory.getLog((Class)AuthImmediateFailure.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List requiredFields = Arrays.asList("openid.mode");
    protected static final List optionalFields = Arrays.asList("openid.ns", "openid.user_setup_url");

    protected AuthImmediateFailure(String url, String returnTo, boolean compatibility) {
        if (compatibility) {
            this.set("openid.mode", "id_res");
            this.set("openid.user_setup_url", url);
        } else {
            this.set("openid.mode", "setup_needed");
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
        }
        this._destinationUrl = returnTo;
    }

    protected AuthImmediateFailure(ParameterList params) {
        super(params);
    }

    public static AuthImmediateFailure createAuthImmediateFailure(String url, String returnTo, boolean compatibility) throws MessageException {
        AuthImmediateFailure fail = new AuthImmediateFailure(url, returnTo, compatibility);
        fail.validate();
        return fail;
    }

    public static AuthImmediateFailure createAuthImmediateFailure(ParameterList params) throws MessageException {
        AuthImmediateFailure fail = new AuthImmediateFailure(params);
        fail.validate();
        if (DEBUG) {
            _log.debug((Object)("Retrieved auth immediate failure from message parameters:\n" + fail.keyValueFormEncoding()));
        }
        return fail;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    public String getUserSetupUrl() {
        return this.getParameterValue("openid.user_setup_url");
    }

    public void validate() throws MessageException {
        super.validate();
        boolean compatibility = !this.isVersion2();
        String mode = this.getParameterValue("openid.mode");
        if (compatibility) {
            try {
                new URL(this.getUserSetupUrl());
            }
            catch (MalformedURLException e) {
                throw new MessageException("Invalid user_setup_url in auth failure response.", 768, e);
            }
            if (!"id_res".equals(mode)) {
                throw new MessageException("Invalid openid.mode in auth failure response; expected id_res found: " + mode, 768);
            }
        } else if (!"setup_needed".equals(mode)) {
            throw new MessageException("Invalid openid.mode in auth failure response; expected setup_neededfound: " + mode, 768);
        }
    }
}

