/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;

public class FetchRequest
extends AxMessage {
    private static Log _log = LogFactory.getLog((Class)FetchRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected FetchRequest() {
        this._parameters.set(new Parameter("mode", "fetch_request"));
        if (DEBUG) {
            _log.debug((Object)"Created empty fetch request.");
        }
    }

    public static FetchRequest createFetchRequest() {
        return new FetchRequest();
    }

    protected FetchRequest(ParameterList params) {
        this._parameters = params;
    }

    public static FetchRequest createFetchRequest(ParameterList params) throws MessageException {
        FetchRequest req = new FetchRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a fetch request");
        }
        if (DEBUG) {
            _log.debug((Object)("Created fetch request from parameter list:\n" + params));
        }
        return req;
    }

    public void addAttribute(String alias, String typeUri, boolean required, int count) throws MessageException {
        Parameter newParam;
        if (alias.indexOf(44) > -1 || alias.indexOf(46) > -1 || alias.indexOf(58) > -1 || alias.indexOf(10) > -1) {
            throw new MessageException("Characters [.,:\\n] are not allowed in attribute aliases: " + alias);
        }
        this._parameters.set(new Parameter("type." + alias, typeUri));
        String level = required ? "required" : "if_available";
        Parameter levelParam = this._parameters.getParameter(level);
        if (levelParam == null) {
            newParam = new Parameter(level, alias);
        } else {
            newParam = new Parameter(level, levelParam.getValue() + "," + alias);
            this._parameters.removeParameters(level);
        }
        this._parameters.set(newParam);
        this.setCount(alias, count);
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to fetch request; type: " + typeUri + " alias: " + alias + " count: " + count + " required: " + required));
        }
    }

    public void addAttribute(String alias, String typeUri, boolean required) throws MessageException {
        this.addAttribute(alias, typeUri, required, 1);
    }

    public void setCount(String alias, int count) {
        if (count == 0) {
            this._parameters.set(new Parameter("count." + alias, "unlimited"));
        } else if (count > 1) {
            this._parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    public int getCount(String alias) {
        if ("unlimited".equals(this._parameters.getParameterValue("count" + alias))) {
            return 0;
        }
        if (this._parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this._parameters.getParameterValue("count." + alias));
        }
        return 1;
    }

    public void setUpdateUrl(String updateUrl) throws MessageException {
        try {
            new URL(updateUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid update_url: " + updateUrl);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting fetch request update_url: " + updateUrl));
        }
        this._parameters.set(new Parameter("update_url", updateUrl));
    }

    public String getUpdateUrl() {
        return this._parameters.hasParameter("update_url") ? this._parameters.getParameterValue("update_url") : null;
    }

    public Map getAttributes(boolean required) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        String level = required ? "required" : "if_available";
        Parameter param = this._parameters.getParameter(level);
        if (param != null) {
            String[] values = param.getValue().split(",");
            for (int i = 0; i < values.length; ++i) {
                String alias = values[i];
                attributes.put(alias, this._parameters.getParameterValue("type." + alias));
            }
        }
        return attributes;
    }

    public Map getAttributes() {
        Map attributes = this.getAttributes(true);
        attributes.putAll(this.getAttributes(false));
        return attributes;
    }

    public boolean isValid() {
        String alias;
        int i;
        String[] aliases;
        if (!this._parameters.hasParameter("required") && !this._parameters.hasParameter("if_available")) {
            _log.warn((Object)"One of 'required' or 'if_available' parameters must be present.");
            return false;
        }
        if (!this._parameters.hasParameter("mode") || !"fetch_request".equals(this._parameters.getParameterValue("mode"))) {
            _log.warn((Object)("Invalid mode value in fetch_request: " + this._parameters.getParameterValue("mode")));
            return false;
        }
        if (this._parameters.hasParameter("required")) {
            aliases = this._parameters.getParameterValue("required").split(",");
            for (i = 0; i < aliases.length; ++i) {
                alias = aliases[i];
                if (!this._parameters.hasParameter("type." + alias)) {
                    _log.warn((Object)("Type missing for attribute alias: " + alias));
                    return false;
                }
                if (this.checkCount(alias)) continue;
                return false;
            }
        }
        if (this._parameters.hasParameter("if_available")) {
            aliases = this._parameters.getParameterValue("if_available").split(",");
            for (i = 0; i < aliases.length; ++i) {
                alias = aliases[i];
                if (!this._parameters.hasParameter("type." + alias)) {
                    _log.warn((Object)("Type missing for attribute alias: " + alias));
                    return false;
                }
                if (this.checkCount(alias)) continue;
                return false;
            }
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.startsWith("count.") || paramName.equals("required") || paramName.equals("if_available") || paramName.equals("update_url")) continue;
            _log.warn((Object)("Invalid parameter name in fetch request: " + paramName));
        }
        return true;
    }

    private boolean checkCount(String alias) {
        int count = this.getCount(alias);
        if (count < 0 || count == 0 && !"unlimited".equals(this._parameters.getParameterValue("count." + alias))) {
            _log.warn((Object)("Invalid value for count." + alias + ": " + this._parameters.getParameterValue("count." + alias)));
            return false;
        }
        return true;
    }
}

