/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;

public class StoreResponse
extends AxMessage {
    private static Log _log = LogFactory.getLog((Class)StoreResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected StoreResponse() {
        this._parameters.set(new Parameter("mode", "store_response_success"));
        if (DEBUG) {
            _log.debug((Object)"Created empty store request.");
        }
    }

    public static StoreResponse createStoreResponse() {
        return new StoreResponse();
    }

    protected StoreResponse(ParameterList params) {
        super(params);
    }

    public static StoreResponse createStoreResponse(ParameterList params) throws MessageException {
        StoreResponse resp = new StoreResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a store response");
        }
        if (DEBUG) {
            _log.debug((Object)("Created store response from parameter list:\n" + params));
        }
        return resp;
    }

    protected void setFailure(String description) {
        this._parameters.set(new Parameter("mode", "store_response_failure"));
        if (description != null) {
            this._parameters.set(new Parameter("error", description));
        }
    }

    public boolean hasFailed() {
        return "store_response_failure".equals(this._parameters.getParameterValue("mode"));
    }

    public String getErrorDescription() {
        return this._parameters.getParameterValue("error");
    }

    private boolean isValid() {
        if (!this._parameters.hasParameter("mode") || !"store_response_success".equals(this._parameters.getParameterValue("mode")) && !"store_response_failure".equals(this._parameters.getParameterValue("mode"))) {
            _log.warn((Object)("Invalid mode value in store response: " + this._parameters.getParameterValue("mode")));
            return false;
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            String paramName = param.getKey();
            if (paramName.equals("mode") || paramName.equals("error")) continue;
            _log.warn((Object)("Invalid parameter name in store response: " + paramName));
            return false;
        }
        return true;
    }
}

