/*
 * Decompiled with CFR 0.152.
 */
package er.snapshotexplorer.model;

import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.eof.ERXEC;
import er.snapshotexplorer.model.SEEntityStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEModelStats {
    private EOModel _model;
    private NSMutableDictionary<String, SEEntityStats> _entityStats;

    public SEModelStats(EOModel model) {
        this._model = model;
    }

    public EOModel model() {
        return this._model;
    }

    public SEEntityStats entityStatsForEntityNamed(String entityName) {
        this.ensureSnapshotsLoaded();
        return (SEEntityStats)this._entityStats.objectForKey((Object)entityName);
    }

    public NSArray<SEEntityStats> entityStats() {
        this.ensureSnapshotsLoaded();
        return new NSArray(this._entityStats.values());
    }

    public int snapshotCount() {
        int snapshotCount = 0;
        for (SEEntityStats entityStats : this.entityStats()) {
            snapshotCount += entityStats.snapshotCount();
        }
        return snapshotCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureSnapshotsLoaded() {
        if (this._entityStats == null) {
            this._entityStats = new NSMutableDictionary();
            EODatabaseContext databaseContext = EODatabaseContext.registeredDatabaseContextForModel((EOModel)this._model, (EOEditingContext)ERXEC.newEditingContext());
            databaseContext.lock();
            try {
                EODatabase database = databaseContext.database();
                for (EOGlobalID gid : database.snapshots().allKeys()) {
                    EOEntity entity;
                    if (!(gid instanceof EOKeyGlobalID)) continue;
                    EOKeyGlobalID kgid = (EOKeyGlobalID)gid;
                    String entityName = kgid.entityName();
                    SEEntityStats entityStats = (SEEntityStats)this._entityStats.get((Object)entityName);
                    if (entityStats == null && (entity = this._model.entityNamed(entityName)) != null) {
                        entityStats = new SEEntityStats(databaseContext, entity);
                        this._entityStats.put((Object)entityName, (Object)entityStats);
                    }
                    if (entityStats == null) continue;
                    NSDictionary snapshot = database.snapshotForGlobalID(gid);
                    entityStats.addSnapshot(kgid, (NSDictionary<String, Object>)snapshot);
                }
            }
            finally {
                databaseContext.unlock();
            }
        }
    }
}

