/*
 * Decompiled with CFR 0.152.
 */
package er.taggable;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOAttribute;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXQ;
import er.extensions.foundation.ERXCommandLineTokenizer;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.qualifiers.ERXAndQualifier;
import er.extensions.qualifiers.ERXOrQualifier;
import er.taggable.ERDefaultTagNormalizer;
import er.taggable.ERTagNormalizer;
import er.taggable.ERTaggable;
import er.taggable.model.ERTag;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERTaggableEntity<T extends ERXGenericRecord> {
    private static final String DEFAULT_SEPARATOR = "[\\s,]+";
    public static final String ERTAGGABLE_KEY = "_ERTaggable";
    public static final String ERTAGGABLE_TAG_ENTITY_KEY = "_ERTaggableTagEntity";
    public static final String ERTAGGABLE_TAG_RELATIONSHIP_KEY = "_ERTaggableTagRelationship";
    public static final String DEFAULT_TAGS_RELATIONSHIP_NAME = "tags";
    private static final NSMutableDictionary<String, Class<? extends ERTaggableEntity<?>>> _taggableEntities = new NSMutableDictionary();
    private final EOEntity _tagEntity;
    private final EOEntity _entity;
    private final EORelationship _tagsRelationship;
    private final String _separator = "[\\s,]+";
    private ERTagNormalizer _normalizer = new ERDefaultTagNormalizer();

    protected ERTaggableEntity(EOEntity entity) {
        if (!ERTaggableEntity.isTaggable(entity)) {
            throw new IllegalArgumentException("The entity '" + entity.name() + "' has not been registered as taggable.");
        }
        this._entity = entity;
        String tagEntityName = (String)entity.userInfo().objectForKey((Object)ERTAGGABLE_TAG_ENTITY_KEY);
        this._tagEntity = this._entity.model().modelGroup().entityNamed(tagEntityName);
        String tagsRelationshipName = (String)entity.userInfo().objectForKey((Object)ERTAGGABLE_TAG_RELATIONSHIP_KEY);
        this._tagsRelationship = this._entity.relationshipNamed(tagsRelationshipName);
    }

    public int hashCode() {
        return this._entity.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ERTaggableEntity && ((ERTaggableEntity)obj)._entity.equals(this._entity);
    }

    public static void setTaggableEntityForEntityNamed(Class<? extends ERTaggableEntity<?>> taggableEntity, String entityName) {
        _taggableEntities.setObjectForKey(taggableEntity, (Object)entityName);
    }

    public static <T extends ERXGenericRecord> ERTaggableEntity<T> taggableEntity(EOEntity entity) {
        ERTaggableEntity taggableEntity;
        Class taggableEntityClass = (Class)_taggableEntities.objectForKey((Object)entity.name());
        if (taggableEntityClass == null) {
            taggableEntity = new ERTaggableEntity(entity);
        } else {
            try {
                taggableEntity = (ERTaggableEntity)taggableEntityClass.getConstructor(EOEntity.class).newInstance(entity);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create ERTaggableEntity for entity '" + entity + "'.", e);
            }
        }
        return taggableEntity;
    }

    public static <T extends ERXGenericRecord> ERTaggableEntity<T> taggableEntity(String entityName) {
        return ERTaggableEntity.taggableEntity(EOModelGroup.defaultGroup().entityNamed(entityName));
    }

    public static <T extends ERXGenericRecord> ERTaggableEntity<T> taggableEntity(T eo) {
        return ERTaggableEntity.taggableEntity(eo.entity());
    }

    public static NSDictionary<EOEntity, NSArray<? extends ERXGenericRecord>> fetchAllTaggedWith(EOEditingContext editingContext, Object tags) {
        return ERTaggableEntity.fetchAllTaggedWith(editingContext, ERTag.Inclusion.ALL, -1, tags);
    }

    public static NSDictionary<EOEntity, NSArray<? extends ERXGenericRecord>> fetchAllTaggedWith(EOEditingContext editingContext, ERTag.Inclusion inclusion, Object tags) {
        return ERTaggableEntity.fetchAllTaggedWith(editingContext, inclusion, -1, tags);
    }

    public static NSDictionary<EOEntity, NSArray<? extends ERXGenericRecord>> fetchAllTaggedWith(EOEditingContext editingContext, ERTag.Inclusion inclusion, int limit, Object tags) {
        NSMutableDictionary taggedEntities = new NSMutableDictionary();
        for (EOEntity taggableEntity : ERTaggableEntity.taggableEntities()) {
            NSArray<EOEntity> taggedItems = ERTaggableEntity.taggableEntity(taggableEntity).fetchTaggedWith(editingContext, inclusion, limit, tags);
            taggedEntities.setObjectForKey(taggedItems, (Object)taggableEntity);
        }
        return taggedEntities;
    }

    public static boolean isTaggable(EOEntity entity) {
        return Boolean.TRUE.equals(entity.userInfo().objectForKey((Object)ERTAGGABLE_KEY));
    }

    public static NSArray<EOEntity> taggableEntities() {
        NSMutableArray taggableEntities = new NSMutableArray();
        for (EOModel model : EOModelGroup.defaultGroup().models()) {
            for (EOEntity entity : model.entities()) {
                if (!ERTaggableEntity.isTaggable(entity)) continue;
                taggableEntities.addObject((Object)entity);
            }
        }
        return taggableEntities;
    }

    public static EORelationship tagsRelationshipForEntity(EOEntity entity, EOEntity tagEntity) {
        EORelationship tagsRelationship = null;
        for (EORelationship relationship : entity.relationships()) {
            if (!relationship.isFlattened() || !tagEntity.name().equals(relationship.destinationEntity().name())) continue;
            tagsRelationship = relationship;
            break;
        }
        return tagsRelationship;
    }

    public static EOEntity registerTaggable(String entityName, Class<? extends ERTaggableEntity<?>> taggableEntity) {
        EOEntity joinEntity = ERTaggableEntity.registerTaggable(entityName);
        ERTaggableEntity.setTaggableEntityForEntityNamed(taggableEntity, entityName);
        return joinEntity;
    }

    public static EOEntity registerTaggable(String entityName) {
        EOEntity entity = EOModelGroup.defaultGroup().entityNamed(entityName);
        if (entity == null) {
            throw new IllegalArgumentException("There is no entity named '" + entityName + "' in this model group.");
        }
        return ERTaggableEntity.registerTaggable(entity);
    }

    public static EOEntity registerTaggable(EOEntity entity) {
        return ERTaggableEntity.registerTaggable(entity, DEFAULT_TAGS_RELATIONSHIP_NAME);
    }

    public static EOEntity registerTaggable(EOEntity entity, String tagsRelationshipName) {
        EOEntity tagEntity = entity.model().modelGroup().entityNamed("ERTag");
        if (tagEntity == null) {
            throw new IllegalArgumentException("There is no entity named 'ERTag' in this model group.");
        }
        return ERTaggableEntity.registerTaggable(entity, tagsRelationshipName, tagEntity, null);
    }

    public static EOEntity registerTaggable(EOEntity entity, String tagsRelationshipName, EOEntity tagEntity, Class<? extends ERTaggableEntity<?>> taggableEntity) {
        EORelationship tagsRelationship = tagsRelationshipName == null ? ERTaggableEntity.tagsRelationshipForEntity(entity, tagEntity) : entity.relationshipNamed(tagsRelationshipName);
        EOEntity joinEntity = null;
        if (tagsRelationship == null) {
            joinEntity = new EOEntity();
            joinEntity.setName(entity.name() + "Tag");
            joinEntity.setExternalName(joinEntity.name());
            EORelationship joinToItemRelationship = new EORelationship();
            joinToItemRelationship.setName(entity.name());
            joinToItemRelationship.setIsMandatory(true);
            joinToItemRelationship.setToMany(false);
            joinToItemRelationship.setJoinSemantic(0);
            joinEntity.addRelationship(joinToItemRelationship);
            for (EOAttribute itemPrimaryKey : entity.primaryKeyAttributes()) {
                EOAttribute itemFKAttribute = new EOAttribute();
                itemFKAttribute.setExternalType(itemPrimaryKey.externalType());
                itemFKAttribute.setValueType(itemPrimaryKey.valueType());
                itemFKAttribute.setName("item_" + itemPrimaryKey.name());
                itemFKAttribute.setColumnName("item_" + itemPrimaryKey.columnName());
                itemFKAttribute.setClassName(itemPrimaryKey.className());
                itemFKAttribute.setWidth(itemPrimaryKey.width());
                itemFKAttribute.setPrecision(itemPrimaryKey.precision());
                itemFKAttribute.setScale(itemPrimaryKey.scale());
                itemFKAttribute.setAllowsNull(false);
                joinEntity.addAttribute(itemFKAttribute);
                EOJoin join = new EOJoin(itemFKAttribute, itemPrimaryKey);
                joinToItemRelationship.addJoin(join);
            }
            EORelationship joinToTagRelationship = new EORelationship();
            joinToTagRelationship.setName(tagEntity.name());
            joinToTagRelationship.setIsMandatory(true);
            joinToTagRelationship.setToMany(false);
            joinToTagRelationship.setJoinSemantic(0);
            joinEntity.addRelationship(joinToTagRelationship);
            for (EOAttribute tagPrimaryKey : tagEntity.primaryKeyAttributes()) {
                EOAttribute tagFKAttribute = new EOAttribute();
                tagFKAttribute.setExternalType(tagPrimaryKey.externalType());
                tagFKAttribute.setValueType(tagPrimaryKey.valueType());
                tagFKAttribute.setName("tag_" + tagPrimaryKey.name());
                tagFKAttribute.setColumnName("tag_" + tagPrimaryKey.columnName());
                tagFKAttribute.setClassName(tagPrimaryKey.className());
                tagFKAttribute.setWidth(tagPrimaryKey.width());
                tagFKAttribute.setPrecision(tagPrimaryKey.precision());
                tagFKAttribute.setScale(tagPrimaryKey.scale());
                tagFKAttribute.setAllowsNull(false);
                joinEntity.addAttribute(tagFKAttribute);
                joinToTagRelationship.addJoin(new EOJoin(tagFKAttribute, tagPrimaryKey));
            }
            joinEntity.setPrimaryKeyAttributes(joinEntity.attributes());
            joinEntity.setAttributesUsedForLocking(joinEntity.attributes());
            entity.model().addEntity(joinEntity);
            EORelationship itemToJoinRelationship = new EORelationship();
            itemToJoinRelationship.setEntity(joinToItemRelationship.destinationEntity());
            itemToJoinRelationship.setName("_eofInv_" + joinToItemRelationship.entity().name() + "_" + joinToItemRelationship.name());
            NSArray joinToItemRelationshipJoins = joinToItemRelationship.joins();
            for (int joinNum = joinToItemRelationshipJoins.count() - 1; joinNum >= 0; --joinNum) {
                EOJoin join = (EOJoin)joinToItemRelationshipJoins.objectAtIndex(joinNum);
                EOJoin inverseJoin = new EOJoin(join.destinationAttribute(), join.sourceAttribute());
                itemToJoinRelationship.addJoin(inverseJoin);
            }
            itemToJoinRelationship.setDeleteRule(1);
            itemToJoinRelationship.setJoinSemantic(0);
            itemToJoinRelationship.setToMany(true);
            itemToJoinRelationship.setPropagatesPrimaryKey(true);
            entity.addRelationship(itemToJoinRelationship);
            NSMutableArray properties = entity.classProperties().mutableClone();
            properties.remove((Object)itemToJoinRelationship);
            entity.setClassProperties((NSArray)properties);
            EORelationship itemToTagsRelationship = new EORelationship();
            itemToTagsRelationship.setName(tagsRelationshipName);
            entity.addRelationship(itemToTagsRelationship);
            itemToTagsRelationship.setDefinition(itemToJoinRelationship.name() + "." + joinToTagRelationship.name());
            tagsRelationship = itemToTagsRelationship;
        } else {
            if (!tagsRelationship.isFlattened()) {
                throw new IllegalArgumentException("The relationship '" + tagsRelationship.name() + "' on '" + entity.name() + "' must be flattened.");
            }
            EORelationship itemToJoinRelationship = (EORelationship)tagsRelationship.componentRelationships().objectAtIndex(0);
            joinEntity = itemToJoinRelationship.destinationEntity();
        }
        NSMutableDictionary userInfo = entity.userInfo().mutableClone();
        userInfo.setObjectForKey((Object)Boolean.TRUE, (Object)ERTAGGABLE_KEY);
        userInfo.setObjectForKey((Object)tagsRelationship.name(), (Object)ERTAGGABLE_TAG_RELATIONSHIP_KEY);
        userInfo.setObjectForKey((Object)tagEntity.name(), (Object)ERTAGGABLE_TAG_ENTITY_KEY);
        entity.setUserInfo((NSDictionary)userInfo);
        if (taggableEntity != null) {
            ERTaggableEntity.setTaggableEntityForEntityNamed(taggableEntity, entity.name());
        }
        return joinEntity;
    }

    public ERTagNormalizer normalizer() {
        return this._normalizer;
    }

    public void setNormalizer(ERTagNormalizer normalizer) {
        this._normalizer = normalizer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ERTag fetchTagNamed(EOEditingContext editingContext, String tagName, boolean createIfMissing) {
        NSArray tags = ERXEOControlUtilities.objectsWithQualifier((EOEditingContext)editingContext, (String)this._tagEntity.name(), (EOQualifier)ERTag.NAME.is((Object)tagName), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (tags.count() == 0) {
            if (!createIfMissing) return null;
            EOEditingContext newEditingContext = ERXEC.newEditingContext();
            try {
                ERTag newTag = this.createTagNamed(newEditingContext, tagName);
                newEditingContext.saveChanges();
                return newTag.localInstanceIn(editingContext);
            }
            catch (EOGeneralAdaptorException e) {
                ERTag tag = this.fetchTagNamed(editingContext, tagName, false);
                if (tag != null) return tag;
                throw e;
            }
        }
        if (tags.count() != 1) throw new IllegalArgumentException("There was more than one tag with the name '" + tagName + "'");
        return (ERTag)((Object)tags.objectAtIndex(0));
    }

    public ERTag createTagNamed(EOEditingContext editingContext, String tagName) {
        ERTag tag = (ERTag)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)this._tagEntity.name());
        tag.setName(tagName);
        return tag;
    }

    public ERTaggable<T> taggable(T eo) {
        return new ERTaggable<T>(this, eo);
    }

    public String tagsRelationshipName() {
        return this._tagsRelationship.name();
    }

    public EORelationship tagsRelationship() {
        return this._tagsRelationship;
    }

    public static boolean isWhitespaceSeparator(String separator) {
        return separator != null && (separator.contains("\\s") || separator.contains(" "));
    }

    public NSArray<String> splitTagNames(Object tags) {
        NSMutableSet tagNames = new NSMutableSet();
        if (tags != null) {
            if (tags instanceof String) {
                Object[] strTags;
                if (ERTaggableEntity.isWhitespaceSeparator(DEFAULT_SEPARATOR)) {
                    LinkedList<String> strTagsList = new LinkedList<String>();
                    ERXCommandLineTokenizer tagTokenizer = new ERXCommandLineTokenizer((String)tags);
                    while (tagTokenizer.hasMoreTokens()) {
                        String tag = tagTokenizer.nextElement();
                        strTagsList.add(tag);
                    }
                    strTags = strTagsList.toArray(new String[strTagsList.size()]);
                } else {
                    strTags = ((String)tags).split(DEFAULT_SEPARATOR);
                }
                this.addNormalizedTags((NSMutableSet<String>)tagNames, strTags);
            } else if (tags instanceof ERTag) {
                tagNames.addObject((Object)((ERTag)((Object)tags)).name());
            } else if (tags instanceof NSArray) {
                this.addNormalizedTags((NSMutableSet<String>)tagNames, ((NSArray)tags).objects());
            } else if (tags instanceof Object[]) {
                this.addNormalizedTags((NSMutableSet<String>)tagNames, (Object[])tags);
            } else {
                throw new IllegalArgumentException("Unknown tag type '" + tags.getClass().getName() + "' (" + tags + " ).");
            }
        }
        return tagNames.allObjects();
    }

    private void addNormalizedTags(NSMutableSet<String> set, Object[] tags) {
        for (Object objTag : tags) {
            if (objTag instanceof String) {
                String strTag = (String)objTag;
                String normalizedTag = this._normalizer.normalize(strTag);
                if (normalizedTag == null || normalizedTag.length() <= 0) continue;
                set.addObject((Object)normalizedTag);
                continue;
            }
            if (objTag instanceof ERTag) {
                set.addObject((Object)((ERTag)((Object)objTag)).name());
                continue;
            }
            throw new IllegalArgumentException("Unknown tag type '" + objTag.getClass().getName() + "' (" + objTag + " ).");
        }
    }

    public NSArray<T> fetchTaggedWith(EOEditingContext editingContext, Object tags) {
        return this.fetchTaggedWith(editingContext, ERTag.Inclusion.ALL, tags);
    }

    public NSArray<T> fetchTaggedWith(EOEditingContext editingContext, ERTag.Inclusion inclusion, Object tags) {
        return this.fetchTaggedWith(editingContext, inclusion, -1, tags);
    }

    public NSArray<T> fetchTaggedWith(EOEditingContext editingContext, ERTag.Inclusion inclusion, int limit, Object tags) {
        return this.fetchTaggedWith(editingContext, inclusion, limit, tags, null);
    }

    public NSArray<T> fetchTaggedWith(EOEditingContext editingContext, ERTag.Inclusion inclusion, int limit, Object tags, EOQualifier additionalQualifier) {
        NSArray<String> tagNames = this.splitTagNames(tags);
        if (tagNames.count() == 0) {
            throw new IllegalArgumentException("No tags were passed in.");
        }
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper((EOModel)this._entity.model());
        ERXOrQualifier qualifier = new ERXKey(this._tagsRelationship.name()).append(ERTag.NAME).in(tagNames);
        if (additionalQualifier != null) {
            qualifier = ERXQ.and((EOQualifier[])new EOQualifier[]{qualifier, additionalQualifier});
        }
        NSArray sortOrderings = null;
        EOFetchSpecification fetchSpec = new EOFetchSpecification(this._entity.name(), (EOQualifier)qualifier, sortOrderings);
        EOSQLExpression sqlExpression = sqlHelper.sqlExpressionForFetchSpecification(editingContext, fetchSpec, 0L, (long)limit);
        sqlHelper.addGroupByClauseToExpression(editingContext, fetchSpec, sqlExpression);
        if (inclusion == ERTag.Inclusion.ALL) {
            sqlHelper.addHavingCountClauseToExpression(EOQualifier.QualifierOperatorEqual, tagNames.count(), sqlExpression);
        }
        NSArray rawRows = ERXEOAccessUtilities.rawRowsForSQLExpression((EOEditingContext)editingContext, (EOModel)this._entity.model(), (EOSQLExpression)sqlExpression, (NSArray)sqlHelper.attributesToFetchForEntity(fetchSpec, this._entity));
        NSArray objs = ERXEOControlUtilities.faultsForRawRowsFromEntity((EOEditingContext)editingContext, (NSArray)rawRows, (String)this._entity.name());
        objs = ERXEOControlUtilities.objectsForFaultWithSortOrderings((EOEditingContext)editingContext, (NSArray)objs, (NSArray)fetchSpec.sortOrderings());
        return objs;
    }

    public void removeTags(EOEditingContext editingContext, Object tags) {
        this.replaceTags(editingContext, ERTag.Inclusion.ALL, tags, null);
    }

    public void replaceTags(EOEditingContext editingContext, ERTag.Inclusion inclusion, Object oldTags, Object newTags) {
        for (ERXGenericRecord item : this.fetchTaggedWith(editingContext, inclusion, oldTags)) {
            ERTaggable<ERXGenericRecord> taggable = this.taggable(item);
            taggable.removeTags(oldTags);
            taggable.addTags(newTags);
        }
    }

    public NSDictionary<String, Integer> tagCount(EOEditingContext editingContext) {
        return this.tagCount(editingContext, null);
    }

    public NSDictionary<String, Integer> tagCount(EOEditingContext editingContext, EOQualifier additionalQualifier) {
        return this.tagCount(editingContext, -1, additionalQualifier);
    }

    public NSDictionary<String, Integer> tagCount(EOEditingContext editingContext, int limit) {
        return this.tagCount(editingContext, limit, null);
    }

    public NSDictionary<String, Integer> tagCount(EOEditingContext editingContext, int limit, EOQualifier additionalQualifier) {
        return this.tagCount(editingContext, null, -1, limit, additionalQualifier);
    }

    public NSDictionary<String, Integer> tagCount(EOEditingContext editingContext, NSSelector selector, int count, int limit) {
        return this.tagCount(editingContext, selector, count, limit, null);
    }

    public NSDictionary<String, Integer> tagCount(EOEditingContext editingContext, NSSelector selector, int count, int limit, EOQualifier additionalQualifier) {
        NSMutableArray fetchAttributes = new NSMutableArray();
        ERXEOAttribute tagNameAttribute = new ERXEOAttribute(this._entity, this._tagsRelationship.name() + "." + ERTag.NAME_KEY);
        tagNameAttribute.setName("tagName");
        fetchAttributes.addObject((Object)tagNameAttribute);
        EOAttribute countAttribute = ERXEOAccessUtilities.createAggregateAttribute((EOEditingContext)editingContext, (String)"COUNT", (String)ERTag.NAME_KEY, (String)this._tagEntity.name(), Number.class, (String)"i", (String)"tagCount", (String)"t2");
        fetchAttributes.addObject((Object)countAttribute);
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper((EOModel)this._entity.model());
        ERXAndQualifier combinedAdditionalQualifier = null;
        EOQualifier additionalTagCountQualifier = this.additionalTagCountQualifier();
        if (additionalTagCountQualifier != null || additionalQualifier != null) {
            combinedAdditionalQualifier = ERXQ.and((EOQualifier[])new EOQualifier[]{additionalQualifier, additionalTagCountQualifier});
        }
        EOFetchSpecification fetchSpec = new EOFetchSpecification(this._entity.name(), combinedAdditionalQualifier, null);
        EOSQLExpression sqlExpression = sqlHelper.sqlExpressionForFetchSpecification(editingContext, fetchSpec, 0L, (long)limit, (NSArray)fetchAttributes);
        NSMutableArray groupByAttributes = new NSMutableArray((Object)tagNameAttribute);
        sqlHelper.addGroupByClauseToExpression((NSArray)groupByAttributes, sqlExpression);
        if (selector != null) {
            sqlHelper.addHavingCountClauseToExpression(selector, count, sqlExpression);
        }
        if (limit > 0) {
            StringBuffer sqlBuffer = new StringBuffer(sqlExpression.statement());
            int orderByIndex = sqlHelper._orderByIndex(sqlExpression);
            sqlBuffer.insert(orderByIndex, " ORDER BY tagCount DESC");
            sqlExpression.setStatement(sqlBuffer.toString());
        }
        NSMutableDictionary tagCounts = new NSMutableDictionary();
        NSArray rawRows = ERXEOAccessUtilities.rawRowsForSQLExpression((EOEditingContext)editingContext, (EOModel)this._entity.model(), (EOSQLExpression)sqlExpression, (NSArray)fetchAttributes);
        for (NSDictionary rawRow : rawRows) {
            String name = (String)rawRow.objectForKey((Object)"tagName");
            Integer nameCount = (Integer)rawRow.objectForKey((Object)"tagCount");
            tagCounts.setObjectForKey((Object)nameCount, (Object)name);
        }
        return tagCounts;
    }

    public int countUniqueTaggedWith(EOEditingContext editingContext, ERTag.Inclusion inclusion, Object tags) {
        NSArray<String> tagNames = this.splitTagNames(tags);
        if (tagNames.count() == 0) {
            throw new IllegalArgumentException("No tags were passed in.");
        }
        ERXOrQualifier qualifier = new ERXKey(this._tagsRelationship.name()).append(ERTag.NAME).in(tagNames);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(this._entity.name(), (EOQualifier)qualifier, null);
        fetchSpec.setUsesDistinct(true);
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper((EOModel)this._entity.model());
        EOSQLExpression sqlExpression = sqlHelper.sqlExpressionForFetchSpecification(editingContext, fetchSpec, 0L, -1L);
        sqlHelper.addGroupByClauseToExpression(editingContext, fetchSpec, sqlExpression);
        if (inclusion == ERTag.Inclusion.ALL) {
            sqlHelper.addHavingCountClauseToExpression(EOQualifier.QualifierOperatorEqual, tagNames.count(), sqlExpression);
        }
        int count = sqlHelper.rowCountForFetchSpecification(editingContext, fetchSpec);
        return count;
    }

    public NSArray<String> fetchRelatedTags(EOEditingContext editingContext, Object tags) {
        NSArray<String> tagNames = this.splitTagNames(tags);
        if (tagNames.count() == 0) {
            throw new IllegalArgumentException("No tags were passed in.");
        }
        NSArray pkAttrs = this._entity.primaryKeyAttributes();
        if (pkAttrs.count() > 1) {
            throw new IllegalArgumentException("Composite primary keys are not supported for findRelatedTags.");
        }
        NSMutableArray fetchAttributes = new NSMutableArray();
        fetchAttributes.addObjectsFromArray(this._entity.primaryKeyAttributes());
        ERXEOAttribute tagNameAttribute = new ERXEOAttribute(this._entity, this._tagsRelationship.name() + "." + ERTag.NAME_KEY);
        tagNameAttribute.setName("tagName");
        fetchAttributes.addObject((Object)tagNameAttribute);
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper((EOModel)this._entity.model());
        ERXOrQualifier tagNameQualifier = new ERXKey(this._tagsRelationship.name()).append(ERTag.NAME).in(tagNames);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(this._entity.name(), (EOQualifier)tagNameQualifier, null);
        EOSQLExpression sqlExpression = sqlHelper.sqlExpressionForFetchSpecification(editingContext, fetchSpec, 0L, -1L, (NSArray)fetchAttributes);
        NSMutableArray groupByAttributes = new NSMutableArray();
        groupByAttributes.addObjectsFromArray(pkAttrs);
        sqlHelper.addGroupByClauseToExpression((NSArray)groupByAttributes, sqlExpression);
        sqlHelper.addHavingCountClauseToExpression(EOQualifier.QualifierOperatorEqual, tagNames.count(), sqlExpression);
        sqlHelper.removeSelectFromExpression((EOAttribute)tagNameAttribute, sqlExpression);
        NSMutableArray itemPrimaryKeys = new NSMutableArray();
        NSArray rawRows = ERXEOAccessUtilities.rawRowsForSQLExpression((EOEditingContext)editingContext, (EOModel)this._entity.model(), (EOSQLExpression)sqlExpression, (NSArray)pkAttrs);
        EOAttribute pkAttr = (EOAttribute)pkAttrs.objectAtIndex(0);
        for (NSDictionary rawRow : rawRows) {
            Object pk = rawRow.objectForKey((Object)pkAttr.name());
            itemPrimaryKeys.addObject(pk);
        }
        NSMutableArray tagsFetchAttributes = new NSMutableArray();
        tagsFetchAttributes.addObjectsFromArray(this._entity.primaryKeyAttributes());
        ERXEOAttribute tagIDAttribute = new ERXEOAttribute(this._entity, this._tagsRelationship.name() + ".id");
        tagIDAttribute.setName("id");
        tagsFetchAttributes.addObject((Object)tagIDAttribute);
        tagsFetchAttributes.addObject((Object)tagNameAttribute);
        EOAttribute countAttribute = ERXEOAccessUtilities.createAggregateAttribute((EOEditingContext)editingContext, (String)"COUNT", (String)ERTag.NAME_KEY, (String)this._tagEntity.name(), Number.class, (String)"i", (String)"tagCount", (String)"t2");
        tagsFetchAttributes.addObject((Object)countAttribute);
        ERXOrQualifier idQualifier = new ERXKey("id").in((NSArray)itemPrimaryKeys);
        EOFetchSpecification tagsFetchSpec = new EOFetchSpecification(this._entity.name(), (EOQualifier)idQualifier, null);
        EOSQLExpression tagsSqlExpression = sqlHelper.sqlExpressionForFetchSpecification(editingContext, tagsFetchSpec, 0L, -1L, (NSArray)tagsFetchAttributes);
        NSMutableArray tagsGroupByAttributes = new NSMutableArray((Object[])new EOAttribute[]{tagNameAttribute, tagIDAttribute});
        sqlHelper.addGroupByClauseToExpression((NSArray)tagsGroupByAttributes, tagsSqlExpression);
        tagsSqlExpression.setStatement(tagsSqlExpression.statement() + " ORDER BY tagCount DESC");
        for (EOAttribute attribute : this._entity.primaryKeyAttributes()) {
            sqlHelper.removeSelectFromExpression(attribute, tagsSqlExpression);
            tagsFetchAttributes.removeObject((Object)attribute);
        }
        NSMutableArray relatedTagNames = new NSMutableArray();
        NSArray tagsRawRows = ERXEOAccessUtilities.rawRowsForSQLExpression((EOEditingContext)editingContext, (EOModel)this._entity.model(), (EOSQLExpression)tagsSqlExpression, (NSArray)tagsFetchAttributes);
        for (NSDictionary rawRow : tagsRawRows) {
            String name = (String)rawRow.objectForKey((Object)"tagName");
            relatedTagNames.addObject((Object)name);
        }
        return relatedTagNames;
    }

    public <U> NSDictionary<String, U> cloud(EOEditingContext editingContext, NSArray<U> categoryList) {
        return this.cloud(this.tagCount(editingContext), categoryList);
    }

    public <U> NSDictionary<String, U> cloud(NSDictionary<String, Integer> tagHash, NSArray<U> categoryList) {
        int min = 0;
        int max = 0;
        for (Integer count : tagHash.allValues()) {
            if (count > max) {
                max = count;
            }
            if (count >= min) continue;
            min = count;
        }
        NSMutableDictionary cloud = new NSMutableDictionary();
        int divisor = (max - min) / categoryList.count() + 1;
        for (Map.Entry entry : tagHash.entrySet()) {
            Object obj = categoryList.objectAtIndex(((Integer)entry.getValue() - min) / divisor);
            cloud.setObjectForKey(obj, entry.getKey());
        }
        return cloud;
    }

    public NSArray<String> fetchAllTags(EOEditingContext editingContext) {
        NSArray<ERTag> erTags = ERTag.fetchAllERTags(editingContext);
        NSArray tags = (NSArray)erTags.valueForKey(ERTag.NAME_KEY);
        return tags;
    }

    public NSArray<String> fetchTagsLike(EOEditingContext editingContext, String startsWith) {
        NSArray<ERTag> erTags = ERTag.fetchERTags(editingContext, (EOQualifier)ERTag.NAME.likeInsensitive(startsWith + "*"), null);
        NSArray tags = (NSArray)erTags.valueForKey(ERTag.NAME_KEY);
        return tags;
    }

    protected EOQualifier additionalTagCountQualifier() {
        return null;
    }
}

