/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSWeakMutableArray;
import com.webobjects.foundation._NSWeakMutableCollection;
import com.webobjects.foundation._NSWeakMutableSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class NSNotificationCenter {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSNotificationCenter");
    private static NSNotificationCenter _defaultCenter = new NSNotificationCenter();
    private static final WeakHashMap _byObjectPlaceholder = new WeakHashMap(0);
    private static final _NSWeakMutableArray _byNamePlaceholder = new _NSWeakMutableArray(0);
    private WeakHashMap _byObject;
    private _NSWeakMutableSet _omniscient;
    private NSMutableDictionary _byName;

    public static NSNotificationCenter defaultCenter() {
        return _defaultCenter;
    }

    protected NSNotificationCenter() {
    }

    public String toString() {
        return super.toString() + "\n_omniscient=\n" + this._omniscient + "\n_byObject=\n" + this._byObject + "\n_byName=\n" + this._byName;
    }

    protected _Entry _getEntry(Object observer, NSSelector selector, ReferenceQueue queue) {
        return new _Entry(observer, selector, queue);
    }

    private void _checkObserverAndSelector(Object observer, NSSelector sel) {
        if (observer == null || sel == null) {
            String exceptionString = "";
            exceptionString = observer == null && sel == null ? "NSNotificationCenter addObserver() requires non null observer and selector parameters" : (observer == null ? "NSNotificationCenter addObserver() requires non null observer parameter" : "NSNotificationCenter addObserver() requires non null selector parameter");
            throw new IllegalArgumentException(exceptionString);
        }
        Class[] parameterTypes = sel.parameterTypes();
        boolean isBadSelector = false;
        if (parameterTypes == null || parameterTypes.length != 1) {
            isBadSelector = true;
        } else {
            Class argument = parameterTypes[0];
            if (argument == null || !NSNotification._CLASS.isAssignableFrom(argument)) {
                isBadSelector = true;
            }
        }
        if (isBadSelector) {
            throw new IllegalArgumentException("NSNotificationCenter addObserver() requires a selector taking a single NSNotification argument");
        }
    }

    public synchronized void addOmniscientObserver(Object observer, NSSelector sel) {
        if (this._omniscient == null) {
            this._omniscient = new _NSWeakMutableSet(8);
        }
        this._checkObserverAndSelector(observer, sel);
        this._omniscient.addReference(this._getEntry(observer, sel, this._omniscient.queue));
    }

    public synchronized void addObserver(Object observer, NSSelector sel, String name, Object object) {
        this._checkObserverAndSelector(observer, sel);
        if (name == null) {
            _NSWeakMutableArray existingObservers;
            if (object == null) {
                throw new IllegalArgumentException("Use NSNotificationCenter.addOmniscientObserver(observer) to add omniscient observers");
            }
            if (this._byObject == null) {
                this._byObject = new WeakHashMap(128);
            }
            if ((existingObservers = (_NSWeakMutableArray)this._byObject.get(object)) == null) {
                existingObservers = new _NSWeakMutableArray(8);
                this._byObject.put(object, existingObservers);
                existingObservers.addReference(this._getEntry(observer, sel, existingObservers.queue));
            } else {
                _Entry entry = this._getEntry(observer, sel, existingObservers.queue);
                if (existingObservers.indexOfObject(entry) < 0) {
                    existingObservers.addReference(entry);
                }
            }
        } else {
            NSMutableArray array;
            if (this._byName == null) {
                this._byName = new NSMutableDictionary(128);
            }
            if ((array = (NSMutableArray)this._byName.objectForKey(name)) == null) {
                array = new NSMutableArray(2);
                array.insertObjectAtIndex(_byObjectPlaceholder, 0);
                array.insertObjectAtIndex(_byNamePlaceholder, 1);
                this._byName.setObjectForKey(array, name);
            }
            if (object == null) {
                _Entry entry;
                _NSWeakMutableArray weakRefs = (_NSWeakMutableArray)array.objectAtIndex(1);
                if (weakRefs == _byNamePlaceholder) {
                    weakRefs = new _NSWeakMutableArray(8);
                    array.replaceObjectAtIndex(1, weakRefs);
                }
                if (weakRefs.indexOfObject(entry = this._getEntry(observer, sel, weakRefs.queue)) < 0) {
                    weakRefs.addReference(entry);
                }
            } else {
                _Entry entry;
                _NSWeakMutableArray existingObservers;
                WeakHashMap<Object, _NSWeakMutableArray> byObj = (WeakHashMap<Object, _NSWeakMutableArray>)array.objectAtIndex(0);
                if (byObj == _byObjectPlaceholder) {
                    byObj = new WeakHashMap<Object, _NSWeakMutableArray>(8);
                    array.replaceObjectAtIndex(0, byObj);
                }
                if ((existingObservers = (_NSWeakMutableArray)byObj.get(object)) == null) {
                    existingObservers = new _NSWeakMutableArray(8);
                    byObj.put(object, existingObservers);
                }
                if (existingObservers.indexOfObject(entry = this._getEntry(observer, sel, existingObservers.queue)) < 0) {
                    existingObservers.addReference(entry);
                }
            }
        }
    }

    private void _removeReferencesWithReferentFromByObjectDict(Object observer, WeakHashMap simpleDict) {
        Set keySet = simpleDict.keySet();
        Iterator keyIterator = keySet.iterator();
        while (keyIterator.hasNext()) {
            _NSWeakMutableArray weakArray = (_NSWeakMutableArray)simpleDict.get(keyIterator.next());
            if (weakArray == null) continue;
            this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
        }
    }

    private void _removeReferencesWithReferentFromWeakArray(Object observer, _NSWeakMutableArray weakArray) {
        Enumeration arrayEnum = weakArray.referenceEnumerator();
        Object[] removeObjs = new Object[weakArray.count()];
        int j = 0;
        while (arrayEnum.hasMoreElements()) {
            _Entry entry = (_Entry)arrayEnum.nextElement();
            Object curObj = entry.get();
            if (curObj == null || !curObj.equals(observer)) continue;
            removeObjs[j] = entry;
            ++j;
        }
        for (int i = 0; i < j; ++i) {
            weakArray.removeReference(removeObjs[i]);
        }
    }

    public synchronized void removeOmniscientObserver(Object observer) {
        if (this._omniscient != null) {
            this._omniscient.removeReferencesWithReferent(observer);
        }
    }

    public void removeObserver(Object observer) {
        this.removeObserver(observer, null, null);
    }

    public synchronized void removeObserver(Object observer, String name, Object object) {
        if (observer == null && name == null && object == null) {
            throw new IllegalArgumentException("Can't remove entry with null observer, null name, and null object from NSNotificationCenter");
        }
        if (name == null && object == null) {
            this.removeOmniscientObserver(observer);
            if (this._byObject != null) {
                this._removeReferencesWithReferentFromByObjectDict(observer, this._byObject);
            }
            if (this._byName != null) {
                Enumeration nameEnum = this._byName.keyEnumerator();
                while (nameEnum.hasMoreElements()) {
                    Object key = nameEnum.nextElement();
                    NSMutableArray stub = (NSMutableArray)this._byName.objectForKey(key);
                    WeakHashMap byNameByObject = (WeakHashMap)stub.objectAtIndex(0);
                    _NSWeakMutableArray byNameArray = (_NSWeakMutableArray)stub.objectAtIndex(1);
                    if (byNameByObject == null || byNameArray == null) {
                        throw new IllegalStateException("NSNotificationCenter is in an illegal state.");
                    }
                    if (byNameByObject != _byObjectPlaceholder) {
                        this._removeReferencesWithReferentFromByObjectDict(observer, byNameByObject);
                    }
                    if (byNameArray == _byNamePlaceholder) continue;
                    this._removeReferencesWithReferentFromWeakArray(observer, byNameArray);
                }
            }
        } else if (observer == null && object == null) {
            this._byName.removeObjectForKey(name);
        } else if (observer == null && name == null) {
            if (this._byObject != null) {
                this._byObject.remove(object);
            }
            Enumeration byNameObjectEnum = this._byName.objectEnumerator();
            while (byNameObjectEnum.hasMoreElements()) {
                WeakHashMap map = (WeakHashMap)((NSMutableArray)byNameObjectEnum.nextElement()).objectAtIndex(0);
                map.remove(object);
            }
        } else if (object == null) {
            NSMutableArray array = (NSMutableArray)this._byName.objectForKey(name);
            if (array != null) {
                _NSWeakMutableArray weakArray;
                WeakHashMap map = (WeakHashMap)array.objectAtIndex(0);
                if (map != _byObjectPlaceholder) {
                    Iterator _byNameByObjectIterator = map.values().iterator();
                    while (_byNameByObjectIterator.hasNext()) {
                        _NSWeakMutableArray weakArray2 = (_NSWeakMutableArray)_byNameByObjectIterator.next();
                        if (weakArray2 == null) continue;
                        this._removeReferencesWithReferentFromWeakArray(observer, weakArray2);
                    }
                }
                if ((weakArray = (_NSWeakMutableArray)array.objectAtIndex(1)) != null) {
                    this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
                }
            }
        } else if (name == null) {
            _NSWeakMutableArray weakArray = (_NSWeakMutableArray)this._byObject.get(object);
            if (weakArray != null) {
                this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
            }
            Enumeration _byNameEnumerator = this._byName.objectEnumerator();
            while (_byNameEnumerator.hasMoreElements()) {
                NSMutableArray array = (NSMutableArray)_byNameEnumerator.nextElement();
                WeakHashMap map = (WeakHashMap)array.objectAtIndex(0);
                weakArray = (_NSWeakMutableArray)map.get(object);
                if (weakArray == null) continue;
                this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
            }
        } else if (observer == null) {
            NSMutableArray array = (NSMutableArray)this._byName.objectForKey(name);
            if (array != null) {
                WeakHashMap map = (WeakHashMap)array.objectAtIndex(0);
                map.remove(object);
            }
        } else {
            _NSWeakMutableArray weakArray;
            WeakHashMap map;
            NSMutableArray array = (NSMutableArray)this._byName.objectForKey(name);
            if (array != null && (map = (WeakHashMap)array.objectAtIndex(0)) != _byObjectPlaceholder && (weakArray = (_NSWeakMutableArray)map.get(object)) != null) {
                this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
            }
        }
    }

    private static void _addObserversFromArrayToSet(_NSWeakMutableArray array, NSMutableSet observers) {
        if (array != null) {
            Enumeration refEnum = array.referenceEnumerator();
            while (refEnum.hasMoreElements()) {
                WeakReference ref = (WeakReference)refEnum.nextElement();
                if (ref == null) {
                    throw new IllegalStateException("Enumeration in NSNotificationCenter returned a null element.  What gives?");
                }
                observers.addObject(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postNotification(NSNotification notification) {
        Object obj = notification.object();
        NSMutableSet observers = new NSMutableSet(16);
        NSNotificationCenter nSNotificationCenter = this;
        synchronized (nSNotificationCenter) {
            NSMutableArray array;
            if (this._omniscient != null) {
                Object[] objects = this._omniscient.allReferencesNoCopy();
                for (int i = 0; i < objects.length; ++i) {
                    observers.addObject(objects[i]);
                }
            }
            if (this._byObject != null && obj != null) {
                NSNotificationCenter._addObserversFromArrayToSet((_NSWeakMutableArray)this._byObject.get(obj), observers);
            }
            if (this._byName != null && (array = (NSMutableArray)this._byName.objectForKey(notification.name())) != null) {
                WeakHashMap byObj;
                if (obj != null && (byObj = (WeakHashMap)array.objectAtIndex(0)) != _byObjectPlaceholder) {
                    NSNotificationCenter._addObserversFromArrayToSet((_NSWeakMutableArray)byObj.get(obj), observers);
                }
                NSNotificationCenter._addObserversFromArrayToSet((_NSWeakMutableArray)array.objectAtIndex(1), observers);
            }
        }
        Object[] targets = observers._allObjects();
        for (int i = 0; i < targets.length; ++i) {
            ((_Entry)targets[i]).invokeMethod(notification);
        }
    }

    public void postNotification(String notificationName, Object notificationObject) {
        this.postNotification(new NSNotification(notificationName, notificationObject, null));
    }

    public void postNotification(String notificationName, Object notificationObject, NSDictionary userInfo) {
        this.postNotification(new NSNotification(notificationName, notificationObject, userInfo));
    }

    private static class _Entry
    extends _NSWeakMutableCollection._NSWeakMutableCollectionReference {
        Method _method;

        public _Entry(Object observer, NSSelector sel, ReferenceQueue queue) {
            super(observer, queue);
            try {
                this._method = observer instanceof Class ? sel.methodOnClass((Class)observer) : sel.methodOnObject(observer);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("observer <" + observer.getClass() + "> doesn't implement method named " + sel.name() + " or this method is not public");
            }
        }

        public void invokeMethod(NSNotification notification) {
            Object ref = this.get();
            if (ref != null) {
                NSSelector._safeInvokeMethod(this._method, ref, new Object[]{notification});
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof _Entry) {
                Object myReferent = this.get();
                if (myReferent == null) {
                    return false;
                }
                Object otherReferent = ((_Entry)object).get();
                Method otherMethod = ((_Entry)object).method();
                return !(myReferent != otherReferent && !myReferent.equals(otherReferent) || this._method != otherMethod && !this._method.equals(otherMethod));
            }
            return false;
        }

        public Object observer() {
            return this.get();
        }

        public Method method() {
            return this._method;
        }

        public String toString() {
            Object observer = this.get();
            return (observer == null ? "NULL_OBSERVER" : observer) + "." + (this._method == null ? "NULL_METHOD" : this._method.getName());
        }
    }
}

