/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSLog;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class NSSocketUtilities {
    private NSSocketUtilities() {
    }

    public static Socket getSocketWithTimeout(String host, int port, int timeout) throws UnknownHostException, IOException {
        InetAddress hostAddress = null;
        try {
            hostAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            throw new UnknownHostException("Could not resolve hostname " + host + " in NSSocketUtilities.getSocketWithTimeout(String, int, int)");
        }
        return NSSocketUtilities.getSocketWithTimeout(hostAddress, port, timeout);
    }

    public static Socket getSocketWithTimeout(String host, int port, InetAddress localAddress, int localPort, int timeout) throws UnknownHostException, IOException {
        InetAddress hostAddress = null;
        try {
            hostAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            throw new UnknownHostException("Could not resolve hostname " + host + " in NSSocketUtilities.getSocketWithTimeout(String, int, InetAddress, int, int)");
        }
        return NSSocketUtilities.getSocketWithTimeout(hostAddress, port, localAddress, localPort, timeout);
    }

    public static Socket getSocketWithTimeout(InetAddress address, int port, int timeout) throws IOException {
        return new NSSocketUtilities()._getSocketWithTimeout(false, address, port, null, 0, timeout);
    }

    public static Socket getSocketWithTimeout(InetAddress address, int port, InetAddress localAddress, int localPort, int timeout) throws IOException {
        return new NSSocketUtilities()._getSocketWithTimeout(true, address, port, localAddress, localPort, timeout);
    }

    private Socket _getSocketWithTimeout(boolean bindLocal, InetAddress address, int port, InetAddress localAddress, int localPort, int timeout) throws IOException {
        if (timeout <= 0) {
            if (bindLocal) {
                return new Socket(address, port, localAddress, localPort);
            }
            return new Socket(address, port);
        }
        SocketThread aSocketThread = new SocketThread(bindLocal, address, port, localAddress, localPort);
        aSocketThread.start();
        try {
            aSocketThread.join(timeout);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (aSocketThread.exception != null) {
            throw aSocketThread.exception;
        }
        if (aSocketThread.returnSocket == null) {
            throw new IOException("Timed out trying to create Socket");
        }
        return aSocketThread.returnSocket;
    }

    public static int pollingInterval() {
        return 0;
    }

    public static void setPollingInterval(int interval) {
    }

    private class SocketThread
    extends Thread {
        protected volatile Socket returnSocket = null;
        protected volatile IOException exception = null;
        private boolean shouldBindLocal;
        private InetAddress aRemoteAddress;
        private int aRemotePort;
        private InetAddress aLocalAddress;
        private int aLocalPort;

        public SocketThread(boolean bindLocal, InetAddress address, int port, InetAddress localAddress, int localPort) {
            this.shouldBindLocal = bindLocal;
            this.aRemoteAddress = address;
            this.aRemotePort = port;
            this.aLocalAddress = localAddress;
            this.aLocalPort = localPort;
        }

        public void run() {
            this.returnSocket = null;
            try {
                this.returnSocket = this.shouldBindLocal ? new Socket(this.aRemoteAddress, this.aRemotePort, this.aLocalAddress, this.aLocalPort) : new Socket(this.aRemoteAddress, this.aRemotePort);
            }
            catch (IOException ex) {
                NSLog._conditionallyLogPrivateException(ex);
                this.exception = ex;
            }
        }
    }
}

