/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class WOBootstrap {
    private static final String APPROOT = "APPROOT";
    private static final String HOMEROOT = "HOMEROOT";
    private static final String LOCALROOT = "LOCALROOT";
    private static final String WEBINFROOT = "WEBINFROOT";
    private static final String WOAINSTALLROOT = "WOAINSTALLROOT";
    private static final String WOROOT = "WOROOT";
    private static String appRoot;
    private static String homeRoot;
    private static String localRoot;
    private static String webInfRoot;
    private static String woaInstallRoot;
    private static String woRoot;
    private static String classpathFilePath;
    private static String envClassPath;
    private static String platform;
    private static String woAppClass;
    private static URLClassLoader classLoader;
    private static File classpathFile;
    private static String classpath;
    private static String[] tokenizedClasspath;
    private static JavaArchiveFilter jaf;

    public static void main(String[] stringArray) {
        WOBootstrap.initializeFromCommandLineProperties();
        WOBootstrap.readInClasspathFromFile();
        Properties properties = System.getProperties();
        properties.put("com.webobjects.classpath", WOBootstrap.mangleClasspathForBundle(classpath));
        classLoader = new URLClassLoader(WOBootstrap.mangleClasspathForClassLoader(classpath), WOBootstrap.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Class<?> clazz;
            if (woAppClass == null) {
                System.err.println("WOApplicationClass is null, defaulting to com.webobjects.appserver.WOApplication");
                woAppClass = "com.webobjects.appserver.WOApplication";
            }
            if ((clazz = classLoader.loadClass(woAppClass)) != null) {
                Method method = clazz.getMethod("main", new String[0].getClass());
                method.invoke(clazz, new Object[]{stringArray});
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Can't load " + woAppClass + " class, exiting...");
            classNotFoundException.printStackTrace(System.err);
            System.exit(1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Can't find main method on class " + woAppClass + ", exiting...");
            noSuchMethodException.printStackTrace(System.err);
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Can't invoke main method on class " + woAppClass + ", exiting...");
            illegalAccessException.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromFile(File file) {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            int n = (int)file.length();
            fileInputStream = new FileInputStream(file);
            byArray = new byte[n];
            for (int i = 0; i < n; i += fileInputStream.read(byArray, i, n - i)) {
            }
        }
        catch (IOException iOException) {
            System.err.println("Exception while reading from file: " + iOException.getMessage());
            System.err.println(iOException);
        }
        finally {
            if (file != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println("Exception while closing file input stream: " + iOException.getMessage());
                    System.err.println(iOException);
                }
                file = null;
            }
        }
        return new String(byArray);
    }

    private static String getRealPath(String string) {
        Object var1_1 = null;
        if (string == null) {
            return null;
        }
        if (string.charAt(0) == '#') {
            WOBootstrap.processComment(string);
            return null;
        }
        boolean bl = string.indexOf(".framework") != -1;
        int n = string.indexOf(WOROOT);
        if (n != -1) {
            string = WOBootstrap.mangleWithAppRoot(string, WOROOT, woRoot, n, bl);
        } else {
            n = string.indexOf(LOCALROOT);
            if (n != -1) {
                string = WOBootstrap.mangleWithAppRoot(string, LOCALROOT, localRoot, n, bl);
            } else {
                n = string.indexOf(HOMEROOT);
                if (n != -1) {
                    string = WOBootstrap.mangleWithAppRoot(string, HOMEROOT, homeRoot, n, bl);
                } else {
                    n = string.indexOf(APPROOT);
                    if (n != -1) {
                        string = WOBootstrap.mangleForRealPath(string, APPROOT, appRoot, n);
                    } else {
                        n = string.indexOf(WOAINSTALLROOT);
                        if (n != -1) {
                            string = WOBootstrap.mangleForRealPath(string, WOAINSTALLROOT, woaInstallRoot, n);
                        } else {
                            n = string.indexOf(WEBINFROOT);
                            if (n != -1) {
                                string = WOBootstrap.mangleForRealPath(string, WEBINFROOT, webInfRoot, n);
                            }
                        }
                    }
                }
            }
        }
        if (string != null) {
            try {
                File file = new File(string);
                if (file != null && file.exists() && file.isDirectory() && (string = file.getCanonicalPath()).charAt(string.length() - 1) != File.separatorChar) {
                    string = string + File.separator;
                }
            }
            catch (IOException iOException) {
                System.err.println("Exception loading path for " + string + ": " + iOException);
                return null;
            }
        }
        return string;
    }

    private static String mangleForRealPath(String string, String string2, String string3, int n) {
        return string3 + string.substring(n + string2.length());
    }

    private static String mangleWithAppRoot(String string, String string2, String string3, int n, boolean bl) {
        String string4;
        File file;
        if (bl && !string3.equals(appRoot) && (file = new File(string4 = WOBootstrap.mangleForRealPath(string, string2, appRoot, n))) != null && file.exists()) {
            return string4;
        }
        return WOBootstrap.mangleForRealPath(string, string2, string3, n);
    }

    private static void processComment(String string) {
        String string2;
        int n;
        int n2;
        if (woAppClass == null && (n2 = string.indexOf("ApplicationClass")) != -1 && (n = string.indexOf("==", n2) + 2) > 1 && n < string.length() - 1 && (string2 = string.substring(n, string.length())) != null && !(string2 = string2.trim()).equals("")) {
            System.out.println("Setting WOApplicationClass to " + string2);
            woAppClass = string2;
        }
    }

    private static String[] tokenizeClasspath(String string) {
        if (tokenizedClasspath == null) {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = WOBootstrap.getRealPath(stringTokenizer.nextToken().trim());
                if (string2 == null) continue;
                arrayList.add(string2);
            }
            WOBootstrap.addArchivesToList(new File(appRoot + "/Extensions/"), arrayList);
            WOBootstrap.addArchivesToList(new File(localRoot + "/Library/WebObjects/Extensions/"), arrayList);
            if (envClassPath != null && !envClassPath.equals("")) {
                stringTokenizer = new StringTokenizer(envClassPath, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = WOBootstrap.getRealPath(stringTokenizer.nextToken().trim());
                    if (string2 == null) continue;
                    arrayList.add(string2);
                }
            }
            tokenizedClasspath = arrayList.toArray(new String[0]);
            System.out.println("Generated classpath: ");
            for (int i = 0; i < tokenizedClasspath.length; ++i) {
                System.out.println("  " + tokenizedClasspath[i]);
            }
        }
        return tokenizedClasspath;
    }

    private static void addArchivesToList(File file, ArrayList arrayList) {
        if (file != null && file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles(jaf);
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    arrayList.add(fileArray[i].getCanonicalPath());
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                arrayList.add(file.getCanonicalPath() + File.separator);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static URL[] mangleClasspathForClassLoader(String string) {
        String string2 = File.pathSeparatorChar == ';' ? "file:///" : "file://";
        String[] stringArray = WOBootstrap.tokenizeClasspath(string);
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                uRLArray[i] = new URL(string2 + stringArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error creating URL " + throwable);
            }
        }
        return uRLArray;
    }

    private static String mangleClasspathForBundle(String string) {
        String[] stringArray = WOBootstrap.tokenizeClasspath(string);
        StringBuffer stringBuffer = new StringBuffer(string.length() + stringArray.length);
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static void initializeFromCommandLineProperties() {
        int n;
        String string = System.getProperty("java.class.path");
        if (string != null && (n = string.indexOf(".app")) != -1) {
            int n2 = string.lastIndexOf(File.pathSeparatorChar, n);
            String string2 = string.substring(++n2, n + 4);
            System.setProperty("webobjects.user.dir", string2);
        }
        woRoot = System.getProperty("WORootDirectory");
        localRoot = System.getProperty("WOLocalRootDirectory");
        appRoot = System.getProperty("webobjects.user.dir");
        if (appRoot == null) {
            appRoot = System.getProperty("user.dir");
        }
        homeRoot = System.getProperty("user.home");
        webInfRoot = woaInstallRoot = (appRoot = appRoot + "/Contents");
        System.out.println("appRoot is " + appRoot);
        envClassPath = System.getProperty("WOEnvClassPath");
        woAppClass = System.getProperty("WOApplicationClass");
        platform = System.getProperty("WOPlatform");
        classpathFilePath = System.getProperty("WOClasspathFilePath");
        if (localRoot == null) {
            System.err.println("WOLocalRootDirectory is null, defaulting to APPROOT (" + appRoot + ") ");
            localRoot = appRoot;
        }
        if (woRoot == null) {
            System.err.println("WORootDirectory is null, defaulting to APPROOT (" + appRoot + ") ");
            woRoot = appRoot;
        }
    }

    public static void readInClasspathFromFile() {
        if (classpathFilePath == null) {
            if ("UNIX".equals(platform)) {
                classpathFilePath = appRoot + "/UNIX/UNIXClassPath.txt";
            } else if ("Windows".equals(platform)) {
                classpathFilePath = appRoot + "/Windows/CLSSPATH.TXT";
            } else if ("MacOS".equals(platform)) {
                classpathFilePath = appRoot + "/MacOS/MacOSClassPath.txt";
            } else {
                System.err.println("Unrecognized platform: " + platform + ", defaulting to MacOS");
                classpathFilePath = appRoot + "/MacOS/MacOSClassPath.txt";
            }
        }
        System.out.println("Loading " + classpathFilePath);
        if (classpathFilePath != null) {
            classpathFile = new File(classpathFilePath);
            classpath = WOBootstrap.stringFromFile(classpathFile);
        }
        if (classpath == null) {
            System.err.println(classpathFilePath + " could not be read");
            classpath = "";
        }
    }

    static {
        jaf = new JavaArchiveFilter();
    }

    public static class JavaArchiveFilter
    implements FilenameFilter {
        private static final String JAR = ".jar";
        private static final String ZIP = ".zip";

        public boolean accept(File file, String string) {
            String string2;
            return string != null && ((string2 = string.toLowerCase()).endsWith(JAR) || string2.endsWith(ZIP));
        }
    }
}

