/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.movies.common;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSValidation;
import er.extensions.eof.ERXGenericRecord;
import java.math.BigDecimal;
import webobjectsexamples.businesslogic.movies.common.Talent;

public abstract class Studio
extends ERXGenericRecord {
    public static final String BudgetKey = "budget";
    public static final String MovieKey = "movies";
    public static final String NameKey = "name";
    public static final BigDecimal DefaultBudget = new BigDecimal("1000000.00");

    public void awakeFromInsertion(EOEditingContext editingContext) {
        super.awakeFromInsertion(editingContext);
        if (this.budget() == null) {
            this.setBudget(DefaultBudget);
        }
    }

    public Object validateBudget(Number value) throws NSValidation.ValidationException {
        if (value.intValue() < 100) {
            throw new NSValidation.ValidationException("A studio's budget cannot be less than $100!");
        }
        return value;
    }

    public Number budget() {
        return (Number)this.storedValueForKey(BudgetKey);
    }

    public void setBudget(Number value) {
        this.takeStoredValueForKey(value, BudgetKey);
    }

    public NSArray movies() {
        return (NSArray)this.storedValueForKey(MovieKey);
    }

    public void setMovies(NSArray value) {
        this.takeStoredValueForKey(value, MovieKey);
    }

    public void addToMovies(EOEnterpriseObject object) {
        this.includeObjectIntoPropertyWithKey(object, MovieKey);
    }

    public void removeFromMovies(EOEnterpriseObject object) {
        this.excludeObjectFromPropertyWithKey(object, MovieKey);
    }

    public Number portfolioValue() {
        double total = 0.0;
        NSArray revenues = (NSArray)this.movies().valueForKey("revenue");
        int count = revenues.count();
        for (int i = 0; i < count; ++i) {
            Object revenue = revenues.objectAtIndex(i);
            if (revenue == NSKeyValueCoding.NullValue) continue;
            total += ((Number)revenue).doubleValue();
        }
        return new BigDecimal(total * 1.5);
    }

    public abstract void buyAllMoviesStarringTalent(Talent var1);

    public void setName(String value) {
        this.takeStoredValueForKey(value, NameKey);
    }
}

