/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.movies.common;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import webobjectsexamples.businesslogic.movies.common._Talent;

public class Talent
extends _Talent {
    private static final long serialVersionUID = -5942077710497738108L;
    public static final String FirstNameKey = "firstName";
    public static final String LastNameKey = "lastName";
    public static final String MoviesDirectedKey = "moviesDirected";
    public static final String PhotoKey = "photo";
    public static final String RolesKey = "roles";

    public String firstName() {
        return (String)this.storedValueForKey(FirstNameKey);
    }

    public String lastName() {
        return (String)this.storedValueForKey(LastNameKey);
    }

    public NSArray roles() {
        return (NSArray)this.storedValueForKey(RolesKey);
    }

    public String fullName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.firstName());
        buffer.append(' ');
        buffer.append(this.lastName());
        return new String(buffer);
    }

    public NSArray moviesStarredIn() {
        NSMutableArray moviesStarredIn = new NSMutableArray();
        NSArray movies = (NSArray)this.roles().valueForKey("movie");
        if (movies != null) {
            int count = movies.count();
            for (int i = 0; i < count; ++i) {
                Object movie = movies.objectAtIndex(i);
                if (movie == NSKeyValueCoding.NullValue || moviesStarredIn.containsObject(movie)) continue;
                moviesStarredIn.addObject(movie);
            }
        }
        return moviesStarredIn;
    }

    public boolean isDirector() {
        NSArray moviesDirected = (NSArray)this.valueForKey(MoviesDirectedKey);
        return moviesDirected != null && moviesDirected.count() > 0;
    }
}

