/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.rentals.common;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGenericRecord;

public class User
extends EOGenericRecord {
    private static final long serialVersionUID = -4880721435398743375L;
    public static final String AccessLevelKey = "accessLevel";
    public static final String CustomerKey = "customer";
    public static final String PasswordKey = "password";
    public static final String UsernameKey = "username";
    public static final int NoAccessLevel = 4;
    public static final int CustomerAccessLevel = 3;
    public static final int EmployeeAccessLevel = 2;
    public static final int AdministratorAccessLevel = 1;

    public void awakeFromInsertion(EOEditingContext editingContext) {
        super.awakeFromInsertion(editingContext);
        if (this.accessLevel() == null) {
            this.setAccessLevel(new Integer(4));
        }
    }

    public Number accessLevel() {
        return (Number)this.storedValueForKey(AccessLevelKey);
    }

    public void setAccessLevel(Number value) {
        this.takeStoredValueForKey(value, AccessLevelKey);
    }

    private boolean _hasAccessLevel(int level) {
        Number accessLevel = this.accessLevel();
        return accessLevel != null && accessLevel.intValue() <= level;
    }

    public boolean hasAdministratorAccessLevel() {
        return this._hasAccessLevel(1);
    }

    public boolean hasEmployeeAccessLevel() {
        return this._hasAccessLevel(2);
    }

    public boolean hasCustomerAccessLevel() {
        return this._hasAccessLevel(3);
    }
}

