/*
 * Decompiled with CFR 0.152.
 */
package er.openid;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORedirect;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSDictionary;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXRequest;
import er.extensions.foundation.ERXProperties;
import er.openid.EROFormRedirectionPage;
import er.openid.EROResponse;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.util.HttpClientFactory;
import org.openid4java.util.ProxyProperties;

public class EROpenIDManager {
    public static final Logger log = Logger.getLogger(EROpenIDManager.class);
    private static final String DISCOVERY_INFO_KEY = "openIDDiscoveryInfo";
    private static EROpenIDManager _openIDManager;
    private ConsumerManager _manager = new ConsumerManager();
    private Delegate _delegate;

    public static synchronized EROpenIDManager manager() {
        if (_openIDManager == null) {
            try {
                _openIDManager = new EROpenIDManager();
                _openIDManager.setDelegate(new DefaultDelegate());
            }
            catch (ConsumerException e) {
                throw new RuntimeException("Failed to create EROpenIDManager.", e);
            }
        }
        return _openIDManager;
    }

    protected EROpenIDManager() throws ConsumerException {
        boolean disableRealmVerifier = ERXProperties.booleanForKeyWithDefault((String)"er.openid.disableRealmVerifier", (boolean)false);
        if (disableRealmVerifier) {
            this._manager.getRealmVerifier().setEnforceRpId(false);
            log.info((Object)"Disabling realm verifier.");
        }
    }

    public void setDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    public boolean isOpenIDAuth(String userSuppliedString) {
        return userSuppliedString != null && userSuppliedString.toLowerCase().startsWith("http://");
    }

    public WOActionResults authRequest(String userSuppliedString, String realm, WORequest request, WOContext context) throws MessageException, DiscoveryException, ConsumerException {
        WOSession session = context.session();
        String proxyHostName = ERXProperties.stringForKey((String)"er.openid.proxyHostName");
        if (proxyHostName != null) {
            int proxyPort = ERXProperties.intForKey((String)"er.openid.proxyPort");
            ProxyProperties proxyProps = new ProxyProperties();
            proxyProps.setProxyHostName(proxyHostName);
            proxyProps.setProxyPort(proxyPort);
            HttpClientFactory.setProxyProperties((ProxyProperties)proxyProps);
        }
        List discoveries = this._manager.discover(userSuppliedString);
        DiscoveryInformation discovered = this._manager.associate(discoveries);
        Object results = null;
        if (discovered != null) {
            session.setObjectForKey((Object)discovered, DISCOVERY_INFO_KEY);
            String returnToUrl = this._delegate.returnToUrl(request, context);
            AuthRequest authReq = this._manager.authenticate(discovered, returnToUrl, realm);
            List<MessageExtension> exts = this._delegate.createFetchMessageExtensions(userSuppliedString, request, context);
            for (MessageExtension ext : exts) {
                log.debug((Object)("Authentication request extension: " + ext));
                authReq.addExtension(ext);
            }
            if (!discovered.isVersion2()) {
                WORedirect redirect = new WORedirect(context);
                String url = authReq.getDestinationUrl(true);
                log.debug((Object)("Request URL: " + url));
                redirect.setUrl(url);
                results = redirect;
            } else {
                String formRedirectionPageName = ERXProperties.stringForKeyWithDefault((String)"er.openid.formRedirectionPageName", (String)EROFormRedirectionPage.class.getName());
                EROFormRedirectionPage formRedirectionPage = (EROFormRedirectionPage)WOApplication.application().pageWithName(formRedirectionPageName, context);
                formRedirectionPage.setParameters(authReq.getParameterMap());
                String url = authReq.getDestinationUrl(false);
                log.debug((Object)("Request URL: " + url));
                formRedirectionPage.takeValueForKey(url, "redirectionUrl");
                results = formRedirectionPage;
            }
        }
        return results;
    }

    public EROResponse verifyResponse(WORequest request, WOContext context) throws MessageException, DiscoveryException, AssociationException {
        WOSession session = context.session();
        ParameterList responseParameters = new ParameterList();
        Enumeration formValueKeyEnum = request.formValueKeys().objectEnumerator();
        while (formValueKeyEnum.hasMoreElements()) {
            String formValueKey = (String)formValueKeyEnum.nextElement();
            String formValue = request.stringFormValueForKey(formValueKey);
            responseParameters.set(new Parameter(formValueKey, formValue));
            log.debug((Object)("Response parameter: " + formValueKey + " => " + formValue));
        }
        DiscoveryInformation discovered = (DiscoveryInformation)session.objectForKey(DISCOVERY_INFO_KEY);
        String receivingUrl = this._delegate.rewriteReceivingUrl(request, context);
        VerificationResult verification = this._manager.verify(receivingUrl, responseParameters, discovered);
        FetchResponse fetchResponse = null;
        ArrayList<MessageExtension> messageExtensions = new ArrayList<MessageExtension>();
        Identifier identifier = verification.getVerifiedId();
        if (identifier != null) {
            MessageExtension ext;
            AuthSuccess authSuccess = AuthSuccess.createAuthSuccess((ParameterList)responseParameters);
            log.debug((Object)("AuthSucess:" + authSuccess));
            if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                ext = authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                messageExtensions.add(ext);
                log.debug((Object)("MessageExtension (AX):" + ext));
                if (ext instanceof FetchResponse && fetchResponse == null) {
                    fetchResponse = (FetchResponse)ext;
                }
            }
            if (authSuccess.hasExtension("http://openid.net/sreg/1.0")) {
                ext = authSuccess.getExtension("http://openid.net/sreg/1.0");
                messageExtensions.add(ext);
                log.debug((Object)("MessageExtension (SREG):" + ext));
            }
            if (authSuccess.hasExtension("http://openid.net/extensions/sreg/1.1")) {
                ext = authSuccess.getExtension("http://openid.net/extensions/sreg/1.1");
                messageExtensions.add(ext);
                log.debug((Object)("MessageExtension (SREG11):" + ext));
            }
        }
        EROResponse eroResponse = new EROResponse(identifier, fetchResponse, messageExtensions);
        this._delegate.responseReceived(verification, eroResponse, request, context);
        return eroResponse;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmailDelegate
    extends DefaultDelegate {
        @Override
        public List<MessageExtension> createFetchMessageExtensions(String userSuppliedString, WORequest request, WOContext context) throws MessageException {
            ArrayList<MessageExtension> exts = new ArrayList<MessageExtension>();
            FetchRequest fetchRequest = FetchRequest.createFetchRequest();
            fetchRequest.addAttribute("email-axschema", "http://axschema.org/contact/email", true);
            fetchRequest.addAttribute("email-openid", "http://schema.openid.net/contact/email", true);
            exts.add((MessageExtension)fetchRequest);
            SRegRequest sregRequest = SRegRequest.createFetchRequest();
            sregRequest.addAttribute("email", true);
            exts.add((MessageExtension)sregRequest);
            return exts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultDelegate
    implements Delegate {
        @Override
        public List<MessageExtension> createFetchMessageExtensions(String userSuppliedString, WORequest request, WOContext context) throws MessageException {
            MessageExtension fetchRequest = this.createFetchRequest(userSuppliedString, request, context);
            ArrayList<MessageExtension> exts = new ArrayList<MessageExtension>();
            if (fetchRequest != null) {
                exts.add(fetchRequest);
            }
            return exts;
        }

        @Override
        @Deprecated
        public MessageExtension createFetchRequest(String userSuppliedString, WORequest request, WOContext context) throws MessageException {
            return null;
        }

        @Override
        public void responseReceived(VerificationResult verification, EROResponse eroResponse, WORequest request, WOContext context) {
        }

        @Override
        public String returnToUrl(WORequest request, WOContext context) {
            String returnToUrl;
            boolean requireSecureReturnURL = ERXProperties.booleanForKeyWithDefault((String)"er.openid.requireSecureReturnURL", (boolean)true);
            if (ERXApplication.isWO54()) {
                try {
                    if (requireSecureReturnURL) {
                        Method directActionURLForActionNamedMethod = context.getClass().getMethod("directActionURLForActionNamed", String.class, NSDictionary.class, Boolean.TYPE, Boolean.TYPE);
                        returnToUrl = (String)directActionURLForActionNamedMethod.invoke((Object)context, "ERODirectAction/openIDResponse", null, Boolean.TRUE, Boolean.TRUE);
                    }
                    returnToUrl = context.directActionURLForActionNamed("ERODirectAction/openIDResponse", new NSDictionary());
                }
                catch (Exception e) {
                    throw new RuntimeException("directActionURLForActionNamed failed.", e);
                }
            } else {
                context._generateCompleteURLs();
                try {
                    if (requireSecureReturnURL) {
                        Method _directActionURLMethod = context.getClass().getMethod("_directActionURL", String.class, NSDictionary.class, Boolean.TYPE);
                        returnToUrl = (String)_directActionURLMethod.invoke((Object)context, "ERODirectAction/openIDResponse", null, Boolean.TRUE);
                    } else {
                        returnToUrl = context.directActionURLForActionNamed("ERODirectAction/openIDResponse", new NSDictionary());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("_directActionURL failed.", e);
                }
                finally {
                    context._generateRelativeURLs();
                }
            }
            log.debug((Object)("Return to URL: " + returnToUrl));
            return returnToUrl;
        }

        @Override
        public String rewriteReceivingUrl(WORequest request, WOContext context) {
            StringBuffer receivingUrlBuffer = new StringBuffer();
            int serverPort = 0;
            String serverPortStr = request._serverPort();
            if (serverPortStr != null) {
                serverPort = Integer.parseInt(serverPortStr);
            }
            request._completeURLPrefix(receivingUrlBuffer, ERXRequest.isRequestSecure((WORequest)request), serverPort);
            receivingUrlBuffer.append(request.uri());
            return receivingUrlBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Delegate {
        public List<MessageExtension> createFetchMessageExtensions(String var1, WORequest var2, WOContext var3) throws MessageException;

        @Deprecated
        public MessageExtension createFetchRequest(String var1, WORequest var2, WOContext var3) throws MessageException;

        public void responseReceived(VerificationResult var1, EROResponse var2, WORequest var3, WOContext var4);

        public String returnToUrl(WORequest var1, WOContext var2);

        public String rewriteReceivingUrl(WORequest var1, WOContext var2);
    }
}

