/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxComponent;
import er.ajax.AjaxOption;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class AjaxDraggable
extends AjaxComponent {
    private static final String COMPONENT_DRAGGABLES_MAP_KEY = "AjaxComponentDraggablesMap";
    private String _id;

    public AjaxDraggable(WOContext context) {
        super(context);
    }

    public void awake() {
        super.awake();
    }

    public void reset() {
        this._id = null;
        super.reset();
    }

    public boolean isStateless() {
        return true;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public static Object draggableObjectForPage(WOComponent page, String draggableID) {
        Map draggablesMap;
        Object droppedObject = null;
        Map componentDraggablesMap = (Map)page.context().session().objectForKey(COMPONENT_DRAGGABLES_MAP_KEY);
        if (componentDraggablesMap != null && (draggablesMap = (Map)componentDraggablesMap.get(page)) != null) {
            droppedObject = draggablesMap.get(draggableID);
        }
        return droppedObject;
    }

    public void appendToResponse(WOResponse res, WOContext ctx) {
        if (this.canGetValueForBinding("draggableObject")) {
            HashMap<String, Object> draggablesMap;
            Object draggableObject = this.valueForBinding("draggableObject");
            WOComponent page = this.context().page();
            WeakHashMap componentDraggablesMap = (WeakHashMap)ctx.session().objectForKey(COMPONENT_DRAGGABLES_MAP_KEY);
            if (componentDraggablesMap == null) {
                componentDraggablesMap = new WeakHashMap();
                ctx.session().setObjectForKey(componentDraggablesMap, COMPONENT_DRAGGABLES_MAP_KEY);
            }
            if ((draggablesMap = (HashMap<String, Object>)componentDraggablesMap.get(page)) == null) {
                draggablesMap = new HashMap<String, Object>();
                componentDraggablesMap.put(page, draggablesMap);
            }
            String id = this.draggableID();
            if (draggableObject == null) {
                draggablesMap.remove(id);
            } else {
                draggablesMap.put(id, draggableObject);
            }
        }
        super.appendToResponse(res, ctx);
    }

    public NSDictionary createAjaxOptions() {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("starteffect", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("reverteffect", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("endeffect", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("zindex", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("revert", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("snap", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("ghosting", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("handle", AjaxOption.DEFAULT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("change", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("keyPress", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("scroll", AjaxOption.SCRIPT));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, this);
        return options;
    }

    public String id() {
        if (this._id == null) {
            if (this.canGetValueForBinding("id") && this.valueForBinding("id") != null) {
                this._id = (String)this.valueForBinding("id");
            } else {
                this._id = this.safeElementID();
                if (this.canSetValueForBinding("id")) {
                    this.setValueForBinding(this._id, "id");
                }
            }
        }
        return this._id;
    }

    public String elementName() {
        return (String)this.valueForBinding("elementName", "div");
    }

    public String draggableID() {
        String draggableID = this.canGetValueForBinding("draggableID") ? (String)this.valueForBinding("draggableID") : this.id();
        return draggableID;
    }

    protected void addRequiredWebResources(WOResponse res) {
        this.addScriptResourceInHead(res, "prototype.js");
        this.addScriptResourceInHead(res, "effects.js");
        this.addScriptResourceInHead(res, "dragdrop.js");
        this.addScriptResourceInHead(res, "wonder.js");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        return null;
    }
}

