/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.formatters.ERXUnitAwareDecimalFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AjaxProgress {
    private String _id;
    private long _value;
    private long _maximum;
    private boolean _done;
    private Throwable _failure;
    private boolean _canceled;
    private boolean _completionEventsFired;
    private boolean _reset;
    private String _status;

    public AjaxProgress(int maximum) {
        this("AjaxProgress" + System.currentTimeMillis(), maximum);
    }

    public AjaxProgress(String id, int maximum) {
        this._id = id;
        this._maximum = maximum;
    }

    public String id() {
        return this._id;
    }

    public void setValue(long value) {
        this._value = value;
    }

    public long value() {
        long value = this.isSucceeded() ? this.maximum() : this._value;
        return value;
    }

    public void incrementValue(long count) {
        this._value += count;
    }

    public void setMaximum(long maximum) {
        this._maximum = maximum;
    }

    public long maximum() {
        return this._maximum;
    }

    public double percentage() {
        double value = this.value();
        double maximum = this.maximum();
        double percentage = 0.0;
        if (maximum > 0.0) {
            percentage = value / maximum;
        }
        return percentage;
    }

    public boolean isStarted() {
        return this._value > 0L;
    }

    public void setDone(boolean done) {
        this._done = done;
    }

    public boolean isDone() {
        return this._done;
    }

    public void setFailure(Throwable failure) {
        this._failure = failure;
    }

    public Throwable failure() {
        return this._failure;
    }

    public void cancel() {
        this._canceled = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public boolean isFailed() {
        return !this._canceled && this._failure != null;
    }

    public boolean isSucceeded() {
        return this._done && !this._reset && !this._canceled && this._failure == null;
    }

    public void dispose() {
        this._completionEventsFired = false;
    }

    public void setCompletionEventsFired(boolean completionEventsFired) {
        this._completionEventsFired = completionEventsFired;
    }

    public boolean completionEventsFired() {
        return this._completionEventsFired;
    }

    public void reset() {
        this._reset = true;
    }

    public boolean shouldReset() {
        return this._reset;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public String status() {
        return this._status;
    }

    public void copyAndTrack(InputStream inputStream, OutputStream outputStream, long maxSize) throws IOException {
        byte[] buffer = new byte[65536];
        try {
            boolean done = false;
            do {
                int bytesRead;
                if ((bytesRead = inputStream.read(buffer)) <= 0) {
                    done = true;
                    continue;
                }
                this.incrementValue(bytesRead);
                if (maxSize > 0L && this._value > maxSize) {
                    throw new IOException("The provided stream exceeded the maximum length of " + new ERXUnitAwareDecimalFormat("byte").format(maxSize) + " bytes.");
                }
                outputStream.write(buffer, 0, bytesRead);
            } while (!done && !this.isCanceled() && !this.shouldReset());
            if (this.isCanceled() || this.shouldReset()) {
                this.dispose();
            }
        }
        catch (IOException e) {
            this.dispose();
            this.setFailure(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.dispose();
            this.setFailure(e);
            throw e;
        }
    }

    public static void registerProgress(WOSession session, AjaxProgress progress) {
        NSMutableDictionary progresses = (NSMutableDictionary)session.objectForKey("_ajaxProgresses");
        if (progresses == null) {
            progresses = new NSMutableDictionary();
            session.setObjectForKey((Object)progresses, "_ajaxProgresses");
        }
        progresses.setObjectForKey((Object)progress, (Object)progress.id());
    }

    public static void unregisterProgress(WOSession session, AjaxProgress progress) {
        NSMutableDictionary progresses = (NSMutableDictionary)session.objectForKey("_ajaxProgresses");
        if (progresses != null && progress.id() != null) {
            progresses.removeObjectForKey((Object)progress.id());
        }
    }

    public static AjaxProgress progress(WOSession session, String id) {
        AjaxProgress progress = null;
        NSDictionary progresses = (NSDictionary)session.objectForKey("_ajaxProgresses");
        if (progresses != null) {
            progress = (AjaxProgress)progresses.objectForKey((Object)id);
        }
        return progress;
    }
}

