/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.appserver.ERXKeepAliveResponse;
import er.extensions.foundation.ERXSelectorUtilities;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class AjaxPushRequestHandler
extends WORequestHandler {
    public static final String AjaxCometRequestHandlerKey = "push";
    protected static Logger log = Logger.getLogger(AjaxPushRequestHandler.class);
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, ERXKeepAliveResponse>> responses = new ConcurrentHashMap();

    public AjaxPushRequestHandler() {
        NSNotificationCenter.defaultCenter().addObserver((Object)this, ERXSelectorUtilities.notificationSelector((String)"sessionDidTimeOut"), "SessionDidTimeOutNotification", null);
    }

    public void sessionDidTimeOut(NSNotification n) {
        String id = (String)n.object();
        ConcurrentHashMap<String, ERXKeepAliveResponse> sessionResponses = responses.get(id);
        if (sessionResponses != null) {
            for (ERXKeepAliveResponse response : sessionResponses.values()) {
                response.reset();
            }
            responses.remove(id);
        }
    }

    public WOResponse handleRequest(WORequest request) {
        String sessionID = request.sessionID();
        String name = request.requestHandlerPath();
        ERXKeepAliveResponse response = AjaxPushRequestHandler.responseForSessionIDNamed(sessionID, name);
        response.reset();
        return response;
    }

    private static ERXKeepAliveResponse responseForSessionIDNamed(String sessionID, String name) {
        ERXKeepAliveResponse response = null;
        if (sessionID != null) {
            ConcurrentHashMap<String, Object> sessionResponses;
            if (name == null) {
                name = "";
            }
            if ((sessionResponses = responses.get(sessionID)) == null) {
                ConcurrentHashMap newSessionResponses = new ConcurrentHashMap();
                ConcurrentHashMap prevSessionResponses = responses.putIfAbsent(sessionID, newSessionResponses);
                ConcurrentHashMap<Object, Object> concurrentHashMap = sessionResponses = prevSessionResponses == null ? newSessionResponses : prevSessionResponses;
            }
            if ((response = sessionResponses.get(name)) == null) {
                ERXKeepAliveResponse newResponse = new ERXKeepAliveResponse();
                ERXKeepAliveResponse prevResponse = sessionResponses.putIfAbsent(name, newResponse);
                response = prevResponse == null ? newResponse : prevResponse;
            }
        }
        return response;
    }

    public static boolean isResponseOpen(String sessionID, String name) {
        ERXKeepAliveResponse response = AjaxPushRequestHandler.responseForSessionIDNamed(sessionID, name);
        return response != null;
    }

    public static void stop(String sessionID, String name) {
        ERXKeepAliveResponse response;
        Map sessionResponses = responses.get(sessionID);
        if (sessionResponses != null && (response = (ERXKeepAliveResponse)sessionResponses.get(name)) != null) {
            response.reset();
            sessionResponses.remove(name);
        }
    }

    public static void push(String sessionID, String name, String message) {
        ERXKeepAliveResponse response = AjaxPushRequestHandler.responseForSessionIDNamed(sessionID, name);
        if (response != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(message.length());
            sb.append(':');
            response.push(sb.toString());
            response.push(message);
        }
    }

    public static void push(String sessionID, String name, NSData message) {
        ERXKeepAliveResponse response = AjaxPushRequestHandler.responseForSessionIDNamed(sessionID, name);
        if (response != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(message.length());
            sb.append(':');
            response.push(sb.toString());
            response.push(message.bytes());
        }
    }
}

