/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.json.serializer;

import com.webobjects.eocontrol._EOCheapCopyArray;
import com.webobjects.eocontrol._EOCheapCopyMutableArray;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import java.util.Enumeration;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NSArraySerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{NSArray.class, NSMutableArray.class, _EOCheapCopyArray.class, _EOCheapCopyMutableArray.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && NSArray.class.isAssignableFrom(clazz);
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        NSArray nsarray = (NSArray)o;
        JSONObject obj = new JSONObject();
        JSONArray arr = new JSONArray();
        if (this.ser.getMarshallClassHints()) {
            try {
                obj.put("javaClass", (Object)o.getClass().getName());
            }
            catch (JSONException e) {
                throw new MarshallException("javaClass not found!");
            }
        }
        try {
            obj.put("nsarray", (Object)arr);
            state.push(o, (Object)arr, (Object)"nsarray");
        }
        catch (JSONException e) {
            throw new MarshallException("Error setting nsarray: " + (Object)((Object)e));
        }
        int index = 0;
        try {
            Enumeration e = nsarray.objectEnumerator();
            while (e.hasMoreElements()) {
                Object json = this.ser.marshall(state, (Object)arr, e.nextElement(), (Object)new Integer(index));
                if (JSONSerializer.CIRC_REF_OR_DUPLICATE != json) {
                    arr.put(json);
                } else {
                    arr.put(JSONObject.NULL);
                }
                ++index;
            }
        }
        catch (MarshallException e) {
            throw (MarshallException)new MarshallException("element " + index).initCause((Throwable)e);
        }
        finally {
            state.pop();
        }
        return obj;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONArray jsonNSArray;
        Class<?> klass;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", (Throwable)e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        try {
            klass = Class.forName(java_class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnmarshallException("Could not find class named: " + java_class);
        }
        if (!NSArray.class.isAssignableFrom(klass)) {
            throw new UnmarshallException("not an NSArray");
        }
        try {
            jsonNSArray = jso.getJSONArray("nsarray");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read nsarray: " + e.getMessage(), (Throwable)e);
        }
        if (jsonNSArray == null) {
            throw new UnmarshallException("nsarray missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        state.setSerialized(o, (Object)m);
        try {
            for (i = 0; i < jsonNSArray.length(); ++i) {
                m.setMismatch(this.ser.tryUnmarshall(state, null, jsonNSArray.get(i)).max(m).getMismatch());
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), (Throwable)e);
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONArray jsonNSArray;
        Class<?> klass;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", (Throwable)e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        NSMutableArray al = new NSMutableArray();
        boolean immutableClone = true;
        try {
            klass = Class.forName(java_class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnmarshallException("Could not find class named: " + java_class);
        }
        if (NSMutableArray.class.isAssignableFrom(klass)) {
            immutableClone = false;
        } else if (!NSArray.class.isAssignableFrom(klass)) {
            throw new UnmarshallException("not an NSArray");
        }
        try {
            jsonNSArray = jso.getJSONArray("nsarray");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read nsarray: " + e.getMessage(), (Throwable)e);
        }
        if (jsonNSArray == null) {
            throw new UnmarshallException("nsarray missing");
        }
        try {
            for (i = 0; i < jsonNSArray.length(); ++i) {
                Object obj = this.ser.unmarshall(state, null, jsonNSArray.get(i));
                if (obj != null) {
                    al.addObject(obj);
                    continue;
                }
                al.addObject((Object)NSKeyValueCoding.NullValue);
            }
            NSMutableArray finalArray = al;
            if (immutableClone) {
                finalArray = al.immutableClone();
            }
            state.setSerialized(o, (Object)finalArray);
            return finalArray;
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), (Throwable)e);
        }
    }
}

