/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.localarg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jabsorb.localarg.LocalArgResolveException;
import org.jabsorb.localarg.LocalArgResolver;
import org.jabsorb.localarg.LocalArgResolverData;
import org.jabsorb.reflect.ClassAnalyzer;
import org.jabsorb.serializer.UnmarshallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalArgController {
    private static final Logger log = LoggerFactory.getLogger(LocalArgController.class);
    private static Map localArgResolverMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalArg(Class param) {
        HashSet resolverSet = null;
        Map map = localArgResolverMap;
        synchronized (map) {
            resolverSet = (HashSet)localArgResolverMap.get(param);
        }
        return resolverSet != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        Map map = localArgResolverMap;
        synchronized (map) {
            HashSet<LocalArgResolverData> resolverSet = (HashSet<LocalArgResolverData>)localArgResolverMap.get(argClazz);
            if (resolverSet == null) {
                resolverSet = new HashSet<LocalArgResolverData>();
                localArgResolverMap.put(argClazz, resolverSet);
            }
            resolverSet.add(new LocalArgResolverData(argResolver, argClazz, contextInterface));
            ClassAnalyzer.invalidateCache();
        }
        log.info("registered local arg resolver " + argResolver.getClass().getName() + " for local class " + argClazz.getName() + " with context " + contextInterface.getName());
    }

    public static Object resolveLocalArg(Object[] context, Class param) throws UnmarshallException {
        HashSet resolverSet = (HashSet)localArgResolverMap.get(param);
        for (LocalArgResolverData resolverData : resolverSet) {
            for (int j = 0; j < context.length; ++j) {
                if (!resolverData.understands(context[j])) continue;
                try {
                    return resolverData.getArgResolver().resolveArg(context[j]);
                }
                catch (LocalArgResolveException e) {
                    throw new UnmarshallException("error resolving local argument: " + (Object)((Object)e), (Throwable)e);
                }
            }
        }
        throw new UnmarshallException("couldn't find local arg resolver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        Map map = localArgResolverMap;
        synchronized (map) {
            HashSet resolverSet = (HashSet)localArgResolverMap.get(argClazz);
            if (resolverSet == null || !resolverSet.remove(new LocalArgResolverData(argResolver, argClazz, contextInterface))) {
                log.warn("local arg resolver " + argResolver.getClass().getName() + " not registered for local class " + argClazz.getName() + " with context " + contextInterface.getName());
                return;
            }
            if (resolverSet.isEmpty()) {
                localArgResolverMap.remove(argClazz);
            }
            ClassAnalyzer.invalidateCache();
        }
        log.info("unregistered local arg resolver " + argResolver.getClass().getName() + " for local class " + argClazz.getName() + " with context " + contextInterface.getName());
    }
}

