/*
 * Decompiled with CFR 0.152.
 */
package jofc2;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jofc2.LazyInstance;
import jofc2.OFCException;
import jofc2.OFCJSONDriver;
import jofc2.model.Chart;
import jofc2.model.Text;
import jofc2.model.axis.Axis;
import jofc2.model.axis.Label;
import jofc2.model.axis.XAxis;
import jofc2.model.axis.XAxisLabels;
import jofc2.model.axis.YAxis;
import jofc2.model.elements.AnimatedElement;
import jofc2.model.elements.AreaHollowChart;
import jofc2.model.elements.BarChart;
import jofc2.model.elements.Element;
import jofc2.model.elements.FilledBarChart;
import jofc2.model.elements.HorizontalBarChart;
import jofc2.model.elements.LineChart;
import jofc2.model.elements.NullElement;
import jofc2.model.elements.PieChart;
import jofc2.model.elements.ScatterChart;
import jofc2.model.elements.ShapeChart;
import jofc2.model.elements.SketchBarChart;
import jofc2.model.elements.StackedBarChart;
import jofc2.model.elements.Tooltip;
import jofc2.model.metadata.Alias;
import jofc2.model.metadata.Converter;
import jofc2.org.json.JSONException;
import jofc2.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFC {
    private static final Class<?>[] models = new Class[]{Axis.class, Text.class, XAxis.class, YAxis.class, XAxisLabels.class, Label.class, Element.class, Axis.class, BarChart.class, PieChart.class, HorizontalBarChart.class, LineChart.class, ScatterChart.class, AreaHollowChart.class, PieChart.Slice.class, HorizontalBarChart.Bar.class, Label.Rotation.class, ScatterChart.Point.class, FilledBarChart.class, SketchBarChart.class, StackedBarChart.class, StackedBarChart.StackValue.class, StackedBarChart.Stack.class, StackedBarChart.Key.class, BarChart.Bar.class, FilledBarChart.Bar.class, SketchBarChart.Bar.class, LineChart.Dot.class, LineChart.Style.class, NullElement.class, Chart.class, ShapeChart.class, ShapeChart.Point.class, Tooltip.class, Tooltip.Type.class, AnimatedElement.class, AnimatedElement.OnShow.class};
    private final XStream converter = new XStream((HierarchicalStreamDriver)new OFCJSONDriver());

    public OFC() {
        Class<?>[] classArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            this.doAlias(c);
            this.doRegisterConverter(c);
            ++n2;
        }
    }

    public static OFC getInstance() {
        return LazyInstance.instance;
    }

    private void doAlias(Class<?> c) {
        if (c.isAnnotationPresent(Alias.class)) {
            this.converter.alias(c.getAnnotation(Alias.class).value(), c);
        }
        Field[] fieldArray = c.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(Alias.class)) {
                this.converter.aliasField(f.getAnnotation(Alias.class).value(), c, f.getName());
            }
            ++n2;
        }
    }

    private void doRegisterConverter(Class<?> c) {
        if (c.isAnnotationPresent(Converter.class)) {
            Class<? extends ConverterMatcher> clazz = c.getAnnotation(Converter.class).value();
            try {
                if (SingleValueConverter.class.isAssignableFrom(clazz)) {
                    this.converter.registerConverter((SingleValueConverter)clazz.newInstance());
                } else {
                    this.converter.registerConverter((com.thoughtworks.xstream.converters.Converter)clazz.newInstance());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String render(Chart c) throws OFCException {
        String json = this.converter.toXML((Object)c);
        try {
            return new JSONObject(json).getString(Chart.class.getName());
        }
        catch (JSONException je) {
            throw new OFCException(json, je);
        }
    }

    public String prettyPrint(Chart c, int indentationLevel) throws OFCException {
        String json = this.converter.toXML((Object)c);
        try {
            return new JSONObject(json).getJSONObject(Chart.class.getName()).toString(indentationLevel);
        }
        catch (JSONException je) {
            throw new OFCException(json, je);
        }
    }

    public static <T> T[] toArray(Collection<T> collection, Class<? extends T> type) {
        return collection.toArray((Object[])Array.newInstance(type, collection.size()));
    }

    public static List<String> stringify(List<?> source) {
        ArrayList<String> strings = new ArrayList<String>(source.size());
        for (Object o : source) {
            strings.add(o.toString());
        }
        return strings;
    }

    public static String[] stringify(Object ... objects) {
        return OFC.stringify(Arrays.asList(objects)).toArray(new String[objects.length]);
    }
}

