/*
 * Decompiled with CFR 0.152.
 */
package jofc2.org.json;

import java.util.Iterator;
import jofc2.org.json.JSONArray;
import jofc2.org.json.JSONException;
import jofc2.org.json.JSONObject;
import jofc2.org.json.XML;
import jofc2.org.json.XMLTokener;

public class JSONML {
    private static JSONArray parse(XMLTokener x, JSONArray ja) throws JSONException {
        while (true) {
            Object t;
            if ((t = x.nextContent()) == XML.LT) {
                t = x.nextToken();
                if (t instanceof Character) {
                    if (t == XML.BANG) {
                        char c = x.next();
                        if (c == '-') {
                            if (x.next() == '-') {
                                x.skipPast("-->");
                            }
                            x.back();
                            continue;
                        }
                        if (c == '[') {
                            t = x.nextToken();
                            if (t.equals("CDATA") && x.next() == '[') {
                                x.nextCDATA();
                                continue;
                            }
                            throw x.syntaxError("Expected 'CDATA['");
                        }
                        int i = 1;
                        do {
                            if ((t = x.nextMeta()) == null) {
                                throw x.syntaxError("Missing '>' after '<!'.");
                            }
                            if (t == XML.LT) {
                                ++i;
                                continue;
                            }
                            if (t != XML.GT) continue;
                            --i;
                        } while (i > 0);
                        continue;
                    }
                    if (t == XML.QUEST) {
                        x.skipPast("?>");
                        continue;
                    }
                    if (t == XML.SLASH) {
                        t = x.nextToken();
                        if (ja == null) {
                            throw x.syntaxError("Mismatched close tag '" + t + "'");
                        }
                        if (!t.equals(ja.get(0))) {
                            throw x.syntaxError("Mismatched '" + ja.get(0) + "' and '" + t + "'");
                        }
                        if (x.nextToken() != XML.GT) {
                            throw x.syntaxError("Misshaped close tag");
                        }
                        return null;
                    }
                    throw x.syntaxError("Misshaped tag");
                }
                JSONArray newja = new JSONArray();
                JSONObject attributes = new JSONObject();
                if (ja != null) {
                    ja.put(newja);
                }
                newja.put(t);
                t = null;
                while (true) {
                    if (t == null) {
                        t = x.nextToken();
                    }
                    if (t == null) {
                        throw x.syntaxError("Misshaped tag");
                    }
                    if (!(t instanceof String)) break;
                    String s = (String)t;
                    t = x.nextToken();
                    if (t == XML.EQ) {
                        t = x.nextToken();
                        if (!(t instanceof String)) {
                            throw x.syntaxError("Missing value");
                        }
                        attributes.accumulate(s, t);
                        t = null;
                        continue;
                    }
                    attributes.accumulate(s, "");
                }
                if (attributes.length() > 0) {
                    newja.put(attributes);
                }
                if (t == XML.SLASH) {
                    if (x.nextToken() != XML.GT) {
                        throw x.syntaxError("Misshaped tag");
                    }
                    if (ja != null) continue;
                    return newja;
                }
                if (t == XML.GT) {
                    JSONML.parse(x, newja);
                    if (ja != null) continue;
                    return newja;
                }
                throw x.syntaxError("Misshaped tag");
            }
            if (ja == null) continue;
            ja.put(t);
        }
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return JSONML.toJSONArray(new XMLTokener(string));
    }

    public static JSONArray toJSONArray(XMLTokener x) throws JSONException {
        return JSONML.parse(x, null);
    }

    private static void stringify(JSONArray ja, StringBuffer b) throws JSONException {
        int i;
        Object v;
        b.append('<');
        b.append(ja.get(0));
        Object o = ja.opt(1);
        if (o instanceof JSONObject) {
            JSONObject jo = (JSONObject)o;
            Iterator keys = jo.keys();
            while (keys.hasNext()) {
                String k = keys.next().toString();
                v = jo.get(k).toString();
                b.append(' ');
                b.append(k);
                b.append("=\"");
                b.append(XML.escape((String)v));
                b.append('\"');
            }
            i = 2;
        } else {
            i = 1;
        }
        int len = ja.length();
        if (i >= len) {
            b.append("/>");
        } else {
            b.append('>');
            while (i < len) {
                v = ja.get(i);
                if (v instanceof JSONArray) {
                    JSONML.stringify((JSONArray)v, b);
                } else {
                    b.append(XML.escape(v.toString()));
                }
                ++i;
            }
            b.append("</");
            b.append(ja.get(0));
            b.append('>');
        }
    }

    public static String toString(JSONArray ja) throws JSONException {
        StringBuffer b = new StringBuffer();
        JSONML.stringify(ja, b);
        return b.toString();
    }
}

