/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.jdbcadaptor.OraclePlugIn;
import java.sql.Timestamp;

public class EROracleExpression
extends OraclePlugIn.OracleExpression {
    private final NSMutableArray _alreadyJoined = new NSMutableArray();
    private int _fetchLimit;
    private static final NSTimestampFormatter _TIMESTAMP_FORMATTER = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S.%F");
    private static Delegate _delegate;

    public static void setDelegate(Delegate delegate) {
        _delegate = delegate;
    }

    public EROracleExpression(EOEntity eoentity) {
        super(eoentity);
    }

    protected boolean shouldAllowNull(EOAttribute attribute) {
        boolean shouldAllowNull = attribute.allowsNull();
        if (!shouldAllowNull) {
            EOEntity entity = attribute.entity();
            EOEntity parentEntity = entity.parentEntity();
            String externalName = entity.externalName();
            if (externalName != null) {
                EOAttribute parentAttribute;
                boolean singleTableInheritance;
                boolean bl = singleTableInheritance = parentEntity != null && externalName.equals(parentEntity.externalName());
                if (singleTableInheritance && (parentAttribute = parentEntity.attributeNamed(attribute.name())) == null) {
                    shouldAllowNull = true;
                }
            }
        }
        return shouldAllowNull;
    }

    public void addCreateClauseForAttribute(EOAttribute attribute) {
        NSDictionary userInfo = attribute.userInfo();
        Object defaultValue = null;
        if (userInfo != null) {
            defaultValue = userInfo.valueForKey("er.extensions.eoattribute.default");
        }
        String allowsNullClauseForConstraint = this.allowsNullClauseForConstraint(this.shouldAllowNull(attribute));
        String sql = defaultValue == null ? _NSStringUtilities.concat((String)attribute.columnName(), (String)" ", (String)this.columnTypeStringForAttribute(attribute), (String)" ", (String)allowsNullClauseForConstraint) : _NSStringUtilities.concat((String)attribute.columnName(), (String)" ", (String)this.columnTypeStringForAttribute(attribute), (String)" DEFAULT ", (String)this.formatValueForAttribute(defaultValue, attribute), (String)" ", (String)allowsNullClauseForConstraint);
        this.appendItemToListString(sql, this._listString());
    }

    public NSMutableDictionary bindVariableDictionaryForAttribute(EOAttribute eoattribute, Object obj) {
        NSMutableDictionary result = super.bindVariableDictionaryForAttribute(eoattribute, obj);
        if (obj instanceof NSTimestamp && this.isTimestampAttribute(eoattribute)) {
            NSTimestamp nstimestamp = (NSTimestamp)obj;
            long millis = nstimestamp.getTime();
            Timestamp timestamp = new Timestamp(millis);
            timestamp.setNanos(timestamp.getNanos() + nstimestamp.getNanos());
            result.setObjectForKey((Object)timestamp, (Object)"BindVariableValue");
        }
        return result;
    }

    public String formatValueForAttribute(Object obj, EOAttribute eoattribute) {
        String value = obj instanceof NSTimestamp && this.isTimestampAttribute(eoattribute) ? "'" + _TIMESTAMP_FORMATTER.format(obj) + "'" : super.formatValueForAttribute(obj, eoattribute);
        return value;
    }

    private boolean isTimestampAttribute(EOAttribute eoattribute) {
        return "T".equals(eoattribute.valueType());
    }

    public boolean useBindVariables() {
        return true;
    }

    public boolean shouldUseBindVariableForAttribute(EOAttribute attribute) {
        return true;
    }

    public boolean mustUseBindVariableForAttribute(EOAttribute attribute) {
        return true;
    }

    public void prepareConstraintStatementForRelationship(EORelationship relationship, NSArray sourceColumns, NSArray destinationColumns) {
        EOModel destModel;
        EOEntity entity = relationship.entity();
        String tableName = entity.externalName();
        int lastDot = tableName.lastIndexOf(46);
        if (lastDot >= 0) {
            tableName = tableName.substring(lastDot + 1);
        }
        String constraintName = null;
        if (_delegate != null) {
            constraintName = _delegate.constraintStatementForRelationship(relationship, sourceColumns, destinationColumns);
        }
        if (constraintName == null && entity != null) {
            constraintName = System.getProperty("er.extensions.ERXModelGroup." + entity.name() + "." + relationship.name() + ".foreignKey");
        }
        if (constraintName == null) {
            constraintName = _NSStringUtilities.concat((String)tableName, (String)"_", (String)relationship.name(), (String)"_FK");
        }
        String sourceKeyList = sourceColumns.componentsJoinedByString(", ");
        String destinationKeyList = destinationColumns.componentsJoinedByString(", ");
        EOModel sourceModel = entity.model();
        if (sourceModel != (destModel = relationship.destinationEntity().model()) && !sourceModel.connectionDictionary().equals((Object)destModel.connectionDictionary())) {
            throw new IllegalArgumentException("prepareConstraintStatementForRelationship unable to create a constraint for " + relationship.name() + " because the source and destination entities reside in different databases");
        }
        this.setStatement("ALTER TABLE " + entity.externalName() + " ADD CONSTRAINT " + constraintName + " FOREIGN KEY (" + sourceKeyList + ") REFERENCES " + relationship.destinationEntity().externalName() + " (" + destinationKeyList + ") DEFERRABLE INITIALLY DEFERRED");
    }

    public String assembleSelectStatementWithAttributes(NSArray attributes, boolean lock, EOQualifier qualifier, NSArray fetchOrder, String selectString, String columnList, String tableList, String whereClause, String joinClause, String orderByClause, String lockClause) {
        StringBuffer sb = new StringBuffer();
        sb.append(selectString);
        sb.append(columnList);
        if (selectString.indexOf(" DISTINCT") != -1) {
            String[] columns = orderByClause.split(",");
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i].replaceFirst("\\s+(ASC|DESC)\\s*", "");
                if (columnList.indexOf(column = column.replaceFirst("(NULLS\\sFIRST|NULLS\\sLAST)", "")) != -1) continue;
                sb.append(", ");
                sb.append(column);
            }
        }
        sb.append(" FROM ");
        String fieldString = this._alreadyJoined.count() > 0 ? this.joinClauseString() : tableList;
        sb.append(fieldString);
        if (whereClause != null && whereClause.length() > 0 || joinClause != null && joinClause.length() > 0) {
            sb.append(" WHERE ");
            if (joinClause != null && joinClause.length() > 0) {
                sb.append(joinClause);
                if (whereClause != null && whereClause.length() > 0) {
                    sb.append(" AND ");
                }
            }
            if (whereClause != null && whereClause.length() > 0) {
                sb.append(whereClause);
            }
        }
        if (orderByClause != null && orderByClause.length() > 0) {
            sb.append(" ORDER BY ");
            sb.append(orderByClause);
        }
        if (lockClause != null && lockClause.length() > 0) {
            sb.append(" ");
            sb.append(lockClause);
        }
        if (this._fetchLimit != 0) {
            sb.append(" LIMIT ");
            sb.append(this._fetchLimit);
        }
        return sb.toString();
    }

    public void addOrderByAttributeOrdering(EOSortOrdering sortOrdering) {
        super.addOrderByAttributeOrdering(sortOrdering);
        String nullSortBehavior = NSProperties.getProperty((String)"EROraclePlugin.nullSortBehavior");
        if (nullSortBehavior != null) {
            if ("EOFStyle".equals(nullSortBehavior)) {
                if (sortOrdering.selector() == EOSortOrdering.CompareCaseInsensitiveDescending || sortOrdering.selector() == EOSortOrdering.CompareDescending) {
                    this._orderByString().append(" NULLS LAST");
                } else {
                    this._orderByString().append(" NULLS FIRST");
                }
            } else if ("NullsFirst".equals(nullSortBehavior)) {
                this._orderByString().append(" NULLS FIRST");
            } else if ("NullsLast".equals(nullSortBehavior)) {
                this._orderByString().append(" NULLS LAST");
            }
        }
    }

    public static interface Delegate {
        public String constraintStatementForRelationship(EORelationship var1, NSArray var2, NSArray var3);
    }
}

