/*
 * Decompiled with CFR 0.152.
 */
import com.gammastream.validity.GSVAttribute;
import com.gammastream.validity.GSVEOAttribute;
import com.gammastream.validity.GSVEOEntity;
import com.gammastream.validity.GSVEntity;
import com.gammastream.validity.GSVModel;
import com.gammastream.validity.GSVRule;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;

public class Modeler
extends WOComponent {
    protected Application app = (Application)WOApplication.application();
    protected Session session = (Session)this.session();
    protected WBTruncateFormatter formatte25 = new WBTruncateFormatter(25, "...");
    protected GSVEOEntity currentEntity = null;
    protected GSVEOEntity selectedEntity = null;
    protected GSVEOAttribute currentAttribute = null;
    protected GSVEOAttribute selectedAttribute = null;
    protected GSVRule currentRule = null;
    protected GSVRule selectedRule = null;
    protected GSVRule currentSavedRule = null;
    protected GSVRule selectedSaveRule = null;
    protected NSMutableArray keyValueParameters = new NSMutableArray();
    protected KeyValue currentParameter = null;
    protected boolean showEntity = false;
    protected boolean showAttribute = false;
    protected boolean showInspector = false;
    protected boolean newFlag = false;
    protected boolean error = false;
    protected boolean checked = false;
    protected String errorMessage = "";

    public Modeler(WOContext arg0) {
        super(arg0);
    }

    public void awake() {
        super.awake();
        this.error = false;
        this.checked = false;
    }

    public WOComponent showEntityAction() {
        if (this.selectedEntity == null) {
            this.showAttribute = false;
            this.showEntity = false;
            this.showInspector = false;
            return null;
        }
        this.showAttribute = false;
        this.showEntity = true;
        this.showInspector = false;
        return null;
    }

    public WOComponent showAttributeAction() {
        this.setSelectedAttribute(this.currentAttribute);
        this.showAttribute = true;
        this.showEntity = false;
        this.showInspector = false;
        return null;
    }

    public WOComponent showAttributeActionBack() {
        this.showAttribute = true;
        this.showEntity = false;
        this.showInspector = false;
        return null;
    }

    public WOComponent showInspectorAction() {
        this.setSelectedRule(this.currentRule);
        this.showAttribute = false;
        this.showEntity = false;
        this.showInspector = true;
        this.keyValueParameters = new NSMutableArray();
        this.convertRuleDictionaryToKeyValue();
        return null;
    }

    public WOComponent newRuleAction() {
        if (this.selectedSaveRule == null) {
            this.setSelectedRule(new GSVRule("Untitled", null, null, null, null));
            this.keyValueParameters = new NSMutableArray();
        } else {
            this.setSelectedRule(this.newRule(this.selectedSaveRule));
            this.keyValueParameters = new NSMutableArray();
            this.convertRuleDictionaryToKeyValue();
        }
        this.selectedSaveRule = null;
        this.showAttribute = false;
        this.showEntity = false;
        this.showInspector = true;
        this.newFlag = true;
        return null;
    }

    public WOComponent newKeyValueAction() {
        this.keyValueParameters.addObject((Object)new KeyValue("NewKey", "NewValue"));
        return null;
    }

    public WOComponent deleteKeyValueAction() {
        this.keyValueParameters.removeObject((Object)this.currentParameter);
        return null;
    }

    public WOComponent deleteRuleInList() {
        GSVAttribute att;
        String entityName = this.selectedAttribute().entity().name();
        GSVModel model = this.session.model();
        GSVEntity entity = model.entityNamed(entityName);
        if (entity == null) {
            entity = new GSVEntity(model, entityName);
            model.addEntity(entity);
        }
        if ((att = entity.attributeNamed(this.selectedAttribute().name())) == null) {
            att = new GSVAttribute(entity, this.selectedAttribute().name());
            entity.addAttribute(att);
        }
        att.removeRule(this.currentRule);
        model.saveModel();
        this.showAttribute = true;
        this.showEntity = false;
        this.showInspector = false;
        this.newFlag = false;
        return null;
    }

    public WOComponent deleteRule() {
        GSVAttribute att;
        String entityName = this.selectedAttribute().entity().name();
        GSVModel model = this.session.model();
        GSVEntity entity = model.entityNamed(entityName);
        if (entity == null) {
            entity = new GSVEntity(model, entityName);
            model.addEntity(entity);
        }
        if ((att = entity.attributeNamed(this.selectedAttribute().name())) == null) {
            att = new GSVAttribute(entity, this.selectedAttribute().name());
            entity.addAttribute(att);
        }
        att.removeRule(this.selectedRule());
        model.saveModel();
        this.showAttribute = true;
        this.showEntity = false;
        this.showInspector = false;
        this.newFlag = false;
        return null;
    }

    public WOComponent saveAction() {
        this.error = false;
        if (this.selectedRule().ruleName() == null) {
            this.error = true;
            this.errorMessage = "Rule Name can not be left blank.";
            return null;
        }
        String entityName = this.selectedAttribute().entity().name();
        GSVModel model = this.session.model();
        GSVEntity entity = model.entityNamed(entityName);
        if (entity == null) {
            entity = new GSVEntity(model, entityName);
            model.addEntity(entity);
        }
        entity.setModel(model);
        GSVAttribute att = entity.attributeNamed(this.selectedAttribute().name());
        if (att == null) {
            att = new GSVAttribute(entity, this.selectedAttribute().name());
            entity.addAttribute(att);
        }
        att.setEntity(entity);
        if (this.newFlag) {
            if (att.ruleNamed(this.selectedRule().ruleName()) != null) {
                this.errorMessage = "There is already a rule named: " + this.selectedRule().ruleName();
                this.error = true;
                return null;
            }
        } else {
            NSMutableArray temp = new NSMutableArray(att.rules());
            if (temp.count() != 0) {
                temp.removeObject((Object)this.selectedRule());
            }
            GSVRule ru = null;
            for (int s = 0; s < temp.count(); ++s) {
                ru = (GSVRule)temp.objectAtIndex(s);
                if (!ru.ruleName().equals(this.selectedRule().ruleName())) continue;
                this.errorMessage = "There is already a rule named: " + this.selectedRule().ruleName();
                this.error = true;
                return null;
            }
        }
        if (!this.convertRuleKeyValueToDictionary()) {
            this.errorMessage = "All Keys in the Parameter NSDictionary can not contain spaces.<BR>Keys and Values can not be blank.";
            this.error = true;
            return null;
        }
        if (this.checked) {
            this.app.config().addRule(this.selectedRule());
        } else {
            this.app.config().removeRule(this.selectedRule());
        }
        if (this.newFlag) {
            att.addRule(this.selectedRule());
        }
        model.saveModel();
        this.app.saveConfiguration();
        this.showAttribute = true;
        this.showEntity = false;
        this.showInspector = false;
        this.newFlag = false;
        this.selectedRule = null;
        return null;
    }

    public NSArray rules() {
        try {
            GSVEntity entity = this.session.model().entityNamed(this.selectedAttribute().entity().name());
            GSVAttribute att = entity.attributeNamed(this.selectedAttribute().name());
            return att.rules();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasRules() {
        if (this.rules() != null) {
            return this.rules().count() != 0;
        }
        return false;
    }

    public String currentEntityBGColor() {
        return this.currentEntity == this.selectedEntity() ? "#DDDDDD" : "#FFFFFF";
    }

    public int ruleCount() {
        String entityName = this.currentAttribute.entity().name();
        GSVModel model = this.session.model();
        GSVEntity entity = model.entityNamed(entityName);
        if (entity == null) {
            return 0;
        }
        GSVAttribute att = entity.attributeNamed(this.currentAttribute.name());
        if (att == null) {
            return 0;
        }
        return att.rules().count();
    }

    public GSVRule newRule(GSVRule copyRule) {
        GSVRule rule = new GSVRule(copyRule.ruleName(), copyRule.cName(), copyRule.mName(), "", "");
        rule.setParameters(copyRule.parameters());
        rule.setOnSave(copyRule.onSave());
        rule.setOnInsert(copyRule.onInsert());
        rule.setOnDelete(copyRule.onDelete());
        return rule;
    }

    public void convertRuleDictionaryToKeyValue() {
        NSMutableDictionary dict = new NSMutableDictionary();
        dict = this.selectedRule.parameters();
        for (int i = 0; i < dict.allKeys().count(); ++i) {
            String k = (String)dict.allKeys().objectAtIndex(i);
            String v = (String)dict.objectForKey((Object)k);
            KeyValue temp = new KeyValue(k, v);
            this.keyValueParameters.addObject((Object)temp);
        }
    }

    public boolean convertRuleKeyValueToDictionary() {
        NSMutableDictionary dict = new NSMutableDictionary();
        for (int i = 0; i < this.keyValueParameters.count(); ++i) {
            KeyValue temp = (KeyValue)this.keyValueParameters.objectAtIndex(i);
            if (temp.key() != null && temp.val() != null) {
                if (temp.key().indexOf(" ") != -1) {
                    return false;
                }
            } else {
                return false;
            }
            dict.setObjectForKey((Object)temp.val(), (Object)temp.key());
        }
        this.selectedRule.setParameters(dict);
        return true;
    }

    public boolean showKey() {
        try {
            return this.selectedEntity().primaryKeyAttributes().containsObject((Object)this.currentAttribute.name());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean showInclude() {
        try {
            return this.selectedEntity().classProperties().containsObject((Object)this.currentAttribute.name());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean showLock() {
        try {
            return this.selectedEntity().attributesUsedForLocking().containsObject((Object)this.currentAttribute.name());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean showNull() {
        try {
            return this.currentAttribute.allowsNull().equals("Y");
        }
        catch (Exception e) {
            return false;
        }
    }

    public String widthStr() {
        try {
            return this.currentAttribute.width() > 0 ? "" + this.currentAttribute.width() : "&nbsp; ";
        }
        catch (Exception e) {
            return "&nbsp; ";
        }
    }

    public GSVEOEntity selectedEntity() {
        return this.selectedEntity;
    }

    public void setSelectedEntity(GSVEOEntity newSelectedEntity) {
        this.selectedEntity = newSelectedEntity;
    }

    public GSVEOAttribute selectedAttribute() {
        return this.selectedAttribute;
    }

    public void setSelectedAttribute(GSVEOAttribute newSelectedAttribute) {
        this.selectedAttribute = newSelectedAttribute;
    }

    public GSVRule selectedRule() {
        return this.selectedRule;
    }

    public void setSelectedRule(GSVRule newSelectedRule) {
        this.selectedRule = newSelectedRule;
    }

    public NSMutableArray keyValueParameters() {
        return this.keyValueParameters;
    }

    public GSVRule currentSavedRule() {
        return this.currentSavedRule;
    }

    public void setCurrentSavedRule(GSVRule newCurrentSavedRule) {
        this.currentSavedRule = newCurrentSavedRule;
    }

    public String currentSavedRuleDisplayString() {
        String temp = this.currentSavedRule().cName();
        if (temp == null) {
            temp = "Undefined";
        }
        int lastindex = temp.lastIndexOf(".") + 1;
        temp = temp.substring(lastindex, temp.length());
        return this.currentSavedRule().ruleName() + " - " + temp + "." + this.currentSavedRule().mName() + "()";
    }

    public GSVRule selectedSaveRule() {
        return this.selectedSaveRule;
    }

    public void setSelectedSaveRule(GSVRule newSelectedSaveRule) {
        this.selectedSaveRule = newSelectedSaveRule;
    }

    public boolean checked() {
        return this.app.config().quickRules().containsObject((Object)this.selectedRule);
    }

    public void setChecked(boolean d) {
        this.checked = d;
    }

    public WOComponent promoteRule() {
        NSMutableArray rules = (NSMutableArray)this.rules();
        int index = rules.indexOfObject((Object)this.currentRule);
        if (index == rules.count() - 1) {
            rules.removeObjectAtIndex(index);
            rules.insertObjectAtIndex((Object)this.currentRule, 0);
        } else {
            rules.removeObjectAtIndex(index);
            rules.insertObjectAtIndex((Object)this.currentRule, index + 1);
        }
        GSVModel model = this.session.model();
        model.saveModel();
        return null;
    }

    public WOComponent demoteRule() {
        NSMutableArray rules = (NSMutableArray)this.rules();
        int index = rules.indexOfObject((Object)this.currentRule);
        if (index == 0) {
            rules.removeObjectAtIndex(index);
            rules.addObject((Object)this.currentRule);
        } else {
            rules.removeObjectAtIndex(index);
            rules.insertObjectAtIndex((Object)this.currentRule, index - 1);
        }
        GSVModel model = this.session.model();
        model.saveModel();
        return null;
    }
}

