/*
 * Decompiled with CFR 0.152.
 */
import com.gammastream.gammacore.gammatext.GSTextConstants;
import com.gammastream.gammacore.gammatext.GSTextUtilities;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class WBComboFormatter
extends Format {
    public static final int DEFAULT_LENGTH = 250;
    private int truncateLength = 250;
    private boolean truncate;
    private boolean stripHTML;
    private boolean textareaToHTML;

    public WBComboFormatter(boolean t, boolean s, boolean h) {
        this.truncate = t;
        this.stripHTML = s;
        this.textareaToHTML = h;
        if (this.truncate) {
            this.truncateLength = 250;
        }
    }

    public StringBuffer format(Object object, StringBuffer r, FieldPosition d) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("WBComboFormatter only formats 'String' objects.");
        }
        String result = (String)object;
        if (this.truncate) {
            result = GSTextUtilities.truncate((String)result, (int)this.truncateLength);
        }
        if (this.stripHTML) {
            result = GSTextUtilities.stringStrippedOfHTML((String)result);
        }
        if (this.textareaToHTML) {
            result = GSTextUtilities.replaceStringWithStringInString((String)GSTextConstants.CARRIAGE_RETURN_STRING, (String)"<BR>", (String)result);
            result = GSTextUtilities.replaceStringWithStringInString((String)GSTextConstants.TAB_STRING, (String)"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", (String)result);
        }
        return r.append(result);
    }

    public Object parseObject(String anObject, ParsePosition o) {
        return anObject;
    }

    public int truncateLength() {
        if (this.truncate) {
            return this.truncateLength;
        }
        return 0;
    }

    public void setTruncateLength(int len) {
        this.truncateLength = len;
        this.truncate = true;
    }

    public boolean truncate() {
        return this.truncate;
    }

    public void setTruncate(boolean bool) {
        this.truncate = bool;
    }

    public boolean stripHTML() {
        return this.stripHTML;
    }

    public void setStripHTML(boolean bool) {
        this.stripHTML = bool;
    }

    public boolean textareaToHTML() {
        return this.textareaToHTML;
    }

    public void setTextareaToHTML(boolean bool) {
        this.textareaToHTML = bool;
    }
}

