/*
 * Decompiled with CFR 0.152.
 */
package er.openid;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WORequest;
import er.extensions.appserver.ERXDirectAction;
import er.extensions.foundation.ERXProperties;
import er.openid.EROResponse;
import er.openid.EROpenIDManager;
import er.openid.IEROResponsePage;

public class ERODirectAction
extends ERXDirectAction {
    public ERODirectAction(WORequest request) {
        super(request);
    }

    private WOComponent pageForKey(String key) {
        String successPageName = ERXProperties.stringForKey((String)key);
        if (successPageName == null) {
            throw new IllegalArgumentException("You must set the property '" + key + "'.");
        }
        return this.pageWithName(successPageName);
    }

    public WOActionResults openIDRequestAction() {
        String identity = this.request().stringFormValueForKey("identity");
        String realm = this.request().stringFormValueForKey("realm");
        WOActionResults results = null;
        try {
            results = EROpenIDManager.manager().authRequest(identity, realm, this.request(), this.context());
            if (results == null) {
                results = this.pageForKey("er.openid.failurePageName");
            }
        }
        catch (Exception exception) {
            EROpenIDManager.log.info((Object)exception);
            results = this.pageForKey("er.openid.failurePageName");
        }
        return results;
    }

    public WOActionResults openIDResponseAction() {
        WOComponent results;
        EROResponse response = null;
        try {
            response = EROpenIDManager.manager().verifyResponse(this.request(), this.context());
        }
        catch (Exception exception) {
            EROpenIDManager.log.info((Object)exception);
        }
        if (response != null && response.succeeded()) {
            WOComponent successPage = this.pageForKey("er.openid.successPageName");
            if (successPage instanceof IEROResponsePage) {
                ((IEROResponsePage)successPage).setOpenIDResponse(response);
            }
            results = successPage;
        } else {
            WOComponent failurePage = this.pageForKey("er.openid.failurePageName");
            if (failurePage instanceof IEROResponsePage) {
                ((IEROResponsePage)failurePage).setOpenIDResponse(response);
            }
            results = failurePage;
        }
        return results;
    }
}

