/*
 * Decompiled with CFR 0.152.
 */
package ognl.webobjects;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver._private.WOBindingNameAssociation;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WOKeyValueAssociation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSUtilities;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import ognl.ClassResolver;
import ognl.ElementsAccessor;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.helperfunction.WOHelperFunctionHTMLParser;
import ognl.helperfunction.WOHelperFunctionParser;
import ognl.helperfunction.WOHelperFunctionTagRegistry;
import ognl.webobjects.NSArrayPropertyAccessor;
import ognl.webobjects.NSClassResolver;
import ognl.webobjects.NSDictionaryPropertyAccessor;
import ognl.webobjects.NSFoundationElementsAccessor;
import ognl.webobjects.NSObjectPropertyAccessor;
import ognl.webobjects.WOOgnlAssociation;
import org.apache.log4j.Logger;

public class WOOgnl {
    public static Logger log = Logger.getLogger(WOOgnl.class);
    public static final String DefaultWOOgnlBindingFlag = "~";
    protected static NSMutableArray _retainerArray = new NSMutableArray();
    private static Hashtable associationMappings;
    protected static WOOgnl _factory;

    public static void setAssociationClassForPrefix(Class clazz, String prefix) {
        associationMappings.put(prefix, clazz);
    }

    private WOAssociation createAssociationForClass(Class clazz, String value, boolean isConstant) {
        return (WOAssociation)_NSUtilities.instantiateObject((Class)clazz, (Class[])new Class[]{Object.class, Boolean.TYPE}, (Object[])new Object[]{value, isConstant}, (boolean)true, (boolean)false);
    }

    public static WOOgnl factory() {
        if (_factory == null) {
            _factory = new WOOgnl();
        }
        return _factory;
    }

    public static void setFactory(WOOgnl factory) {
        _factory = factory;
    }

    public ClassResolver classResolver() {
        return NSClassResolver.sharedInstance();
    }

    public String ognlBindingFlag() {
        return DefaultWOOgnlBindingFlag;
    }

    public Hashtable newDefaultContext() {
        Hashtable<String, ClassResolver> h = new Hashtable<String, ClassResolver>();
        if (this.classResolver() != null) {
            h.put("classResolver", this.classResolver());
        }
        return h;
    }

    private boolean isWO54() {
        boolean isWO54;
        try {
            WOApplication.class.getMethod("getWebObjectsVersion", new Class[0]);
            isWO54 = true;
        }
        catch (Exception e) {
            isWO54 = false;
        }
        return isWO54;
    }

    public void configureWOForOgnl() {
        OgnlRuntime.setPropertyAccessor(Object.class, (PropertyAccessor)new NSObjectPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(NSArray.class, (PropertyAccessor)new NSArrayPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(NSDictionary.class, (PropertyAccessor)new NSDictionaryPropertyAccessor());
        NSFoundationElementsAccessor e = new NSFoundationElementsAccessor();
        OgnlRuntime.setElementsAccessor(NSArray.class, (ElementsAccessor)e);
        OgnlRuntime.setElementsAccessor(NSDictionary.class, (ElementsAccessor)e);
        OgnlRuntime.setElementsAccessor(NSSet.class, (ElementsAccessor)e);
        if (this.hasProperty("ognl.active", "true")) {
            if (this.isWO54()) {
                String parserClassName = System.getProperty("ognl.parserClassName", "ognl.helperfunction.WOHelperFunctionParser54");
                try {
                    Class.forName("com.webobjects.appserver.parser.WOComponentTemplateParser").getMethod("setWOHTMLTemplateParserClassName", String.class).invoke(null, parserClassName);
                }
                catch (Exception e1) {
                    throw new RuntimeException("Failed to set the template parser to WOHelperFunctionParser54.", e1);
                }
            }
            String parserClassName = System.getProperty("ognl.parserClassName", "ognl.helperfunction.WOHelperFunctionParser53");
            try {
                Class.forName("com.webobjects.appserver._private.WOParser").getMethod("setWOHTMLTemplateParserClassName", String.class).invoke(null, parserClassName);
            }
            catch (Exception e1) {
                throw new RuntimeException("Failed to set the template parser to WOHelperFunctionParser53.", e1);
            }
            if (this.hasProperty("ognl.inlineBindings", "false")) {
                WOHelperFunctionTagRegistry.setAllowInlineBindings(true);
            }
            if (this.hasProperty("ognl.parseStandardTags", "false")) {
                WOHelperFunctionHTMLParser.setParseStandardTags(true);
            }
            if (this.hasProperty("ognl.debugSupport", "false")) {
                WOHelperFunctionParser._debugSupport = true;
            }
        }
    }

    private boolean hasProperty(String prop, String def) {
        String property = System.getProperty(prop, def).trim();
        return "true".equalsIgnoreCase(property) || "yes".equalsIgnoreCase(property);
    }

    public void convertOgnlConstantAssociations(NSMutableDictionary associations) {
        Enumeration e = associations.keyEnumerator();
        while (e.hasMoreElements()) {
            String ognlExpression;
            Class c;
            String prefix;
            int index;
            String name = (String)e.nextElement();
            WOAssociation association = (WOAssociation)associations.objectForKey((Object)name);
            boolean isConstant = false;
            String keyPath = null;
            if (association instanceof WOConstantValueAssociation) {
                WOConstantValueAssociation constantAssociation = (WOConstantValueAssociation)association;
                Object value = constantAssociation.valueInComponent(null);
                keyPath = value != null ? value.toString() : null;
                isConstant = true;
            } else if (association instanceof WOKeyValueAssociation) {
                keyPath = association.keyPath();
            } else if (association instanceof WOBindingNameAssociation) {
                WOBindingNameAssociation b = (WOBindingNameAssociation)association;
                keyPath = "^" + b._parentBindingName;
            }
            if (keyPath == null) continue;
            if (associationMappings.size() != 0 && (index = name.indexOf(58)) > 0 && (prefix = name.substring(0, index)) != null && (c = (Class)associationMappings.get(prefix)) != null) {
                String postfix = name.substring(index + 1);
                WOAssociation newAssociation = this.createAssociationForClass(c, keyPath, isConstant);
                associations.removeObjectForKey((Object)name);
                associations.setObjectForKey((Object)newAssociation, (Object)postfix);
            }
            if (!isConstant || keyPath == null || !keyPath.startsWith(this.ognlBindingFlag()) || (ognlExpression = keyPath.substring(this.ognlBindingFlag().length(), keyPath.length())).length() <= 0) continue;
            WOOgnlAssociation newAssociation = new WOOgnlAssociation(ognlExpression);
            NSArray keys = associations.allKeysForObject((Object)association);
            if (keys.count() == 1) {
                associations.setObjectForKey((Object)newAssociation, keys.lastObject());
                continue;
            }
            Enumeration ee = keys.objectEnumerator();
            while (ee.hasMoreElements()) {
                associations.setObjectForKey((Object)newAssociation, e.nextElement());
            }
        }
    }

    public Object getValue(String expression, Object obj) {
        Object value = null;
        try {
            value = Ognl.getValue((String)expression, (Map)this.newDefaultContext(), (Object)obj);
        }
        catch (OgnlException ex) {
            String message = ex.getMessage();
            if (message != null && message.startsWith("source is null for getProperty(null, ")) {
                value = null;
            }
            throw new RuntimeException("Failed to get value '" + expression + "' on " + obj, ex);
        }
        return value;
    }

    public void setValue(String expression, Object obj, Object value) {
        try {
            Ognl.setValue((String)expression, (Map)this.newDefaultContext(), (Object)obj, (Object)value);
        }
        catch (OgnlException ex) {
            throw new RuntimeException("Failed to set value '" + expression + "' on " + obj, ex);
        }
    }

    static {
        try {
            Observer o = new Observer();
            _retainerArray.addObject((Object)o);
            NSNotificationCenter.defaultCenter().addObserver((Object)o, new NSSelector("configureWOOgnl", new Class[]{NSNotification.class}), "ApplicationWillFinishLaunchingNotification", null);
        }
        catch (Exception e) {
            log.error((Object)"Failed to configure WOOgnl.", (Throwable)e);
        }
        associationMappings = new Hashtable();
    }

    public static class Observer {
        public void configureWOOgnl(NSNotification n) {
            WOOgnl.factory().configureWOForOgnl();
            NSNotificationCenter.defaultCenter().removeObserver((Object)this);
            _retainerArray.removeObject((Object)this);
        }
    }
}

