/*
 * Decompiled with CFR 0.152.
 */
package ag.kcmedia;

import ag.kcmedia.JavaBrowser;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.bytecode.FieldInfo;
import jode.bytecode.MethodInfo;
import jode.bytecode.TypeSignature;
import jode.decompiler.Decompiler;
import jode.type.Type;
import org.apache.log4j.Logger;

public class Jode {
    static final Logger log = Logger.getLogger(JavaBrowser.class);
    public static NSMutableArray documentationPaths = new NSMutableArray();
    public static NSMutableDictionary allClasses = new NSMutableDictionary();
    public static NSMutableDictionary allPackages = new NSMutableDictionary();
    public static String cp;
    public static boolean initialized;

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ERXLocalizer l = ERXLocalizer.localizerForLanguage((String)"English");
        GlobalOptions.err = new PrintWriter(new StringWriter());
        documentationPaths = (NSMutableArray)l.valueForKey("DocumentationPaths");
        NSArray arr = (NSArray)l.valueForKey("ClassPaths");
        cp = arr.componentsJoinedByString(":");
        ClassInfo.setClassPath((String)cp);
        arr = (NSArray)l.valueForKey("PackagesToIndex");
        Enumeration e = arr.objectEnumerator();
        while (e.hasMoreElements()) {
            PackageProxy.indexPackage((String)e.nextElement(), null, true);
        }
    }

    public static PackageProxy packageProxyForName(String packageName) {
        Jode.initialize();
        return (PackageProxy)allPackages.objectForKey((Object)packageName);
    }

    public static NSDictionary allPackages() {
        Jode.initialize();
        return allPackages;
    }

    public static NSDictionary allClasses() {
        Jode.initialize();
        return allClasses;
    }

    public static ClassProxy classProxyForName(String packageName, String className) {
        Jode.initialize();
        return Jode.classProxyForName(packageName + (packageName == "" ? "" : ".") + className);
    }

    public static ClassProxy classProxyForName(String fullClassName) {
        Jode.initialize();
        return (ClassProxy)allClasses.objectForKey((Object)fullClassName);
    }

    static {
        initialized = false;
    }

    public static class ClassProxy {
        protected PackageProxy packageProxy;
        protected String name;
        protected ClassInfo classInfo;
        protected String sourceCode;
        protected String documentation;
        public NSMutableArray names;

        public ClassProxy(String name, PackageProxy packageProxy, ClassInfo classInfo) {
            this.packageProxy = packageProxy;
            this.name = name;
            this.classInfo = classInfo;
            this.sourceCode = null;
            if (this.packageProxy != null) {
                this.packageProxy.addClass(this);
            }
        }

        public String name() {
            return this.name;
        }

        public String fullName() {
            return this.classInfo().getName();
        }

        public PackageProxy packageProxy() {
            return this.packageProxy;
        }

        public ClassInfo classInfo() {
            return this.classInfo;
        }

        public NSArray names() {
            if (this.names == null) {
                this.names = new NSMutableArray();
                ClassInfo ci = this.classInfo();
                FieldInfo[] fi = ci.getFields();
                for (int i = 0; i < fi.length; ++i) {
                    FieldInfo f = fi[i];
                    this.names.addObject((Object)f.getName());
                }
                MethodInfo[] mi = ci.getMethods();
                for (int i = 0; i < mi.length; ++i) {
                    MethodInfo f = mi[i];
                    this.names.addObject((Object)f.getName());
                }
                this.names.addObject((Object)this.name());
            }
            return this.names;
        }

        public NSArray variables() {
            ClassInfo ci = this.classInfo();
            FieldInfo[] fi = ci.getFields();
            NSMutableArray fields = new NSMutableArray(fi.length);
            for (int i = 0; i < fi.length; ++i) {
                FieldInfo f = fi[i];
                StringBuffer sb = new StringBuffer(512);
                String typeInfo = f.getType();
                String fieldName = f.getName();
                Type param = Type.tType((String)TypeSignature.getReturnType((String)typeInfo));
                sb.append(ERXStringUtilities.lastPropertyKeyInKeyPath((String)param.toString()));
                sb.append(" ");
                sb.append(fieldName);
                fields.addObject((Object)sb.toString());
            }
            return fields;
        }

        public NSArray methods() {
            ClassInfo ci = this.classInfo();
            MethodInfo[] mi = ci.getMethods();
            NSMutableArray methods = new NSMutableArray(mi.length);
            for (int i = 0; i < mi.length; ++i) {
                MethodInfo m = mi[i];
                StringBuffer sb = new StringBuffer(512);
                String typeInfo = m.getType();
                String[] params = TypeSignature.getParameterTypes((String)typeInfo);
                String methodName = m.getName();
                if (methodName.equals("<clinit>")) continue;
                sb.append(Modifier.toString(m.getModifiers()));
                sb.append(" ");
                if (methodName.equals("<init>")) {
                    sb.append(ERXStringUtilities.lastPropertyKeyInKeyPath((String)ci.getName()));
                } else {
                    Type param = Type.tType((String)TypeSignature.getReturnType((String)typeInfo));
                    sb.append(ERXStringUtilities.lastPropertyKeyInKeyPath((String)param.toString()));
                    sb.append(" ");
                    sb.append(methodName);
                }
                sb.append("(");
                for (int j = 0; j < params.length; ++j) {
                    Type param = Type.tType((String)params[j]);
                    sb.append(ERXStringUtilities.lastPropertyKeyInKeyPath((String)param.toString()));
                    if (j >= params.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(")");
                methods.addObject((Object)sb.toString());
            }
            return methods;
        }

        public String sourceCode() {
            if (this.sourceCode != null) {
                return this.sourceCode;
            }
            StringWriter writer = new StringWriter();
            try {
                Decompiler decompiler = new Decompiler();
                decompiler.setClassPath(cp);
                decompiler.decompile(this.classInfo().getName(), (Writer)writer, null);
            }
            catch (IOException ex) {
                log.error((Object)ex.toString());
            }
            catch (AssertError ex) {
                log.error((Object)ex.toString());
                return ex.toString() + " occurred. \n\n" + "Please check if you have all necessary jar and class files \n" + "added to ClassPaths property in the Localizable.strings file.";
            }
            this.sourceCode = writer.toString();
            try {
                Class<?> JavaCCtoHTML = Class.forName("JavaCCtoHTML");
                NSSelector prettyString = new NSSelector("prettyString", new Class[]{String.class});
                prettyString.invoke(JavaCCtoHTML, (Object)this.sourceCode);
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            this.sourceCode = ERXStringUtilities.replaceStringByStringInString((String)"\n\n", (String)"<br>", (String)this.sourceCode);
            return this.sourceCode;
        }

        public String documentationPath() {
            String classPath = this.classInfo().getName().replace('.', '/');
            Enumeration e = documentationPaths.objectEnumerator();
            while (e.hasMoreElements()) {
                String path = (String)e.nextElement();
                String wholePath = path + classPath + ".html";
                File f = new File(wholePath);
                if (!f.exists()) continue;
                return wholePath;
            }
            return null;
        }

        public String documentation() {
            String docPath = this.documentationPath();
            this.documentation = docPath != null ? ERXStringUtilities.stringWithContentsOfFile((String)docPath) : "No docs available";
            return this.documentation;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class PackageProxy {
        protected PackageProxy packageProxy;
        protected String name;
        protected ClassInfo classInfo;
        protected NSMutableArray subPackages = new NSMutableArray();
        protected NSMutableArray classes = new NSMutableArray();

        public PackageProxy(String name, PackageProxy packageProxy, ClassInfo classInfo) {
            this.packageProxy = packageProxy;
            this.name = name;
            this.classInfo = classInfo;
            if (this.packageProxy != null) {
                this.packageProxy.addSubPackage(this);
            }
        }

        public String name() {
            return this.name;
        }

        public PackageProxy packageProxy() {
            return this.packageProxy;
        }

        public ClassInfo classInfo() {
            return this.classInfo;
        }

        public void addClass(ClassProxy classProxy) {
            this.classes.addObject((Object)classProxy);
        }

        public NSArray classes() {
            return this.classes;
        }

        public void addSubPackage(PackageProxy subPackageProxy) {
            this.subPackages.addObject((Object)subPackageProxy);
        }

        public NSArray subPackages() {
            return this.subPackages;
        }

        public String toString() {
            return this.name;
        }

        public static void indexClass(String className, String packageName, int modifyTypes) {
            if (allClasses.valueForKey(className) != null) {
                return;
            }
            String classNameWithPackage = packageName + (packageName == "" ? "" : ".") + className;
            ClassProxy classProxy = new ClassProxy(className, (PackageProxy)allPackages.valueForKey(packageName), ClassInfo.forName((String)classNameWithPackage));
            allClasses.takeValueForKey((Object)classProxy, classNameWithPackage);
        }

        public static void indexPackage(String packageName, PackageProxy parentPackage, boolean indexClasses) {
            if (allPackages.valueForKey(packageName) != null) {
                return;
            }
            PackageProxy packageProxy = new PackageProxy(packageName, parentPackage, ClassInfo.forName((String)packageName));
            allPackages.takeValueForKey((Object)packageProxy, packageName);
            Enumeration e = ClassInfo.getClassesAndPackages((String)packageName);
            while (e.hasMoreElements()) {
                String className = (String)e.nextElement();
                String classNameWithPackage = packageName + (packageName == "" ? "" : ".") + className;
                if (ClassInfo.isPackage((String)classNameWithPackage)) {
                    PackageProxy.indexPackage(classNameWithPackage, packageProxy, indexClasses);
                    continue;
                }
                if (className.indexOf("$") >= 0 || !indexClasses) continue;
                PackageProxy.indexClass(className, packageName, 0);
            }
        }
    }
}

