/*
 * Decompiled with CFR 0.152.
 */
package ag.kcmedia;

import ag.kcmedia.ERD2WExtendedRule;
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.directtoweb.Assignment;
import com.webobjects.directtoweb.ERD2WRuleEditorModel;
import com.webobjects.directtoweb.Rule;
import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSet;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXStringUtilities;
import java.io.File;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class RuleEditor
extends WOComponent {
    static final Logger log = Logger.getLogger(RuleEditor.class);
    public WODisplayGroup group;
    public String qualifierString;
    public String error;
    public EOQualifier qualifier;
    public ERD2WExtendedRule currentRule;
    public ERD2WRuleEditorModel model;
    public String fileName;

    public RuleEditor(WOContext context) {
        super(context);
    }

    public void setRuleFileName(String value) {
        this.fileName = value;
        this.model = new ERD2WRuleEditorModel(new File(this.fileName));
        this.group = new WODisplayGroup();
        this.group.setObjectArray(this.model.publicRules());
        this.group.setDefaultStringMatchFormat("*%@*");
    }

    public boolean isStateless() {
        return false;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public EOQualifier qualifier() {
        if (this.qualifier == null) {
            try {
                this.qualifier = EOQualifier.qualifierWithQualifierFormat((String)this.qualifierString, null);
            }
            catch (Throwable ex) {
                this.error = ex.getMessage();
                System.err.println(ex);
            }
        }
        return this.qualifier;
    }

    public String qualifierString() {
        if (this.qualifierString == null && this.qualifier() != null) {
            int offset;
            String decimalString = "(java.math.BigDecimal)'";
            this.qualifierString = this.qualifier().toString();
            while ((offset = this.qualifierString.indexOf(decimalString)) >= 0) {
                this.qualifierString = this.qualifierString.substring(0, offset) + this.qualifierString.substring(offset + decimalString.length());
                offset = this.qualifierString.indexOf("'", offset);
                this.qualifierString = this.qualifierString.substring(0, offset) + this.qualifierString.substring(offset + 1);
            }
        }
        return this.qualifierString;
    }

    public Rule selectedRule() {
        return (Rule)this.group.selectedObject();
    }

    public void setSelectedRule(Rule rule) {
        this.group.setSelectedObject((Object)rule);
        this.qualifier = rule.lhs();
        this.qualifierString = null;
    }

    public String selectedRuleAsString() {
        if (this.selectedRule() != null) {
            return this.objectAsString(this.selectedRule());
        }
        return null;
    }

    public NSArray modelKeys() {
        Class<ERXArrayUtilities> c = ERXArrayUtilities.class;
        NSArray keys = (NSArray)this.model.publicRules().valueForKey("rhsKeyPath");
        keys = (NSArray)new NSSet(keys).allObjects().valueForKey("@sort.toString");
        return keys;
    }

    public String fixString(Object o) {
        String fix = "'" + o + "'";
        return ERXStringUtilities.replaceStringByStringInString((String)"*", (String)"[*]", (String)fix);
    }

    public NSArray modelPages() {
        Enumeration e = this.model.publicDynamicPages().elements();
        NSMutableArray arr = new NSMutableArray();
        while (e.hasMoreElements()) {
            arr.addObject((Object)this.fixString(e.nextElement()));
        }
        return arr;
    }

    public NSArray modelTasks() {
        Enumeration e = this.model.publicTasks();
        NSMutableArray arr = new NSMutableArray();
        while (e.hasMoreElements()) {
            arr.addObject((Object)this.fixString(e.nextElement()));
        }
        return arr;
    }

    public WOComponent pushQualifier() {
        this.qualifier = null;
        this.error = null;
        this.selectedRule().setLhs(this.qualifier());
        return null;
    }

    public WOComponent selectRule() {
        this.setSelectedRule(this.currentRule);
        return null;
    }

    public WOComponent cloneRule() {
        this.currentRule = this.currentRule.cloneRule();
        this.group.insertObjectAtIndex((Object)this.currentRule, 0);
        this.setSelectedRule(this.currentRule);
        return null;
    }

    public WOComponent addRule() {
        ERD2WExtendedRule rule = new ERD2WExtendedRule();
        rule.setAuthor(50);
        rule.setRhs(new Assignment("test", null));
        this.group.insertObjectAtIndex((Object)rule, 0);
        this.setSelectedRule(rule);
        return null;
    }

    public WOComponent deleteRule() {
        Rule oldRule = this.selectedRule();
        this.setSelectedRule(this.currentRule);
        this.group.delete();
        this.setSelectedRule(oldRule);
        return null;
    }

    public String objectAsString(Rule o) {
        EOKeyValueArchiver eokeyvaluearchiver = new EOKeyValueArchiver();
        o.encodeWithKeyValueArchiver(eokeyvaluearchiver);
        return NSPropertyListSerialization.stringFromPropertyList((Object)eokeyvaluearchiver.dictionary());
    }

    public WOComponent eval() {
        this.qualifier = null;
        this.error = null;
        try {
            this.qualifier = EOQualifier.qualifierWithQualifierFormat((String)this.qualifierString, null);
        }
        catch (Throwable ex) {
            this.error = ex.getMessage();
        }
        return null;
    }

    public WOActionResults editor() {
        WOComponent editor = this.pageWithName("ERXQualifierEditor");
        if (this.selectedRule() != null) {
            editor.takeValueForKey((Object)this.selectedRule().lhs(), "qualifier");
        }
        return editor;
    }
}

