/*
 * Decompiled with CFR 0.152.
 */
package er.prototaculous.widgets;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMultipartIterator;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxUpload
extends WOComponent {
    private static boolean useUnobtrusively = ERXProperties.booleanForKeyWithDefault((String)"er.prototaculous.useUnobtrusively", (boolean)false);
    private String elementID;

    public AjaxUpload(WOContext aContext) {
        super(aContext);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public String id() {
        return this._id() == null ? "au" + ERXStringUtilities.safeIdentifierName((String)this.elementID()) : this._id();
    }

    private String elementID() {
        if (this.elementID == null) {
            this.elementID = this.context().elementID();
        }
        return this.elementID;
    }

    private String _id() {
        return (String)this.valueForBinding("id");
    }

    private String _script() {
        return "new AjaxUpload('" + this.id() + "', {" + this.options() + "});";
    }

    public String script() {
        return this.isAjax() ? this._script() : "document.observe('dom:loaded', function() { " + this._script() + " });";
    }

    private boolean isAjax() {
        return ERXAjaxApplication.isAjaxRequest((WORequest)this.context().request());
    }

    protected NSArray<String> _options() {
        NSMutableArray _options = new NSMutableArray((Object)("action:'" + this.href() + "'"));
        if (this.hasBinding("name")) {
            _options.add((Object)("name:'" + this.valueForBinding("name") + "'"));
        }
        if (this.hasBinding("onChange")) {
            _options.add((Object)("onChange:" + this.valueForBinding("onChange")));
        }
        if (this.hasBinding("onComplete")) {
            _options.add((Object)("onComplete:" + this.valueForBinding("onComplete")));
        }
        if (this.hasBinding("onSubmit")) {
            _options.add((Object)("onChange:" + this.valueForBinding("onSubmit")));
        }
        return _options.immutableClone();
    }

    public String options() {
        return this._options().componentsJoinedByString(", ");
    }

    private String _uploadName() {
        return (String)this.valueForBinding("name");
    }

    public String uploadName() {
        return this._uploadName() != null ? this._uploadName() : "userfile";
    }

    protected void setFilePath(String aPath) {
        this.setValueForBinding(aPath, "filePath");
    }

    protected void setData(NSData data) {
        this.setValueForBinding(data, "data");
    }

    protected void setMimeType(String aType) {
        this.setValueForBinding(aType, "mimeType");
    }

    private String href() {
        return this.context().componentActionURL();
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        if (!useUnobtrusively) {
            ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)"Ajax", (String)"prototype.js");
            ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)"Ajax", (String)"scriptaculous.js");
            ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)"ERPrototaculous", (String)"ajaxupload.3.5.js");
        }
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        super.takeValuesFromRequest(request, context);
        if (request.formValueForKey(this.uploadName()) != null) {
            if (this.hasBinding("filePath")) {
                this.setFilePath((String)request.formValueForKey(this.uploadName() + ".filename"));
            }
            if (this.hasBinding("data")) {
                if (this.hasBinding("filePath")) {
                    NSArray aValue = request.formValuesForKey(this.uploadName());
                    if (aValue != null) {
                        NSData data = null;
                        try {
                            data = (NSData)aValue.objectAtIndex(0);
                        }
                        catch (ClassCastException e) {
                            throw new ClassCastException("AjaxUploadButton: Value in request was of type '" + aValue.objectAtIndex(0).getClass().getName() + "' instead of NSData. Verify that the WOForm's 'enctype' binding is set to 'multipart/form-data'");
                        }
                        this.setData(data);
                    }
                    if (this.hasBinding("mimeType")) {
                        this.setMimeType((String)request.formValueForKey(this.uploadName() + ".mimetype"));
                    }
                }
            } else {
                NSDictionary contentDispositionHeaders;
                WOMultipartIterator multipartIterator = request.multipartIterator();
                WOMultipartIterator.WOFormData nextFormData = multipartIterator.nextFormData();
                while (nextFormData != null) {
                    contentDispositionHeaders = nextFormData.contentDispositionHeaders();
                    Object _name = contentDispositionHeaders.objectForKey((Object)"name");
                    if (this.uploadName().equals(_name)) break;
                    nextFormData = multipartIterator.nextFormData();
                }
                if (nextFormData == null) {
                    throw new IllegalStateException("AjaxUploadButton: No form data left for WOFileUpload!");
                }
                contentDispositionHeaders = nextFormData.contentDispositionHeaders();
                String aFileName = null;
                if (this.hasBinding("filePath")) {
                    aFileName = (String)contentDispositionHeaders.valueForKey("filename");
                    this.setFilePath(aFileName);
                }
                if (this.hasBinding("mimeType")) {
                    this.setMimeType((String)contentDispositionHeaders.valueForKey("content-type"));
                }
                InputStream anInputStream = nextFormData.formDataInputStream();
                if (aFileName != null && aFileName.length() > 0) {
                    if (this.hasBinding("inputStream")) {
                        this.setValueForBinding(anInputStream, "inputStream");
                    } else {
                        String localFilePath = null;
                        File tempFile = null;
                        if (!this.hasBinding("outputStream")) {
                            if (this.hasBinding("finalFilePath")) {
                                this.setValueForBinding(null, "finalFilePath");
                            }
                            try {
                                tempFile = ERXFileUtilities.writeInputStreamToTempFile((InputStream)anInputStream, (String)context.session().sessionID(), (String)".tmp");
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Couldn't write input stream to temp file: " + e);
                            }
                        }
                        OutputStream anOutputStream = (OutputStream)this.valueForBinding("outputStream");
                        try {
                            ERXFileUtilities.writeInputStreamToOutputStream((InputStream)anInputStream, (OutputStream)anOutputStream);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Couldn't write input stream to output stream: " + e);
                        }
                        if (this.hasBinding("streamToFilePath")) {
                            localFilePath = (String)this.valueForBinding("streamToFilePath");
                            try {
                                ERXFileUtilities.renameTo((File)tempFile, (File)new File(localFilePath));
                                this.setValueForBinding(localFilePath, "finalFilePath");
                            }
                            catch (Exception e) {
                                this.setValueForBinding(tempFile.getPath(), "finalFilePath");
                                throw new RuntimeException("Couldn't rename temp file: " + e);
                            }
                        }
                    }
                } else {
                    if (this.hasBinding("inputStream")) {
                        this.setValueForBinding(null, "inputStream");
                    }
                    if (this.hasBinding("finalFilePath")) {
                        this.setValueForBinding(null, "finalFilePath");
                    }
                    byte[] buffer = new byte[128];
                    try {
                        while (anInputStream.read(buffer) != -1) {
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error skipping empty file upload: " + e);
                    }
                }
            }
        }
    }

    public static interface Headers {
        public static final String filename = "filename";
        public static final String contentType = "content-type";
        public static final String name = "name";
    }

    public static interface Bindings {
        public static final String id = "id";
        public static final String name = "name";
        public static final String onChange = "onChange";
        public static final String onSubmit = "onSubmit";
        public static final String onComplete = "onComplete";
        public static final String filePath = "filePath";
        public static final String data = "data";
        public static final String mimeType = "mimeType";
        public static final String inputStream = "inputStream";
        public static final String outputStream = "outputStream";
        public static final String finalFilePath = "finalFilePath";
        public static final String streamToFilePath = "streamToFilePath";
    }
}

