/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service;

import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.MutableService;
import net.kano.joustsim.oscar.oscar.service.ServiceEvent;
import net.kano.joustsim.oscar.oscar.service.ServiceListener;

public abstract class AbstractService
implements MutableService {
    private static final Logger logger = LoggingSystem.getLogger((String)AbstractService.class.getName());
    private AimConnection aimConnection;
    private final OscarConnection oscarConnection;
    private final int family;
    private CopyOnWriteArrayList<ServiceListener> listeners = new CopyOnWriteArrayList();
    private boolean ready = false;
    private boolean finished = false;

    protected AbstractService(AimConnection aimConnection, OscarConnection oscarConnection, int family) {
        logger.logFine("Created new " + this.getClass().getName());
        this.aimConnection = aimConnection;
        this.oscarConnection = oscarConnection;
        this.family = family;
    }

    public final AimConnection getAimConnection() {
        return this.aimConnection;
    }

    public final OscarConnection getOscarConnection() {
        return this.oscarConnection;
    }

    public final int getFamily() {
        return this.family;
    }

    public void addServiceListener(ServiceListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeServiceListener(ServiceListener l) {
        this.listeners.remove((Object)l);
    }

    public final synchronized boolean isReady() {
        return this.ready;
    }

    public final synchronized boolean isFinished() {
        return this.finished;
    }

    protected final void sendFlap(FlapCommand flap) {
        this.oscarConnection.sendFlap(flap);
    }

    protected final void sendDirectedSnac(SnacCommand snac) {
        this.aimConnection.sendSnac(snac);
    }

    public final void sendSnac(SnacCommand snac) {
        DefensiveTools.checkNull((Object)snac, (String)"snac");
        this.oscarConnection.sendSnac(snac);
    }

    public final void sendSnacRequest(SnacRequest request) {
        DefensiveTools.checkNull((Object)request, (String)"request");
        this.oscarConnection.sendSnacRequest(request);
    }

    public final void sendSnacRequest(SnacCommand cmd, SnacRequestListener listener) {
        DefensiveTools.checkNull((Object)cmd, (String)"cmd");
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        this.oscarConnection.sendSnacRequest(cmd, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setReady() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.ready) {
                return;
            }
            this.ready = true;
        }
        logger.logFiner(MiscTools.getClassName((Object)this) + " is ready");
        for (ServiceListener l : this.listeners) {
            l.handleServiceReady(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setFinished() {
        logger.logFiner(MiscTools.getClassName((Object)this) + " is finished");
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        for (ServiceListener l : this.listeners) {
            l.handleServiceFinished(this);
        }
    }

    public void connected() {
    }

    public final void disconnected() {
        this.finishUp();
        this.setFinished();
    }

    protected void finishUp() {
    }

    public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
    }

    public void handleSnacResponse(SnacResponseEvent snacResponseEvent) {
        this.handleSnacPacket((SnacPacketEvent)snacResponseEvent);
    }

    public void handleEvent(ServiceEvent event) {
    }
}

