/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.jdbcadaptor.JDBCExpression;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Enumeration;

public class PostgresqlExpression
extends JDBCExpression {
    public static final NSSelector CASE_INSENSITIVE_REGEX_OPERATOR = new NSSelector("~*", new Class[]{Object.class});
    public static final NSSelector REGEX_OPERATOR = new NSSelector("~", new Class[]{Object.class});
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char SQL_ESCAPE_CHAR = '|';
    private static final String EXTERNAL_NAME_QUOTE_CHARACTER = "\"";
    private static final NSTimestampFormatter DATE_FORMATTER = new NSTimestampFormatter("%Y-%m-%d");
    private static final NSTimestampFormatter TIMESTAMP_FORMATTER = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S.%F");
    private static Method _bigDecimalToString = null;
    private Boolean _disableTypeCasting = null;
    private Boolean _disableBindVariables = null;
    private NSMutableArray _alreadyJoined = new NSMutableArray();
    private int _fetchLimit;
    private Boolean _enableIdentifierQuoting;
    private Boolean _enableBooleanQuoting;
    private Boolean _useLowercaseForCaseInsensitiveLike;

    public PostgresqlExpression(EOEntity entity) {
        super(entity);
        String customFunctionName;
        if (this.useLowercaseForCaseInsensitiveLike()) {
            this._upperFunctionName = "LOWER";
        }
        if ((customFunctionName = this.customFunctionForStringComparison()) != null) {
            this._upperFunctionName = customFunctionName;
        }
    }

    private boolean enableBooleanQuoting() {
        if (this._enableBooleanQuoting == null) {
            this._enableBooleanQuoting = Boolean.getBoolean(((Object)((Object)this)).getClass().getName() + ".enableBooleanQuoting") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._enableBooleanQuoting;
    }

    private boolean enableIdentifierQuoting() {
        if (this._enableIdentifierQuoting == null) {
            this._enableIdentifierQuoting = Boolean.getBoolean(((Object)((Object)this)).getClass().getName() + ".enableIdentifierQuoting") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._enableIdentifierQuoting;
    }

    public NSMutableDictionary bindVariableDictionaryForAttribute(EOAttribute eoattribute, Object obj) {
        NSMutableDictionary result = super.bindVariableDictionaryForAttribute(eoattribute, obj);
        if (obj instanceof NSTimestamp && this.isTimestampAttribute(eoattribute)) {
            NSTimestamp nstimestamp = (NSTimestamp)obj;
            long millis = nstimestamp.getTime();
            Timestamp timestamp = new Timestamp(millis);
            timestamp.setNanos(timestamp.getNanos() + nstimestamp.getNanos());
            result.setObjectForKey((Object)timestamp, (Object)"BindVariableValue");
        }
        return result;
    }

    public void addJoinClause(String leftName, String rightName, int semantic) {
        this.assembleJoinClause(leftName, rightName, semantic);
    }

    public String assembleJoinClause(String leftName, String rightName, int semantic) {
        String leftTable;
        String rightTable;
        EOEntity rightEntity;
        NSArray k;
        EOEntity leftEntity;
        if (!this.useAliases()) {
            return super.assembleJoinClause(leftName, rightName, semantic);
        }
        String leftAlias = leftName.substring(0, leftName.indexOf("."));
        String rightAlias = rightName.substring(0, rightName.indexOf("."));
        String relationshipKey = null;
        if (leftAlias.equals("t0")) {
            leftEntity = this.entity();
        } else {
            k = this.aliasesByRelationshipPath().allKeysForObject((Object)leftAlias);
            relationshipKey = k.count() > 0 ? (String)k.lastObject() : "";
            leftEntity = this.entityForKeyPath(relationshipKey);
        }
        if (rightAlias.equals("t0")) {
            rightEntity = this.entity();
        } else {
            k = this.aliasesByRelationshipPath().allKeysForObject((Object)rightAlias);
            relationshipKey = k.count() > 0 ? (String)k.lastObject() : "";
            rightEntity = this.entityForKeyPath(relationshipKey);
        }
        int dotIndex = relationshipKey.indexOf(".");
        relationshipKey = dotIndex == -1 ? relationshipKey : relationshipKey.substring(relationshipKey.lastIndexOf(".") + 1);
        EORelationship r = rightEntity.anyRelationshipNamed(relationshipKey);
        if (r == null || r.destinationEntity() != leftEntity) {
            r = leftEntity.anyRelationshipNamed(relationshipKey);
        }
        if (this.enableIdentifierQuoting()) {
            rightTable = rightEntity.valueForSQLExpression((EOSQLExpression)this);
            leftTable = leftEntity.valueForSQLExpression((EOSQLExpression)this);
        } else {
            rightTable = rightEntity.externalName();
            leftTable = leftEntity.externalName();
        }
        JoinClause jc = new JoinClause();
        jc.table1 = leftTable + " " + leftAlias;
        switch (semantic) {
            case 2: {
                jc.op = " LEFT OUTER JOIN ";
                break;
            }
            case 3: {
                jc.op = " RIGHT OUTER JOIN ";
                break;
            }
            case 1: {
                jc.op = " FULL OUTER JOIN ";
                break;
            }
            case 0: {
                jc.op = " INNER JOIN ";
            }
        }
        jc.table2 = rightTable + " " + rightAlias;
        NSArray joins = r.joins();
        int joinsCount = joins.count();
        NSMutableArray joinStrings = new NSMutableArray(joinsCount);
        for (int i = 0; i < joinsCount; ++i) {
            String right;
            String left;
            EOJoin currentJoin = (EOJoin)joins.objectAtIndex(i);
            if (this.enableIdentifierQuoting()) {
                left = leftAlias + "." + this.sqlStringForSchemaObjectName(currentJoin.sourceAttribute().columnName());
                right = rightAlias + "." + this.sqlStringForSchemaObjectName(currentJoin.destinationAttribute().columnName());
            } else {
                left = leftAlias + "." + currentJoin.sourceAttribute().columnName();
                right = rightAlias + "." + currentJoin.destinationAttribute().columnName();
            }
            joinStrings.addObject((Object)(left + " = " + right));
        }
        jc.joinCondition = " ON " + joinStrings.componentsJoinedByString(" AND ");
        if (!this._alreadyJoined.containsObject((Object)jc)) {
            this._alreadyJoined.insertObjectAtIndex((Object)jc, 0);
            return jc.toString();
        }
        return null;
    }

    public String assembleSelectStatementWithAttributes(NSArray attributes, boolean lock, EOQualifier qualifier, NSArray fetchOrder, String selectString, String columnList, String tableList, String whereClause, String joinClause, String orderByClause, String lockClause) {
        StringBuffer sb = new StringBuffer();
        sb.append(selectString);
        sb.append(columnList);
        if (selectString.indexOf(" DISTINCT") != -1) {
            String[] columns = orderByClause.split(",");
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i].replaceFirst("\\s+(ASC|DESC)\\s*", "");
                if (columnList.indexOf(column) != -1) continue;
                sb.append(", ");
                sb.append(column);
            }
        }
        sb.append(" FROM ");
        String fieldString = this._alreadyJoined.count() > 0 ? this.joinClauseString() : tableList;
        sb.append(fieldString);
        if (whereClause != null && whereClause.length() > 0 || joinClause != null && joinClause.length() > 0) {
            sb.append(" WHERE ");
            if (joinClause != null && joinClause.length() > 0) {
                sb.append(joinClause);
                if (whereClause != null && whereClause.length() > 0) {
                    sb.append(" AND ");
                }
            }
            if (whereClause != null && whereClause.length() > 0) {
                sb.append(whereClause);
            }
        }
        if (orderByClause != null && orderByClause.length() > 0) {
            sb.append(" ORDER BY ");
            sb.append(orderByClause);
        }
        if (lockClause != null && lockClause.length() > 0) {
            sb.append(" ");
            sb.append(lockClause);
        }
        if (this._fetchLimit != 0) {
            sb.append(" LIMIT ");
            sb.append(this._fetchLimit);
        }
        return sb.toString();
    }

    public String columnTypeStringForAttribute(EOAttribute attribute) {
        String externalType = attribute.externalType();
        if (externalType != null && externalType.endsWith("[]")) {
            return externalType;
        }
        return super.columnTypeStringForAttribute(attribute);
    }

    private EOEntity entityForKeyPath(String keyPath) {
        NSArray keys = NSArray.componentsSeparatedByString((String)keyPath, (String)".");
        EOEntity ent = this.entity();
        for (int i = 0; i < keys.count(); ++i) {
            String k = (String)keys.objectAtIndex(i);
            EORelationship rel = ent.anyRelationshipNamed(k);
            if (rel == null) {
                if (ent.anyAttributeNamed(k) != null) break;
                throw new IllegalArgumentException("relationship " + keyPath + " generated null");
            }
            ent = rel.destinationEntity();
        }
        return ent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String formatValueForAttribute(Object obj, EOAttribute eoattribute) {
        if (obj instanceof NSData) {
            return this.sqlStringForData((NSData)obj);
        }
        if (obj instanceof NSTimestamp && this.isTimestampAttribute(eoattribute)) {
            return "'" + TIMESTAMP_FORMATTER.format(obj) + "'";
        }
        if (obj instanceof NSTimestamp && this.isDateAttribute(eoattribute)) {
            return "'" + DATE_FORMATTER.format(obj) + "'";
        }
        if (obj instanceof String) {
            return this.formatStringValue((String)obj);
        }
        if (obj instanceof Number) {
            if (obj instanceof BigDecimal) {
                return this.fixBigDecimal((BigDecimal)obj, eoattribute);
            }
            Object convertedObj = eoattribute.adaptorValueByConvertingAttributeValue(obj);
            if (convertedObj instanceof Number) {
                String valueType = eoattribute.valueType();
                if (valueType == null) return String.valueOf(((Number)convertedObj).intValue());
                if ("i".equals(valueType)) {
                    return String.valueOf(((Number)convertedObj).intValue());
                }
                if ("l".equals(valueType)) {
                    return String.valueOf(((Number)convertedObj).longValue());
                }
                if ("f".equals(valueType)) {
                    return String.valueOf(((Number)convertedObj).floatValue());
                }
                if ("d".equals(valueType)) {
                    return String.valueOf(((Number)convertedObj).doubleValue());
                }
                if ("s".equals(valueType)) {
                    return String.valueOf(((Number)convertedObj).shortValue());
                }
                if (!"c".equals(valueType)) throw new IllegalArgumentException("Unknown number value type '" + valueType + "' for attribute " + eoattribute.entity().name() + "." + eoattribute.name() + ".");
                return String.valueOf(((Number)convertedObj).intValue());
            }
            if (!(convertedObj instanceof String)) throw new IllegalArgumentException("Unknown number value '" + obj + "' for attribute " + eoattribute.entity().name() + "." + eoattribute.name() + ".");
            String str = (String)obj;
            String valueType = eoattribute.valueType();
            if (valueType == null) return String.valueOf(Integer.parseInt(str));
            if ("i".equals(valueType)) {
                return String.valueOf(Integer.parseInt(str));
            }
            if ("l".equals(valueType)) {
                return String.valueOf(Long.parseLong(str));
            }
            if ("f".equals(valueType)) {
                return String.valueOf(Float.parseFloat(str));
            }
            if ("d".equals(valueType)) {
                return String.valueOf(Double.parseDouble(str));
            }
            if ("s".equals(valueType)) {
                return String.valueOf(Short.parseShort(str));
            }
            if (!"c".equals(valueType)) throw new IllegalArgumentException("Unknown number value type '" + valueType + "' for attribute " + eoattribute.entity().name() + "." + eoattribute.name() + ".");
            return String.valueOf(Integer.parseInt(str));
        }
        if (obj instanceof Boolean) {
            if (this.enableBooleanQuoting()) return "'" + ((Boolean)obj).toString() + "'";
            if ("S".equals(eoattribute.valueType())) {
                return "'" + ((Boolean)obj).toString() + "'";
            }
            if (!(!"bool".equals(eoattribute.externalType().toLowerCase()) && "NSNumber".equals(eoattribute.valueClassName()) || "java.lang.Number".equals(eoattribute.valueClassName()))) {
                if (!"Number".equals(eoattribute.valueClassName())) return ((Boolean)obj).toString();
            }
            if ((Boolean)obj == false) return "0";
            return "1";
        }
        if (obj instanceof Timestamp) {
            return "'" + ((Timestamp)obj).toString() + "'";
        }
        if (obj == null) return "NULL";
        if (obj == NSKeyValueCoding.NullValue) {
            return "NULL";
        }
        try {
            Object adaptorValue = eoattribute.adaptorValueByConvertingAttributeValue(obj);
            if (adaptorValue instanceof NSData) return this.formatValueForAttribute(adaptorValue, eoattribute);
            if (adaptorValue instanceof NSTimestamp) return this.formatValueForAttribute(adaptorValue, eoattribute);
            if (adaptorValue instanceof String) return this.formatValueForAttribute(adaptorValue, eoattribute);
            if (adaptorValue instanceof Number) return this.formatValueForAttribute(adaptorValue, eoattribute);
            if (!(adaptorValue instanceof Boolean)) throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + ": Can't convert: " + obj + ":" + obj.getClass() + " -> " + adaptorValue + ":" + adaptorValue.getClass());
            return this.formatValueForAttribute(adaptorValue, eoattribute);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + ": Exception while converting " + obj.getClass().getName(), ex);
        }
    }

    private String fixBigDecimal(BigDecimal value, EOAttribute eoattribute) {
        String result;
        if (System.getProperty("java.version").compareTo("1.5") >= 0) {
            try {
                if (_bigDecimalToString == null) {
                    _bigDecimalToString = BigDecimal.class.getMethod("toPlainString", null);
                }
                result = (String)_bigDecimalToString.invoke((Object)value, (Object[])null);
            }
            catch (IllegalArgumentException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (SecurityException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        } else {
            result = value.toString();
        }
        return result;
    }

    private boolean isDateAttribute(EOAttribute eoattribute) {
        return "D".equals(eoattribute.valueType());
    }

    private boolean isTimestampAttribute(EOAttribute eoattribute) {
        return "T".equals(eoattribute.valueType());
    }

    private boolean isDataAttribute(EOAttribute attribute) {
        return (attribute.className().equals("com.webobjects.foundation.NSData") || attribute.externalType().equals("bytea") || attribute.externalType().equals("bit")) && this.entity().classProperties().containsObject((Object)attribute);
    }

    public String joinClauseString() {
        JoinClause jc;
        NSMutableDictionary seenIt = new NSMutableDictionary();
        StringBuffer sb = new StringBuffer();
        EOSortOrdering.sortArrayUsingKeyOrderArray((NSMutableArray)this._alreadyJoined, (NSArray)new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"sortKey", (NSSelector)EOSortOrdering.CompareCaseInsensitiveAscending)));
        if (this._alreadyJoined.count() > 0) {
            jc = (JoinClause)this._alreadyJoined.objectAtIndex(0);
            sb.append(jc);
            seenIt.setObjectForKey((Object)Boolean.TRUE, (Object)jc.table1);
            seenIt.setObjectForKey((Object)Boolean.TRUE, (Object)jc.table2);
        }
        for (int i = 1; i < this._alreadyJoined.count(); ++i) {
            jc = (JoinClause)this._alreadyJoined.objectAtIndex(i);
            sb.append(jc.op);
            if (seenIt.objectForKey((Object)jc.table1) == null) {
                sb.append(jc.table1);
                seenIt.setObjectForKey((Object)Boolean.TRUE, (Object)jc.table1);
            } else if (seenIt.objectForKey((Object)jc.table2) == null) {
                sb.append(jc.table2);
                seenIt.setObjectForKey((Object)Boolean.TRUE, (Object)jc.table2);
            }
            sb.append(jc.joinCondition);
        }
        return sb.toString();
    }

    public void prepareConstraintStatementForRelationship(EORelationship relationship, NSArray sourceColumns, NSArray destinationColumns) {
        EOModel destModel;
        EOEntity entity = relationship.entity();
        String tableName = entity.externalName();
        int lastDot = tableName.lastIndexOf(46);
        if (lastDot >= 0) {
            tableName = tableName.substring(lastDot + 1);
        }
        String constraintName = _NSStringUtilities.concat((String)tableName, (String)"_", (String)relationship.name(), (String)"_FK");
        String sourceKeyList = this.quoteArrayContents(sourceColumns).componentsJoinedByString(", ");
        String destinationKeyList = this.quoteArrayContents(destinationColumns).componentsJoinedByString(", ");
        EOModel sourceModel = entity.model();
        if (sourceModel != (destModel = relationship.destinationEntity().model()) && !sourceModel.connectionDictionary().equals((Object)destModel.connectionDictionary())) {
            throw new IllegalArgumentException("prepareConstraintStatementForRelationship unable to create a constraint for " + relationship.name() + " because the source and destination entities reside in different databases");
        }
        this.setStatement("ALTER TABLE " + this.sqlStringForSchemaObjectName(tableName) + " ADD CONSTRAINT " + this.quoteIdentifier(constraintName) + " FOREIGN KEY (" + sourceKeyList + ") REFERENCES " + this.sqlStringForSchemaObjectName(relationship.destinationEntity().externalName()) + " (" + destinationKeyList + ") INITIALLY DEFERRED");
    }

    private NSArray quoteArrayContents(NSArray a) {
        Enumeration enumeration = a.objectEnumerator();
        NSMutableArray result = new NSMutableArray();
        while (enumeration.hasMoreElements()) {
            String identifier = (String)enumeration.nextElement();
            String quotedString = this.quoteIdentifier(identifier);
            result.addObject((Object)quotedString);
        }
        return result;
    }

    private String quoteIdentifier(String identifier) {
        return this.externalNameQuoteCharacter() + identifier + this.externalNameQuoteCharacter();
    }

    public void prepareSelectExpressionWithAttributes(NSArray nsarray, boolean flag, EOFetchSpecification eofetchspecification) {
        if (!eofetchspecification.promptsAfterFetchLimit()) {
            this._fetchLimit = eofetchspecification.fetchLimit();
        }
        super.prepareSelectExpressionWithAttributes(nsarray, flag, eofetchspecification);
    }

    public char sqlEscapeChar() {
        return '|';
    }

    public String externalNameQuoteCharacter() {
        return this.enableIdentifierQuoting() ? EXTERNAL_NAME_QUOTE_CHARACTER : "";
    }

    protected boolean shouldAllowNull(EOAttribute attribute) {
        boolean shouldAllowNull = attribute.allowsNull();
        if (!shouldAllowNull) {
            EOEntity entity = attribute.entity();
            EOEntity parentEntity = entity.parentEntity();
            String externalName = entity.externalName();
            if (externalName != null) {
                EOAttribute parentAttribute;
                boolean singleTableInheritance;
                boolean bl = singleTableInheritance = parentEntity != null && externalName.equals(parentEntity.externalName());
                if (singleTableInheritance && (parentAttribute = parentEntity.attributeNamed(attribute.name())) == null) {
                    shouldAllowNull = true;
                }
            }
        }
        return shouldAllowNull;
    }

    public void addCreateClauseForAttribute(EOAttribute attribute) {
        NSDictionary userInfo = attribute.userInfo();
        Object defaultValue = null;
        if (userInfo != null) {
            defaultValue = userInfo.valueForKey("er.extensions.eoattribute.default");
        }
        String allowsNullClauseForConstraint = this.allowsNullClauseForConstraint(this.shouldAllowNull(attribute));
        String sql = defaultValue == null ? _NSStringUtilities.concat((String)this.quoteIdentifier(attribute.columnName()), (String)" ", (String)this.columnTypeStringForAttribute(attribute), (String)" ", (String)allowsNullClauseForConstraint) : _NSStringUtilities.concat((String)this.quoteIdentifier(attribute.columnName()), (String)" ", (String)this.columnTypeStringForAttribute(attribute), (String)" DEFAULT ", (String)this.formatValueForAttribute(defaultValue, attribute), (String)" ", (String)allowsNullClauseForConstraint);
        this.appendItemToListString(sql, this._listString());
    }

    public String allowsNullClauseForConstraint(boolean allowsNull) {
        if (allowsNull) {
            return "";
        }
        Object value = this.jdbcInfo().objectForKey((Object)"NON_NULLABLE_COLUMNS");
        if (value != null && value.equals("T")) {
            return " NOT NULL";
        }
        return "";
    }

    public String sqlStringForAttribute(EOAttribute attribute) {
        String sql = null;
        sql = attribute.isDerived() || this.useAliases() || attribute.columnName() == null || !this.enableIdentifierQuoting() ? super.sqlStringForAttribute(attribute) : this.sqlStringForSchemaObjectName(attribute.columnName());
        return sql;
    }

    public String tableListWithRootEntity(EOEntity entity) {
        String sql = null;
        sql = this.useAliases() ? super.tableListWithRootEntity(entity) : entity.valueForSQLExpression((EOSQLExpression)this);
        return sql;
    }

    public String sqlStringForData(NSData data) {
        int length = data.length();
        byte[] bytes = data.bytes();
        char[] hex = new char[2 * length];
        int nibbles = 0;
        for (int i = 0; i < length; ++i) {
            byte b = bytes[i];
            hex[nibbles++] = HEX_VALUES[((b >> 4) + 16) % 16];
            hex[nibbles++] = HEX_VALUES[((b & 0xF) + 16) % 16];
        }
        return "decode('" + new String(hex) + "','hex')";
    }

    public String sqlStringForSelector(NSSelector selector, Object value) {
        if (CASE_INSENSITIVE_REGEX_OPERATOR.name().equals(selector.name()) || REGEX_OPERATOR.name().equals(selector.name())) {
            return selector.name();
        }
        return super.sqlStringForSelector(selector, value);
    }

    public String sqlStringForValue(Object v, String kp) {
        EOAttribute attribute;
        if (this.disableTypeCasting()) {
            return super.sqlStringForValue(v, kp);
        }
        int lastDotIdx = kp.lastIndexOf(".");
        if (lastDotIdx == -1) {
            attribute = this.entity().attributeNamed(kp);
        } else {
            EOEntity kpEntity = this.entityForKeyPath(kp);
            attribute = kpEntity.attributeNamed(kp.substring(lastDotIdx + 1));
        }
        if (attribute != null && v != null && v != NSKeyValueCoding.NullValue) {
            String s = this.columnTypeStringForAttribute(attribute);
            return super.sqlStringForValue(v, kp) + "::" + s;
        }
        return super.sqlStringForValue(v, kp);
    }

    private boolean disableTypeCasting() {
        if (this._disableTypeCasting == null) {
            this._disableTypeCasting = Boolean.getBoolean("com.webobjects.jdbcadaptor.PostgresqlExpression.disableTypeCasting") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._disableTypeCasting;
    }

    private boolean disableBindVariables() {
        if (this._disableBindVariables == null) {
            this._disableBindVariables = Boolean.getBoolean("com.webobjects.jdbcadaptor.PostgresqlExpression.disableBindVariables") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._disableBindVariables;
    }

    public boolean useBindVariables() {
        return !this.disableBindVariables();
    }

    public void setUseBindVariables(boolean value) {
        this._disableBindVariables = value ? Boolean.FALSE : Boolean.TRUE;
    }

    public boolean shouldUseBindVariableForAttribute(EOAttribute attribute) {
        return this.useBindVariables() || this.isDataAttribute(attribute);
    }

    public boolean mustUseBindVariableForAttribute(EOAttribute attribute) {
        return this.useBindVariables() || this.isDataAttribute(attribute);
    }

    public static String replaceStringByStringInString(String old, String newString, String buffer) {
        int oldLength = old.length();
        int length = buffer.length();
        StringBuffer convertedString = new StringBuffer(length + 100);
        int begin = 0;
        while (begin < length) {
            int end = buffer.indexOf(old, begin);
            if (end == -1) {
                convertedString.append(buffer.substring(begin));
                break;
            }
            if (end == 0) {
                convertedString.append(newString);
            } else {
                convertedString.append(buffer.substring(begin, end));
                convertedString.append(newString);
            }
            begin = end + oldLength;
        }
        return convertedString.toString();
    }

    private boolean useLowercaseForCaseInsensitiveLike() {
        if (this._useLowercaseForCaseInsensitiveLike == null) {
            this._useLowercaseForCaseInsensitiveLike = Boolean.getBoolean(((Object)((Object)this)).getClass().getName() + ".useLowercaseForCaseInsensitiveLike") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._useLowercaseForCaseInsensitiveLike;
    }

    private String customFunctionForStringComparison() {
        return System.getProperty(((Object)((Object)this)).getClass().getName() + ".customFunctionForStringComparison");
    }

    public class JoinClause {
        String table1;
        String op;
        String table2;
        String joinCondition;

        public String toString() {
            return this.table1 + this.op + this.table2 + this.joinCondition;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof JoinClause)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public String sortKey() {
            return this.table1.substring(this.table1.indexOf(" ") + 1);
        }
    }
}

