/*
 * Decompiled with CFR 0.152.
 */
package er.chronic;

import com.webobjects.foundation.NSTimestamp;
import er.chronic.Chronic;
import er.chronic.Options;
import er.chronic.utils.Span;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChronicFormatter
extends SimpleDateFormat {
    private Options _options;
    private boolean _guessingEarly;

    public ChronicFormatter(String pattern) {
        this(pattern, null, true);
    }

    public ChronicFormatter(String pattern, Options options) {
        this(pattern, options, true);
    }

    public ChronicFormatter(String pattern, Options options, boolean guessingEarly) {
        super(pattern);
        this._options = options;
        this._guessingEarly = guessingEarly;
    }

    public Options options() {
        if (this._options == null) {
            this._options = new Options();
        }
        return this._options;
    }

    public void setOptions(Options options) {
        this._options = options;
    }

    public boolean isGuessingEarly() {
        return this._guessingEarly;
    }

    public void setGuessingEarly(boolean guessingEarly) {
        this._guessingEarly = guessingEarly;
    }

    public NSTimestamp parseObject(String text) throws ParseException {
        NSTimestamp parsedTimestamp = null;
        try {
            Date parsedDate = super.parse(text);
            parsedTimestamp = new NSTimestamp(parsedDate);
        }
        catch (ParseException e) {
            Span span = Chronic.parse(text, this.options());
            if (span == null) {
                throw e;
            }
            parsedTimestamp = span.isSingularity() || this.isGuessingEarly() ? new NSTimestamp(span.getBeginCalendar().getTime()) : new NSTimestamp(span.getEndCalendar().getTime());
        }
        return parsedTimestamp;
    }
}

