/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.repeaters;

import er.chronic.repeaters.RepeaterUnit;
import er.chronic.tags.Pointer;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import java.util.Calendar;

public class RepeaterHour
extends RepeaterUnit {
    public static final int HOUR_SECONDS = 3600;
    private Calendar _currentDayStart;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Span _nextSpan(Pointer.PointerType pointer) {
        if (this._currentDayStart == null) {
            if (pointer == Pointer.PointerType.FUTURE) {
                this._currentDayStart = Time.cloneAndAdd(Time.ymdh(this.getNow()), 10, 1.0f);
                return new Span(this._currentDayStart, 10, 1.0f);
            } else {
                if (pointer != Pointer.PointerType.PAST) throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
                this._currentDayStart = Time.cloneAndAdd(Time.ymdh(this.getNow()), 10, -1.0f);
            }
            return new Span(this._currentDayStart, 10, 1.0f);
        } else {
            int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
            this._currentDayStart.add(10, direction);
        }
        return new Span(this._currentDayStart, 10, 1.0f);
    }

    protected Span _thisSpan(Pointer.PointerType pointer) {
        Calendar hourEnd;
        Calendar hourStart;
        if (pointer == Pointer.PointerType.FUTURE) {
            hourStart = Time.cloneAndAdd(Time.ymdhm(this.getNow()), 12, 1.0f);
            hourEnd = Time.cloneAndAdd(Time.ymdh(this.getNow()), 10, 1.0f);
        } else if (pointer == Pointer.PointerType.PAST) {
            hourStart = Time.ymdh(this.getNow());
            hourEnd = Time.ymdhm(this.getNow());
        } else if (pointer == Pointer.PointerType.NONE) {
            hourStart = Time.ymdh(this.getNow());
            hourEnd = Time.cloneAndAdd(hourStart, 10, 1.0f);
        } else {
            throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
        }
        return new Span(hourStart, hourEnd);
    }

    public Span getOffset(Span span, float amount, Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        return span.add((float)direction * amount * 3600.0f);
    }

    public int getWidth() {
        return 3600;
    }

    public String toString() {
        return super.toString() + "-hour";
    }
}

