/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.repeaters;

import er.chronic.repeaters.RepeaterUnit;
import er.chronic.tags.Pointer;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import java.util.Calendar;

public class RepeaterMinute
extends RepeaterUnit {
    public static final int MINUTE_SECONDS = 60;
    private Calendar _currentMinuteStart;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Span _nextSpan(Pointer.PointerType pointer) {
        if (this._currentMinuteStart == null) {
            if (pointer == Pointer.PointerType.FUTURE) {
                this._currentMinuteStart = Time.cloneAndAdd(Time.ymdhm(this.getNow()), 12, 1.0f);
                return new Span(this._currentMinuteStart, 13, 60.0f);
            } else {
                if (pointer != Pointer.PointerType.PAST) throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
                this._currentMinuteStart = Time.cloneAndAdd(Time.ymdhm(this.getNow()), 12, -1.0f);
            }
            return new Span(this._currentMinuteStart, 13, 60.0f);
        } else {
            int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
            this._currentMinuteStart.add(12, direction);
        }
        return new Span(this._currentMinuteStart, 13, 60.0f);
    }

    protected Span _thisSpan(Pointer.PointerType pointer) {
        Calendar minuteEnd;
        Calendar minuteBegin;
        if (pointer == Pointer.PointerType.FUTURE) {
            minuteBegin = this.getNow();
            minuteEnd = Time.ymdhm(this.getNow());
        } else if (pointer == Pointer.PointerType.PAST) {
            minuteBegin = Time.ymdhm(this.getNow());
            minuteEnd = this.getNow();
        } else if (pointer == Pointer.PointerType.NONE) {
            minuteBegin = Time.ymdhm(this.getNow());
            minuteEnd = Time.cloneAndAdd(Time.ymdhm(this.getNow()), 13, 60.0f);
        } else {
            throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
        }
        return new Span(minuteBegin, minuteEnd);
    }

    public Span getOffset(Span span, float amount, Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        return span.add((float)direction * amount * 60.0f);
    }

    public int getWidth() {
        return 60;
    }

    public String toString() {
        return super.toString() + "-minute";
    }
}

