/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.repeaters;

import er.chronic.repeaters.RepeaterDayName;
import er.chronic.repeaters.RepeaterUnit;
import er.chronic.tags.Pointer;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import java.util.Calendar;

public class RepeaterWeekend
extends RepeaterUnit {
    public static final int WEEKEND_SECONDS = 172800;
    private Calendar _currentWeekStart;

    protected Span _nextSpan(Pointer.PointerType pointer) {
        if (this._currentWeekStart == null) {
            if (pointer == Pointer.PointerType.FUTURE) {
                RepeaterDayName saturdayRepeater = new RepeaterDayName(RepeaterDayName.DayName.SATURDAY);
                saturdayRepeater.setStart((Calendar)this.getNow().clone());
                Span nextSaturdaySpan = saturdayRepeater.nextSpan(Pointer.PointerType.FUTURE);
                this._currentWeekStart = nextSaturdaySpan.getBeginCalendar();
            } else if (pointer == Pointer.PointerType.PAST) {
                RepeaterDayName saturdayRepeater = new RepeaterDayName(RepeaterDayName.DayName.SATURDAY);
                saturdayRepeater.setStart(Time.cloneAndAdd(this.getNow(), 13, 86400.0f));
                Span lastSaturdaySpan = saturdayRepeater.nextSpan(Pointer.PointerType.PAST);
                this._currentWeekStart = lastSaturdaySpan.getBeginCalendar();
            }
        } else {
            int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
            this._currentWeekStart = Time.cloneAndAdd(this._currentWeekStart, 13, direction * 604800);
        }
        return new Span(this._currentWeekStart, Time.cloneAndAdd(this._currentWeekStart, 13, 172800.0f));
    }

    protected Span _thisSpan(Pointer.PointerType pointer) {
        Span thisSpan;
        if (pointer == Pointer.PointerType.FUTURE || pointer == Pointer.PointerType.NONE) {
            RepeaterDayName saturdayRepeater = new RepeaterDayName(RepeaterDayName.DayName.SATURDAY);
            saturdayRepeater.setStart((Calendar)this.getNow().clone());
            Span thisSaturdaySpan = saturdayRepeater.nextSpan(Pointer.PointerType.FUTURE);
            thisSpan = new Span(thisSaturdaySpan.getBeginCalendar(), Time.cloneAndAdd(thisSaturdaySpan.getBeginCalendar(), 13, 172800.0f));
        } else if (pointer == Pointer.PointerType.PAST) {
            RepeaterDayName saturdayRepeater = new RepeaterDayName(RepeaterDayName.DayName.SATURDAY);
            saturdayRepeater.setStart((Calendar)this.getNow().clone());
            Span lastSaturdaySpan = saturdayRepeater.nextSpan(Pointer.PointerType.PAST);
            thisSpan = new Span(lastSaturdaySpan.getBeginCalendar(), Time.cloneAndAdd(lastSaturdaySpan.getBeginCalendar(), 13, 172800.0f));
        } else {
            throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
        }
        return thisSpan;
    }

    public Span getOffset(Span span, float amount, Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        RepeaterWeekend weekend = new RepeaterWeekend();
        weekend.setStart(span.getBeginCalendar());
        Calendar start = Time.cloneAndAdd(weekend.nextSpan(pointer).getBeginCalendar(), 13, (amount - 1.0f) * (float)direction * 604800.0f);
        return new Span(start, Time.cloneAndAdd(start, 13, span.getWidth()));
    }

    public int getWidth() {
        return 172800;
    }

    public String toString() {
        return super.toString() + "-weekend";
    }
}

