/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.tags;

import er.chronic.Options;
import er.chronic.tags.Scalar;
import er.chronic.utils.Token;
import java.util.regex.Pattern;

public class ScalarMonth
extends Scalar {
    private static final Pattern MONTH_PATTERN = Pattern.compile("^\\d\\d?$");

    public ScalarMonth(Integer type) {
        super(type);
    }

    public String toString() {
        return super.toString() + "-month-" + this.getType();
    }

    public static ScalarMonth scan(Token token, Token postToken, Options options) {
        int scalarValue;
        if (MONTH_PATTERN.matcher(token.getWord()).matches() && (scalarValue = Integer.parseInt(token.getWord())) <= 12 && scalarValue >= 1 && (postToken == null || !Scalar.TIMES.contains(postToken.getWord()))) {
            return new ScalarMonth(scalarValue);
        }
        return null;
    }
}

