/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eoaccess._EOPrivate;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSRecursiveLock;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSDelegate;
import java.net.URL;
import java.util.Enumeration;

public class EOModelGroup {
    protected NSMutableDictionary _modelsByName = new NSMutableDictionary();
    protected NSMutableDictionary _subEntitiesCache;
    protected _NSDelegate _delegate = new _NSDelegate(Delegate.class);
    protected boolean _delegateRespondsTo_relationshipForRow;
    protected boolean _delegateRespondsTo_subEntityForEntity;
    protected boolean _delegateRespondsTo_failedToLookupClassNamed;
    protected boolean _delegateRespondsTo_classForObjectWithGlobalID;
    protected boolean _delegateRespondsTo_relationshipFailedToLookupDestinationWithName;
    public static final String ModelInvalidatedNotification = "EOModelInvalidatedNotification";
    public static final String ModelAddedNotification = "EOModelAddedNotification";
    private static final _NSDelegate _groupClassDelegate;
    private static volatile EOModelGroup _defaultGroup;
    private static volatile EOModelGroup _globalGroup;
    private static NSMutableDictionary _projectPathToModelGroup;

    public String toString() {
        if (this._modelsByName.count() == 0) {
            return "There are no models in the current EOModelGroup.";
        }
        NSArray models = this.models();
        int modelsCount = models.count();
        NSMutableArray modelDescs = new NSMutableArray(modelsCount);
        for (int i = 0; i < modelsCount; ++i) {
            EOModel model = (EOModel)models.objectAtIndex(i);
            modelDescs.addObject((Object)new NSArray(new Object[]{model.name() != null ? model.name() : "unnamed model", model.pathURL() != null ? model.pathURL().toString() : "no path"}));
        }
        return "<EOModelGroup " + modelDescs.toString() + ">";
    }

    public static void setClassDelegate(Object delegate) {
        _groupClassDelegate.setDelegate(delegate);
    }

    public static Object classDelegate() {
        return _groupClassDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOModelGroup globalModelGroup() {
        NSRecursiveLock nSRecursiveLock = EOModel._EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (_globalGroup == null) {
                _globalGroup = EOModelGroup.modelGroupForLoadedBundles();
            }
        }
        return _globalGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOModelGroup defaultGroup() {
        EOModelGroup group = null;
        if (_groupClassDelegate != null && _groupClassDelegate.respondsTo("defaultModelGroup")) {
            group = (EOModelGroup)_groupClassDelegate.perform("defaultModelGroup");
        }
        if (group == null) {
            NSRecursiveLock nSRecursiveLock = EOModel._EOGlobalModelLock;
            synchronized (nSRecursiveLock) {
                if (_defaultGroup == null) {
                    _defaultGroup = EOModelGroup.globalModelGroup();
                }
            }
            group = _defaultGroup;
        }
        return group;
    }

    public static void setDefaultGroup(EOModelGroup group) {
        _defaultGroup = group;
    }

    public NSArray models() {
        return this._modelsByName.allValues();
    }

    public NSArray modelNames() {
        return this._modelsByName.allKeys();
    }

    public EOModel modelNamed(String name) {
        return (EOModel)this._modelsByName.objectForKey((Object)name);
    }

    public void addModel(EOModel model) {
        Enumeration models = this._modelsByName.objectEnumerator();
        String name = model.name();
        if (this._modelsByName.objectForKey((Object)name) != null) {
            throw new IllegalStateException("The model '" + name + "' (path: " + model.pathURL() + ") cannot be added to model group " + this + " because it already contains a model with that name.");
        }
        NSMutableSet existingEntityNames = new NSMutableSet(128);
        NSSet newEntityNames = new NSSet(model.entityNames());
        while (models.hasMoreElements()) {
            EOModel existingModel = (EOModel)models.nextElement();
            existingEntityNames.addObjectsFromArray(existingModel.entityNames());
        }
        if (existingEntityNames.intersectsSet(newEntityNames)) {
            existingEntityNames.intersectSet(newEntityNames);
            throw new IllegalStateException("The model '" + name + "' (path: " + model.pathURL() + ") has an entity name conflict with the entities " + existingEntityNames + " already in the model group " + this);
        }
        model.setModelGroup(this);
        this._modelsByName.setObjectForKey((Object)model, (Object)model.name());
        NSNotificationCenter.defaultCenter().postNotification(ModelAddedNotification, (Object)model);
    }

    public EOModel addModelWithPath(String path) {
        return this.addModelWithPathURL(NSPathUtilities._URLWithPath((String)path));
    }

    public EOModel addModelWithPathURL(URL url) {
        EOModel model = null;
        model = new EOModel(url);
        this.addModel(model);
        return model;
    }

    public EOModel modelWithPath(String path) {
        return this.modelWithPathURL(NSPathUtilities._URLWithPath((String)path));
    }

    public EOModel modelWithPathURL(URL url) {
        String name = NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingPathExtension((String)url.toString()));
        EOModel model = (EOModel)this._modelsByName.objectForKey((Object)name);
        if (model != null && model.pathURL().equals(url)) {
            return model;
        }
        return null;
    }

    public EOEntity entityNamed(String name) {
        Enumeration models = this._modelsByName.objectEnumerator();
        while (models.hasMoreElements()) {
            EOModel model = (EOModel)models.nextElement();
            EOEntity entity = model.entityNamed(name);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public EOStoredProcedure storedProcedureNamed(String name) {
        Enumeration models = this._modelsByName.objectEnumerator();
        while (models.hasMoreElements()) {
            EOModel model = (EOModel)models.nextElement();
            EOStoredProcedure proc = model.storedProcedureNamed(name);
            if (proc == null) continue;
            return proc;
        }
        return null;
    }

    public EOFetchSpecification fetchSpecificationNamed(String fetchSpecName, String entityName) {
        return this.entityNamed(entityName).fetchSpecificationNamed(fetchSpecName);
    }

    public EOEntity entityForObject(EOEnterpriseObject object) {
        return this.entityNamed(object.entityName());
    }

    void unbindAllModels() {
        Enumeration models = this._modelsByName.objectEnumerator();
        while (models.hasMoreElements()) {
            EOModel model = (EOModel)models.nextElement();
            model.unbindFromExternalReferences();
        }
    }

    void unbindReferencesToModel(EOModel target) {
        Enumeration models = this._modelsByName.objectEnumerator();
        while (models.hasMoreElements()) {
            NSArray array;
            EOModel model = (EOModel)models.nextElement();
            if (model == target || (array = model.externalModelsCurrentlyReferenced()) == null || array.indexOfIdenticalObject((Object)target) == -1) continue;
            this.unbindAllModels();
            return;
        }
    }

    public void removeModel(EOModel model) {
        if (model != null) {
            this.unbindReferencesToModel(model);
            this._modelsByName.removeObjectForKey((Object)model.name());
            NSNotificationCenter.defaultCenter().postNotification(ModelInvalidatedNotification, (Object)model);
            EOClassDescription.invalidateClassDescriptionCache();
        }
    }

    public void loadAllModelObjects() {
        Enumeration models = this._modelsByName.objectEnumerator();
        while (models.hasMoreElements()) {
            EOModel model = (EOModel)models.nextElement();
            model.loadAllModelObjects();
        }
    }

    public Object delegate() {
        return this._delegate.delegate();
    }

    public void setDelegate(Object delegate) {
        this._delegate.setDelegate(delegate);
        this._delegateRespondsTo_relationshipForRow = delegate != null && this._delegate.respondsTo("relationshipForRow");
        this._delegateRespondsTo_subEntityForEntity = delegate != null && this._delegate.respondsTo("subEntityForEntity");
        this._delegateRespondsTo_failedToLookupClassNamed = delegate != null && this._delegate.respondsTo("failedToLookupClassNamed");
        this._delegateRespondsTo_classForObjectWithGlobalID = delegate != null && this._delegate.respondsTo("classForObjectWithGlobalID");
        this._delegateRespondsTo_relationshipFailedToLookupDestinationWithName = delegate != null && this._delegate.respondsTo("relationshipFailedToLookupDestinationWithName");
    }

    protected void _addSubEntitiesCache(NSDictionary cache) {
        Enumeration e = null;
        if (cache != null) {
            e = cache.keyEnumerator();
        }
        if (this._subEntitiesCache == null) {
            this._subEntitiesCache = new NSMutableDictionary();
        }
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            NSMutableArray current = (NSMutableArray)this._subEntitiesCache.objectForKey((Object)next);
            if (current != null) {
                current.addObjectsFromArray((NSArray)cache.objectForKey((Object)next));
                continue;
            }
            this._subEntitiesCache.setObjectForKey(cache.objectForKey((Object)next), (Object)next);
        }
    }

    protected void _registerChildForParent(String child, String parent) {
        NSMutableArray current;
        if (this._subEntitiesCache == null) {
            this._subEntitiesCache = new NSMutableDictionary();
        }
        if ((current = (NSMutableArray)this._subEntitiesCache.objectForKey((Object)parent)) == null) {
            this._subEntitiesCache.setObjectForKey((Object)new NSMutableArray((Object)child), (Object)parent);
        } else {
            current.addObject((Object)child);
        }
    }

    protected NSArray _childrenForEntityNamed(String entity) {
        return (NSArray)this._subEntitiesCache.objectForKey((Object)entity);
    }

    static NSMutableDictionary projectPathToModelGroup() {
        if (_projectPathToModelGroup == null) {
            _projectPathToModelGroup = new NSMutableDictionary();
        }
        return _projectPathToModelGroup;
    }

    static EOModelGroup modelGroupForLoadedBundles() {
        EOModelGroup group = new EOModelGroup();
        NSArray frameworkBundles = NSBundle.frameworkBundles();
        int imax = frameworkBundles.count() + 1;
        NSMutableArray bundles = new NSMutableArray(imax);
        bundles.addObject((Object)NSBundle.mainBundle());
        bundles.addObjectsFromArray(frameworkBundles);
        for (int i = 0; i < imax; ++i) {
            NSBundle bundle = (NSBundle)bundles.objectAtIndex(i);
            NSArray paths = bundle.resourcePathsForDirectories("eomodeld", null);
            int jmax = paths.count();
            for (int j = 0; j < jmax; ++j) {
                String path = (String)paths.objectAtIndex(j);
                String modelName = NSPathUtilities.stringByDeletingPathExtension((String)NSPathUtilities.lastPathComponent((String)path));
                EOModel existingModel = group.modelNamed(modelName);
                if (existingModel == null) {
                    group.addModelWithPathURL(bundle.pathURLForResourcePath(path));
                    continue;
                }
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)32768L)) continue;
                NSLog.debug.appendln((Object)("Ignoring model at path \"" + path + "\" because the model group " + group + " already contains the model from the path \"" + existingModel.pathURL() + "\""));
            }
        }
        return group;
    }

    static void flushModelGroupCache() {
        EOModelGroup.projectPathToModelGroup().removeAllObjects();
    }

    void addModelsFromDirectory(String directoryPath) {
        Enumeration directoryEnumerator = NSPathUtilities._directoryContentsAtPath((String)directoryPath).objectEnumerator();
        while (directoryEnumerator.hasMoreElements()) {
            String nextPath = (String)directoryEnumerator.nextElement();
            if (!NSPathUtilities.pathExtension((String)nextPath).equals("eomodeld")) continue;
            String completePath = NSPathUtilities.stringByStandardizingPath((String)NSPathUtilities.stringByAppendingPathComponent((String)directoryPath, (String)nextPath));
            String modelName = NSPathUtilities.stringByDeletingPathExtension((String)nextPath);
            if (this.modelNamed(modelName) != null) continue;
            EOModel model = new EOModel(completePath);
            this.addModel(model);
        }
    }

    public NSArray entitiesWithSharedObjects() {
        Enumeration models = this._modelsByName.objectEnumerator();
        NSMutableArray entities = new NSMutableArray();
        while (models.hasMoreElements()) {
            EOModel model = (EOModel)models.nextElement();
            NSArray array = model.entitiesWithSharedObjects();
            entities.addObjectsFromArray(array);
        }
        return entities;
    }

    public static void setModelGroupForObjectStoreCoordinator(EOObjectStoreCoordinator objectCoord, EOModelGroup group) {
        NSDictionary info = objectCoord.userInfo();
        NSMutableDictionary dict = info == null ? new NSMutableDictionary() : new NSMutableDictionary(info);
        dict.setObjectForKey((Object)group, (Object)"EOModelGroup");
        objectCoord.setUserInfo((NSDictionary)dict);
    }

    public static EOModelGroup modelGroupForObjectStoreCoordinator(EOObjectStoreCoordinator objectCoord) {
        EOModelGroup modelGroup;
        NSDictionary dict = objectCoord.userInfo();
        if (dict == null || (modelGroup = (EOModelGroup)dict.objectForKey((Object)"EOModelGroup")) == null) {
            modelGroup = EOModelGroup.defaultGroup();
            EOModelGroup.setModelGroupForObjectStoreCoordinator(objectCoord, modelGroup);
        }
        return modelGroup;
    }

    static {
        Class clazz = _EOPrivate.class;
        _groupClassDelegate = new _NSDelegate(ClassDelegate.class);
        _defaultGroup = null;
        _globalGroup = null;
        _projectPathToModelGroup = null;
    }

    public static interface ClassDelegate {
        public EOModelGroup defaultModelGroup();
    }

    public static interface Delegate {
        public EORelationship relationshipForRow(EOEntity var1, NSDictionary var2, EORelationship var3);

        public EOEntity subEntityForEntity(EOEntity var1, NSDictionary var2);

        public Class failedToLookupClassNamed(EOEntity var1, String var2);

        public Class classForObjectWithGlobalID(EOEntity var1, EOGlobalID var2);

        public EOEntity relationshipFailedToLookupDestinationWithName(EORelationship var1, String var2);
    }
}

