/*
 * Decompiled with CFR 0.152.
 */
package er.corebusinesslogic;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOPageNotFoundException;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOKeyValueCodingAdditions;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import er.corebusinesslogic.ERCMailMessage;
import er.corebusinesslogic.ERCMessageAttachment;
import er.extensions.appserver.ERXApplication;
import er.extensions.foundation.ERXProperties;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERCMailDelivery {
    public static final Logger log = Logger.getLogger(ERCMailDelivery.class);
    protected static ERCMailDelivery _sharedInstance;

    public static ERCMailDelivery sharedInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new ERCMailDelivery();
        }
        return _sharedInstance;
    }

    public static String commaSeparatedListFromArray(NSArray a) {
        StringBuffer result = new StringBuffer();
        if (a != null) {
            Enumeration e = a.objectEnumerator();
            while (e.hasMoreElements()) {
                String address = (String)e.nextElement();
                if (address.indexOf("\"") != -1) {
                    address = address.replace('\"', '\'');
                }
                if (address.indexOf(",") != -1) {
                    address = address.replace(',', ' ');
                }
                result.append(address);
                if (!e.hasMoreElements()) continue;
                result.append(',');
                result.append(' ');
            }
        }
        return result.toString();
    }

    public static boolean usesMail() {
        return ERXProperties.booleanForKey((String)"er.corebusinesslogic.ERCUseMailFacility");
    }

    public ERCMailMessage composeEmail(String from, NSArray to, NSArray cc, NSArray bcc, String title, String message, EOEditingContext ec) {
        ERCMailMessage mailMessage = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending email title \"" + title + "\" from \"" + from + "\" to \"" + to + "\" cc \"" + cc + "\" bcc \"" + bcc + "\""));
            log.debug((Object)("Email message: " + message));
        }
        if (ERCMailDelivery.usesMail()) {
            mailMessage = (ERCMailMessage)ERCMailMessage.mailMessageClazz().createAndInsertObject(ec);
        } else {
            throw new RuntimeException("The application doesn't use the ERCUseMailFacility.You can either set er.corebusinesslogic.ERCUseMailFacility in your properties or better check for that property before trying to compose the email");
        }
        String safeTitle = title != null ? (title.length() > 200 ? title.substring(0, 198) : title) : null;
        mailMessage.setTitle(safeTitle);
        mailMessage.setFromAddress(from);
        mailMessage.setToAddresses(ERCMailDelivery.commaSeparatedListFromArray(to));
        mailMessage.setCcAddresses(ERCMailDelivery.commaSeparatedListFromArray(cc));
        mailMessage.setBccAddresses(ERCMailDelivery.commaSeparatedListFromArray(bcc));
        mailMessage.setText(message);
        return mailMessage;
    }

    public ERCMailMessage composeEmailWithAttachments(String from, NSArray to, NSArray cc, NSArray bcc, String title, String message, NSArray filePaths, EOEditingContext ec) {
        ERCMailMessage mailMessage = this.composeEmail(from, to, cc, bcc, title, message, ec);
        Enumeration filePathEnumerator = filePaths.objectEnumerator();
        while (filePathEnumerator.hasMoreElements()) {
            String filePath = (String)filePathEnumerator.nextElement();
            ERCMessageAttachment attachment = (ERCMessageAttachment)ERCMessageAttachment.messageAttachmentClazz().createAndInsertObject(ec);
            attachment.setFilePath(filePath);
            mailMessage.addToBothSidesOfAttachments(attachment);
        }
        return mailMessage;
    }

    public ERCMailMessage composeComponentEmail(String from, NSArray to, NSArray cc, NSArray bcc, String title, WOComponent component, EOEditingContext ec) {
        String message = null;
        if (component == null) {
            throw new IllegalStateException("Attempting to send a component email with a null component! From: " + title + " title: " + title);
        }
        WOContext context = component.context();
        context._generateCompleteURLs();
        message = component.generateResponse().contentString();
        return this.composeEmail(from, to, cc, bcc, title, message, ec);
    }

    public ERCMailMessage composeComponentEmail(String from, NSArray to, NSArray cc, NSArray bcc, String title, String componentName, NSDictionary bindings, EOEditingContext ec) {
        WOComponent component = ERXApplication.instantiatePage((String)componentName);
        if (component == null) {
            log.warn((Object)("Created null component for name \"" + componentName + "\""));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Created component with name \"" + componentName + "\" class name \"" + component.getClass().getName() + "\""));
        }
        if (bindings != null && bindings.count() > 0) {
            EOKeyValueCodingAdditions.DefaultImplementation.takeValuesFromDictionary((Object)component, (NSDictionary)bindings);
        }
        return this.composeComponentEmail(from, to, cc, bcc, title, component, ec);
    }

    public ERCMailMessage composeComponentEmail(String from, NSArray to, NSArray cc, NSArray bcc, String title, String componentName, String plainTextComponentName, NSDictionary bindings, EOEditingContext ec) {
        ERCMailMessage result = this.composeComponentEmail(from, to, cc, bcc, title, componentName, bindings, ec);
        WOComponent plainTextComponent = ERXApplication.instantiatePage((String)plainTextComponentName);
        try {
            plainTextComponent = ERXApplication.instantiatePage((String)plainTextComponentName);
        }
        catch (WOPageNotFoundException exc) {
            // empty catch block
        }
        if (plainTextComponent != null) {
            EOKeyValueCodingAdditions.DefaultImplementation.takeValuesFromDictionary((Object)plainTextComponent, (NSDictionary)bindings);
            WOContext context = plainTextComponent.context();
            context._generateCompleteURLs();
            result.setPlainText(plainTextComponent.generateResponse().contentString());
        }
        return result;
    }

    public ERCMailMessage composeComponentEmail(String from, NSArray to, NSArray cc, NSArray bcc, String title, WOComponent component, WOComponent plainTextComponent, EOEditingContext ec) {
        ERCMailMessage result = this.composeComponentEmail(from, to, cc, bcc, title, component, ec);
        if (plainTextComponent != null) {
            WOContext context = plainTextComponent.context();
            context._generateCompleteURLs();
            result.setPlainText(plainTextComponent.generateResponse().contentString());
        }
        return result;
    }
}

