/*
 * Decompiled with CFR 0.152.
 */
package er.corebusinesslogic;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import er.corebusinesslogic.ERCLogEntry;
import er.corebusinesslogic.ERCLogEntryInterface;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRetainer;
import er.extensions.foundation.ERXSelectorUtilities;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public abstract class ERCStampedEnterpriseObject
extends ERXGenericRecord {
    public static final Logger log = Logger.getLogger(ERCStampedEnterpriseObject.class);
    public static String[] TimestampAttributeKeys = new String[]{"created", "lastModified"};
    private static final Map<EOEditingContext, NSTimestamp> _datesPerEC = Collections.synchronizedMap(new WeakHashMap());
    public EOEnterpriseObject insertionLogEntry = null;
    private static Boolean _touchReadOnlyEntities;

    protected static void initialize() {
        NSNotificationCenter center = NSNotificationCenter.defaultCenter();
        NSSelector sel = ERXSelectorUtilities.notificationSelector((String)"updateTimestampForEditingContext");
        Observer observer = new Observer();
        ERXRetainer.retain((Object)observer);
        center.addObserver((Object)observer, sel, "ObjectsWillChangeInEditingContext", null);
    }

    public void init(EOEditingContext ec) {
        super.init(ec);
        if (this instanceof ERCLogEntryInterface) {
            ERCLogEntryInterface lei = (ERCLogEntryInterface)((Object)this);
            String relationshipName = lei.relationshipNameForLogEntry();
            EOEnterpriseObject logType = lei.logEntryType();
            if (relationshipName != null && logType != null) {
                this.insertionLogEntry = ERCLogEntry.clazz.createLogEntryLinkedToEO(logType, null, (EOEnterpriseObject)this, relationshipName);
            }
        }
        NSTimestamp t = new NSTimestamp();
        this.setCreated(t);
        this.setLastModified(t);
    }

    public void willInsert() {
        super.willInsert();
        this.touch();
        this.setCreated(this.lastModified());
    }

    public void willUpdate() {
        super.willUpdate();
        this.touch();
    }

    public void willDelete() {
        super.willDelete();
        this.touch();
    }

    protected static boolean touchReadOnlyEntities() {
        if (_touchReadOnlyEntities == null) {
            _touchReadOnlyEntities = ERXProperties.booleanForKeyWithDefault((String)"er.corebusinesslogic.ERCStampedEnterpriseObject.touchReadOnlyEntities", (boolean)false);
        }
        return _touchReadOnlyEntities;
    }

    private void touch() {
        NSTimestamp date;
        EOEntity entity;
        if (!ERCStampedEnterpriseObject.touchReadOnlyEntities() && (entity = this.entity()) != null && entity.isReadOnly()) {
            return;
        }
        EOEditingContext editingContext = this.editingContext();
        if (editingContext != null) {
            date = _datesPerEC.get(editingContext);
        } else {
            log.error((Object)("Null editingContext in touch() for: " + (Object)((Object)this)));
            date = null;
        }
        if (date == null) {
            log.error((Object)"Null modification date found in touch() call - EC delegate is probably missing");
            date = new NSTimestamp();
        }
        this.setLastModified(date);
    }

    public void addObjectToBothSidesOfLogEntryRelationshipWithKey(EOEnterpriseObject object, String key) {
        if (this.insertionLogEntry != null && this.editingContext().insertedObjects().containsObject((Object)this)) {
            this.insertionLogEntry.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)object, key);
        }
    }

    public NSTimestamp created() {
        return (NSTimestamp)this.storedValueForKey("created");
    }

    public void setCreated(NSTimestamp value) {
        this.takeStoredValueForKey(value, "created");
    }

    public NSTimestamp lastModified() {
        return (NSTimestamp)this.storedValueForKey("lastModified");
    }

    public void setLastModified(NSTimestamp value) {
        this.takeStoredValueForKey(value, "lastModified");
    }

    public static class Observer {
        public void updateTimestampForEditingContext(NSNotification n) {
            NSTimestamp now = new NSTimestamp();
            EOEditingContext editingContext = (EOEditingContext)n.object();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Timestamp for " + editingContext + ": " + now));
            }
            _datesPerEC.put(editingContext, now);
        }
    }

    public static abstract class ERCStampedEnterpriseObjectClazz
    extends ERXGenericRecord.ERXGenericRecordClazz {
    }

    public static interface Keys {
        public static final String CREATED = "created";
        public static final String LAST_MODIFIED = "lastModified";
    }
}

