/*
 * Decompiled with CFR 0.152.
 */
package er.corebusinesslogic;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import er.corebusinesslogic.ERCoreBusinessLogic;
import er.corebusinesslogic.ERCoreUserInterface;
import er.extensions.ERXExtensions;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRetainer;
import er.extensions.foundation.ERXValueUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERCoreUserPreferences
implements NSKeyValueCoding {
    public static final Logger log = Logger.getLogger(ERCoreUserPreferences.class);
    private static final String VALUE = "_V";
    public static final String PreferenceDidChangeNotification = "PreferenceChangedNotification";
    private static ERCoreUserPreferences _userPreferences;

    public static ERCoreUserPreferences userPreferences() {
        if (_userPreferences == null) {
            _userPreferences = new ERCoreUserPreferences();
        }
        return _userPreferences;
    }

    public void registerHandlers() {
        log.debug((Object)"Registering preference handlers");
        _UserPreferenceHandler handler = null;
        String handlerClassName = ERXProperties.stringForKey((String)"er.corebusinesslogic.ERCoreUserPreferences.handlerClassName");
        if (handlerClassName != null) {
            try {
                handler = (_UserPreferenceHandler)Class.forName(handlerClassName).newInstance();
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        if (handler == null) {
            handler = new _UserPreferenceHandler();
        }
        ERXRetainer.retain(handler);
    }

    protected NSArray preferences(EOEditingContext ec) {
        ERCoreUserInterface user = (ERCoreUserInterface)ERCoreBusinessLogic.actor(ec);
        return user != null ? user.preferences() : NSArray.EmptyArray;
    }

    protected EOEnterpriseObject preferenceRecordForKey(String key, EOEditingContext ec) {
        EOEnterpriseObject result = null;
        if (key != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preference value for Key = " + key));
            }
            Enumeration e = this.preferences(ec).objectEnumerator();
            while (e.hasMoreElements()) {
                EOEnterpriseObject pref = (EOEnterpriseObject)e.nextElement();
                String prefKey = (String)pref.valueForKey("key");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("prefKey \"" + prefKey + "\""));
                }
                if (prefKey == null || !prefKey.equals(key)) continue;
                result = pref;
                break;
            }
        }
        return result;
    }

    protected String encodedValue(Object value) {
        EOKeyValueArchiver archiver = new EOKeyValueArchiver();
        archiver.encodeObject(value, VALUE);
        String encodedValue = NSPropertyListSerialization.stringFromPropertyList((Object)archiver.dictionary());
        return encodedValue;
    }

    protected Object decodedValue(String encodedValue) {
        NSDictionary d = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)encodedValue);
        EOKeyValueUnarchiver u = new EOKeyValueUnarchiver(d);
        return u.decodeObjectForKey(VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object valueForKey(String key) {
        Object result = null;
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            String encodedValue;
            EOEnterpriseObject pref = this.preferenceRecordForKey(key, ec);
            if (pref != null && (encodedValue = (String)pref.valueForKey("value")) != null) {
                result = this.decodedValue(encodedValue);
            }
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error while getting preference " + key + ": " + ex));
        }
        finally {
            ec.unlock();
        }
        ec.dispose();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prefs vfk " + key + " = " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeValueForKey(Object value, String key) {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            EOEnterpriseObject pref = this.preferenceRecordForKey(key, ec);
            ERCoreUserInterface u = (ERCoreUserInterface)ERCoreBusinessLogic.actor(ec);
            if (pref != null) {
                if (value != null) {
                    String encodedValue = this.encodedValue(value);
                    if (ERXExtensions.safeDifferent((Object)encodedValue, (Object)pref.valueForKey("value"))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Updating preference " + u + ": " + key + "=" + encodedValue));
                        }
                        pref.takeValueForKey((Object)encodedValue, "value");
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing preference " + u + ": " + key));
                    }
                    ec.deleteObject(pref);
                }
            } else if (value != null) {
                pref = ERXEOControlUtilities.createAndInsertObject((EOEditingContext)ec, (String)"ERCPreference");
                u.newPreference(pref);
                pref.takeValueForKey(ERXEOControlUtilities.primaryKeyObjectForObject((EOEnterpriseObject)((EOEnterpriseObject)u)), "userID");
                pref.takeValueForKey((Object)key, "key");
                pref.takeValueForKey((Object)this.encodedValue(value), "value");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating preference " + u + ": " + key + " - " + value + " -- " + this.encodedValue(value)));
                }
            }
            if (ec.hasChanges()) {
                ec.saveChanges();
            }
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error while setting preference " + key + ": " + ex));
        }
        finally {
            ec.unlock();
        }
        ec.dispose();
        NSNotificationCenter.defaultCenter().postNotification(PreferenceDidChangeNotification, (Object)new NSDictionary(value, (Object)key));
    }

    public boolean booleanValueForKey(String key) {
        return this.booleanValueForKeyWithDefault(key, false);
    }

    public boolean booleanValueForKeyWithDefault(String key, boolean def) {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.valueForKey(key), (boolean)def);
    }

    public static class _UserPreferenceHandler {
        public _UserPreferenceHandler() {
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("handleBatchSizeChange", ERXConstant.NotificationClassArray), "BatchSizeChanged", null);
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("handleSortOrderingChange", ERXConstant.NotificationClassArray), "SortOrderingChanged", null);
        }

        public void handleBatchSizeChange(NSNotification n) {
            this.handleChange("batchSize", n);
        }

        public void handleSortOrderingChange(NSNotification n) {
            this.handleChange("sortOrdering", n);
        }

        public void handleChange(String prefName, NSNotification n) {
            NSKeyValueCoding context;
            if (ERCoreBusinessLogic.actor() != null && (context = (NSKeyValueCoding)n.userInfo().objectForKey((Object)"d2wContext")) != null && context.valueForKey("pageConfiguration") != null) {
                ERCoreUserPreferences.userPreferences().takeValueForKey(n.object(), prefName + "." + (String)context.valueForKey("pageConfiguration"));
            }
        }
    }
}

