/*
 * Decompiled with CFR 0.152.
 */
package er.javamail.mailer;

import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSTimestamp;
import er.corebusinesslogic.ERCMailMessage;
import er.corebusinesslogic.ERCMailState;
import er.corebusinesslogic.ERCMessageAttachment;
import er.corebusinesslogic.ERCoreBusinessLogic;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXFetchSpecificationBatchIterator;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXUtilities;
import er.javamail.ERMailAttachment;
import er.javamail.ERMailDelivery;
import er.javamail.ERMailDeliveryHTML;
import er.javamail.ERMailDeliveryPlainText;
import er.javamail.ERMailFileAttachment;
import java.io.File;
import java.util.Enumeration;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

public class ERMailer {
    public static final Logger log = Logger.getLogger(ERMailer.class);
    protected static ERMailer instance;
    protected static Factory factory;
    private static final boolean _warnOnGeneralAdaptorExceptionLockingMessage;
    protected String messageTitlePrefix;

    public static Factory factory() {
        if (factory == null) {
            factory = new DefaultFactory();
        }
        return factory;
    }

    public static void setFactory(Factory value) {
        factory = value;
    }

    public static ERMailer newMailer() {
        return ERMailer.factory().newMailer();
    }

    protected static boolean shouldDeleteSentMail() {
        return ERXProperties.booleanForKeyWithDefault((String)"er.javamail.mailer.ERMailer.ShouldDeleteSentMail", (boolean)true);
    }

    public static ERMailer instance() {
        if (instance == null) {
            instance = ERMailer.newMailer();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOutgoingMail() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting outgoing mail processing.");
        }
        ERXFetchSpecificationBatchIterator iterator = ERCMailMessage.mailMessageClazz().batchIteratorForUnsentMessages();
        EOEditingContext ec = ERXEC.newEditingContext();
        iterator.setEditingContext(ec);
        ec.lock();
        try {
            iterator.batchCount();
        }
        finally {
            ec.unlock();
        }
        ec.dispose();
        while (iterator.hasNextBatch()) {
            EOEditingContext temp = ERXEC.newEditingContext();
            temp.lock();
            try {
                iterator.setEditingContext(temp);
                this.sendMailMessages(iterator.nextBatch());
            }
            finally {
                temp.unlock();
            }
            temp.dispose();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Done outgoing mail processing.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMailMessages(NSArray mailMessages) {
        if (mailMessages.count() > 0) {
            log.info((Object)("Sending " + mailMessages.count() + " mail message(s)."));
            Enumeration messageEnumerator = mailMessages.objectEnumerator();
            while (messageEnumerator.hasMoreElements()) {
                ERCMailMessage mailMessage = (ERCMailMessage)((Object)messageEnumerator.nextElement());
                if (!mailMessage.isReadyToSendState()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending mail message: " + (Object)((Object)mailMessage)));
                }
                try {
                    ERMailDelivery delivery = this.createMailDeliveryForMailMessage(mailMessage);
                    if (delivery != null) {
                        mailMessage.setState(ERCMailState.PROCESSING_STATE);
                        mailMessage.editingContext().saveChanges();
                        delivery.sendMail(true);
                        mailMessage.setState(ERCMailState.SENT_STATE);
                        mailMessage.setDateSent(new NSTimestamp());
                        if (!ERMailer.shouldDeleteSentMail()) continue;
                        if (mailMessage.shouldArchiveSentMailAsBoolean()) {
                            mailMessage.archive();
                        }
                        if (mailMessage.hasAttachments()) continue;
                        mailMessage.editingContext().deleteObject((EOEnterpriseObject)mailMessage);
                        continue;
                    }
                    log.warn((Object)("Unable to create mail delivery for mail message: " + (Object)((Object)mailMessage)));
                }
                catch (EOGeneralAdaptorException ge) {
                    if (_warnOnGeneralAdaptorExceptionLockingMessage) {
                        log.warn((Object)"Caught general adaptor exception, reverting context. Might be running multiple mailers", (Throwable)ge);
                    }
                    mailMessage.editingContext().revert();
                }
                catch (Throwable e) {
                    if (e instanceof NSForwardException) {
                        e = ((NSForwardException)e).originalException();
                    }
                    log.warn((Object)("Caught exception when sending mail: " + ERXUtilities.stackTrace((Throwable)e)));
                    log.warn((Object)("Message trying to send: " + (Object)((Object)mailMessage) + " pk: " + mailMessage.primaryKey()));
                    mailMessage.setState(ERCMailState.EXCEPTION_STATE);
                    mailMessage.setExceptionReason(e.getMessage());
                    ERCoreBusinessLogic.sharedInstance().reportException(e, new NSDictionary((Object)mailMessage.snapshot(), (Object)"Mail Message Snapshot"));
                }
                finally {
                    if (!mailMessage.editingContext().hasChanges()) continue;
                    try {
                        mailMessage.editingContext().saveChanges();
                    }
                    catch (RuntimeException runtime) {
                        log.error((Object)"RuntimeException during save changes!", (Throwable)runtime);
                        throw runtime;
                    }
                }
            }
        }
    }

    public ERMailDelivery createMailDeliveryForMailMessage(ERCMailMessage message) throws MessagingException {
        ERMailDeliveryHTML mail = null;
        if (message.text() != null) {
            mail = ERMailDeliveryHTML.newMailDelivery();
            mail.setHTMLContent(message.text());
            if (message.plainText() != null) {
                mail.setHiddenPlainTextContent(message.plainText());
            }
        } else {
            mail = new ERMailDeliveryPlainText();
            ((ERMailDeliveryPlainText)mail).setTextContent(message.plainText());
        }
        mail.setFromAddress(message.fromAddress());
        if (message.replyToAddress() != null) {
            mail.setReplyToAddress(message.replyToAddress());
        }
        mail.setToAddresses(message.toAddressesAsArray());
        if (message.ccAddressesAsArray().count() > 0) {
            mail.setCCAddresses(message.ccAddressesAsArray());
        }
        if (message.bccAddressesAsArray().count() > 0) {
            mail.setBCCAddresses(message.bccAddressesAsArray());
        }
        if (message.xMailer() != null) {
            mail.setXMailerHeader(message.xMailer());
        }
        mail.setSubject(this.messageTitlePrefix() + message.title());
        if (message.hasAttachments()) {
            Enumeration attachmentEnumerator = message.attachments().objectEnumerator();
            while (attachmentEnumerator.hasMoreElements()) {
                File fileAttachment = ((ERCMessageAttachment)((Object)attachmentEnumerator.nextElement())).file();
                mail.addAttachment((ERMailAttachment)new ERMailFileAttachment(fileAttachment.getName(), null, fileAttachment));
            }
        }
        return mail;
    }

    public String messageTitlePrefix() {
        if (this.messageTitlePrefix == null) {
            this.messageTitlePrefix = ERCoreBusinessLogic.staticStoredValueForKey("ERMailTitleEnvironmentPrefix");
            if (this.messageTitlePrefix == null) {
                this.messageTitlePrefix = "";
            }
        }
        return this.messageTitlePrefix;
    }

    static {
        _warnOnGeneralAdaptorExceptionLockingMessage = ERXProperties.booleanForKeyWithDefault((String)"er.javamail.mailer.ERMailer.WarnOnGeneralAdaptorExceptionLockingMessage", (boolean)true);
    }

    public static class DefaultFactory
    implements Factory {
        public ERMailer newMailer() {
            return new ERMailer();
        }
    }

    public static interface Factory {
        public ERMailer newMailer();
    }
}

