/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import net.spy.util.RingBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeExecutorException
extends ExecutionException {
    private static final int MAX_EXCEPTIONS = 10;
    private Collection<ExecutionException> exceptions = new RingBuffer<ExecutionException>(10);

    public CompositeExecutorException(ExecutionException e) {
        super("Too many failures");
        this.exceptions.add(e);
    }

    public CompositeExecutorException(Collection<? extends ExecutionException> e) {
        super("Too many failures");
        this.exceptions.addAll(e);
    }

    void addException(ExecutionException e) {
        this.exceptions.add(e);
    }

    public Collection<ExecutionException> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void printStackTrace(PrintStream p) {
        super.printStackTrace(p);
        for (ExecutionException e : this.exceptions) {
            try {
                p.write("Also caused by: ".getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace(p);
        }
    }

    @Override
    public void printStackTrace(PrintWriter p) {
        super.printStackTrace(p);
        for (ExecutionException e : this.exceptions) {
            p.print("Also caused by: ");
            e.printStackTrace(p);
        }
    }
}

