/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.SpyObject;
import net.spy.concurrent.CompositeExecutorException;
import net.spy.concurrent.RetryableCallable;
import net.spy.concurrent.RetryableExecutorCompletionService;
import net.spy.concurrent.SynchronizationObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rescheduler
extends SpyObject
implements ScheduledExecutorService {
    private ScheduledExecutorService executor;

    public Rescheduler(ScheduledExecutorService x) {
        this.executor = x;
    }

    void examineCompletion(FutureFuture future) {
        block9: {
            try {
                boolean set = false;
                Object result = null;
                while (!set) {
                    try {
                        result = future.getCurrentFuture().get();
                        set = true;
                    }
                    catch (InterruptedException e) {
                        this.getLogger().info((Object)"Interrupted.  Retrying", e);
                    }
                }
                future.setResult(result);
                future.callable.onComplete(true, result);
            }
            catch (CancellationException e) {
                future.setCancelled();
            }
            catch (ExecutionException e) {
                assert (future != null) : "Lost the future";
                future.addException(e);
                long nextTime = future.callable.getRetryDelay();
                if (future.isCancelled()) break block9;
                if (nextTime >= 0L) {
                    future.callable.onExecutionException(null);
                    future.clearCurrentFuture();
                    this.scheduleFutureFuture(future, nextTime, TimeUnit.MILLISECONDS);
                }
                future.callable.onComplete(false, future.exceptions);
                assert (future.exceptions != null) : "Exceptions is null";
                future.setResult(future.exceptions);
            }
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable r, long delay, TimeUnit unit) {
        return this.executor.schedule(r, delay, unit);
    }

    private <T> void scheduleFutureFuture(final FutureFuture<T> ff, long delay, TimeUnit unit) {
        FutureTask ft = new FutureTask<T>(ff.callable){

            @Override
            protected void done() {
                Rescheduler.this.examineCompletion(ff);
            }
        };
        this.executor.schedule(ft, delay, unit);
        ff.setCurrentFuture(ft);
    }

    public <T> ScheduledFuture<T> schedule(Callable<T> c, long delay, TimeUnit unit) {
        ScheduledFuture<T> rv = null;
        if (c instanceof RetryableCallable) {
            RetryableCallable rc = (RetryableCallable)c;
            ScheduledFutureFuture ff = new ScheduledFutureFuture(rc, TimeUnit.MILLISECONDS.convert(delay, unit));
            this.scheduleFutureFuture(ff, delay, unit);
            rv = ff;
        } else {
            rv = this.executor.schedule(c, delay, unit);
        }
        return rv;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable r, long arg1, long arg2, TimeUnit arg3) {
        return this.executor.scheduleAtFixedRate(r, arg1, arg2, arg3);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable r, long arg1, long arg2, TimeUnit arg3) {
        return this.executor.scheduleWithFixedDelay(r, arg1, arg2, arg3);
    }

    @Override
    public boolean awaitTermination(long arg0, TimeUnit arg1) throws InterruptedException {
        return this.executor.awaitTermination(arg0, arg1);
    }

    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> callables) throws InterruptedException {
        ArrayList<Future<T>> rv = new ArrayList<Future<T>>(callables.size());
        RetryableExecutorCompletionService<T> ecs = new RetryableExecutorCompletionService<T>(this);
        for (Callable<T> c : callables) {
            rv.add(ecs.submit(c));
        }
        for (int i = 0; i < callables.size(); ++i) {
            ecs.take();
        }
        return rv;
    }

    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> callables, long timeout, TimeUnit unit) throws InterruptedException {
        long end = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, unit);
        ArrayList<Future<T>> rv = new ArrayList<Future<T>>(callables.size());
        RetryableExecutorCompletionService<T> ecs = new RetryableExecutorCompletionService<T>(this);
        for (Callable<T> c : callables) {
            rv.add(ecs.submit(c));
        }
        for (int i = 0; i < callables.size(); ++i) {
            long now = System.currentTimeMillis();
            long towait = end - now;
            if (towait <= 0L) continue;
            ecs.poll(towait, TimeUnit.MILLISECONDS);
        }
        return rv;
    }

    public <T> T invokeAny(Collection<Callable<T>> callables) throws InterruptedException, ExecutionException {
        ArrayList futures = new ArrayList(callables.size());
        RetryableExecutorCompletionService<T> ecs = new RetryableExecutorCompletionService<T>(this);
        for (Callable<T> c : callables) {
            futures.add(ecs.submit(c));
        }
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
        boolean foundResult = false;
        T rv = null;
        while (!foundResult && !futures.isEmpty()) {
            Future f = ecs.take();
            futures.remove(f);
            try {
                rv = (T)f.get();
                foundResult = true;
            }
            catch (ExecutionException executionException) {
                exceptions.add(executionException);
            }
        }
        if (!foundResult) {
            throw new CompositeExecutorException(exceptions);
        }
        for (Future future : futures) {
            future.cancel(true);
        }
        return rv;
    }

    public <T> T invokeAny(Collection<Callable<T>> callables, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long end = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, unit);
        ArrayList futures = new ArrayList(callables.size());
        RetryableExecutorCompletionService<T> ecs = new RetryableExecutorCompletionService<T>(this);
        for (Callable<T> c : callables) {
            futures.add(ecs.submit(c));
        }
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
        boolean foundResult = false;
        T rv = null;
        while (!foundResult && !futures.isEmpty()) {
            long now = System.currentTimeMillis();
            long towait = end - now;
            Future f = ecs.poll(towait, TimeUnit.MILLISECONDS);
            if (f == null) {
                throw new TimeoutException("Timed out waiting " + towait + "ms of " + timeout + unit.name());
            }
            futures.remove(f);
            assert (f.isDone()) : "Future is not done";
            try {
                rv = (T)f.get();
                foundResult = true;
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
        }
        if (!foundResult) {
            throw new CompositeExecutorException(exceptions);
        }
        for (Future future : futures) {
            future.cancel(true);
        }
        return rv;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> c) {
        Future<T> rv = null;
        if (c instanceof RetryableCallable) {
            RetryableCallable rc = (RetryableCallable)c;
            final FutureFuture ff = new FutureFuture(rc);
            FutureTask ft = new FutureTask<T>(rc){

                @Override
                protected void done() {
                    Rescheduler.this.examineCompletion(ff);
                }
            };
            this.executor.submit(ft);
            ff.setCurrentFuture(ft);
            rv = ff;
        } else {
            rv = this.executor.submit(c);
        }
        return rv;
    }

    @Override
    public Future<?> submit(Runnable arg0) {
        return this.executor.submit(arg0);
    }

    @Override
    public <T> Future<T> submit(Runnable arg0, T arg1) {
        return this.executor.submit(arg0, arg1);
    }

    @Override
    public void execute(Runnable arg0) {
        this.executor.execute(arg0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ScheduledFutureFuture<T>
    extends FutureFuture<T>
    implements ScheduledFuture<T> {
        private long when = 0L;

        public ScheduledFutureFuture(RetryableCallable<T> c, long delay) {
            super(c);
            this.when = System.currentTimeMillis() + delay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return TimeUnit.MILLISECONDS.convert(this.when - System.currentTimeMillis(), unit);
        }

        @Override
        public int compareTo(Delayed d) {
            return new Long(this.getDelay(TimeUnit.MILLISECONDS)).compareTo(d.getDelay(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FutureFuture<T>
    implements Future<T> {
        RetryableCallable<T> callable = null;
        Object defaultObj = new Object();
        Object cancelObj = new Object();
        CompositeExecutorException exceptions = null;
        private SynchronizationObject<Future<T>> futureSync = new SynchronizationObject<Object>(null);
        private SynchronizationObject<Object> sync = new SynchronizationObject<Object>(this.defaultObj);

        public FutureFuture(RetryableCallable<T> c) {
            this.callable = c;
        }

        public void addException(ExecutionException e) {
            if (this.exceptions == null) {
                this.exceptions = new CompositeExecutorException(e);
            } else {
                this.exceptions.addException(e);
            }
        }

        public void setResult(Object t) {
            this.sync.set(t);
        }

        public Future<T> getCurrentFuture() throws InterruptedException {
            try {
                this.futureSync.waitUntilNotNull(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
            Future<T> f = this.futureSync.get();
            assert (f != null) : "Current future fetch failed";
            return f;
        }

        public void clearCurrentFuture() {
            this.setCurrentFuture(null);
        }

        public void setCurrentFuture(Future<T> to) {
            this.futureSync.set(to);
        }

        public void setCancelled() {
            this.sync.set(this.cancelObj);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean rv = false;
            this.setCancelled();
            Future<T> f = this.futureSync.get();
            if (f != null) {
                rv = f.cancel(mayInterruptIfRunning);
            }
            return rv;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Infinite sleep over.  The end is near", e);
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.sync.waitUntilTrue(new SynchronizationObject.Predicate<Object>(){

                @Override
                public boolean evaluate(Object o) {
                    return o != FutureFuture.this.defaultObj;
                }
            }, timeout, unit);
            Object o = this.sync.get();
            if (o == this.cancelObj) {
                throw new CancellationException("Cancelled");
            }
            if (o instanceof CompositeExecutorException) {
                throw (ExecutionException)o;
            }
            Object rv = o;
            return (T)rv;
        }

        @Override
        public boolean isCancelled() {
            return this.sync.get() == this.cancelObj;
        }

        @Override
        public boolean isDone() {
            return this.sync.get() != this.defaultObj;
        }
    }
}

