/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.spy.SpyObject;
import net.spy.db.ConnectionSource;
import net.spy.util.SpyConfig;

public class ConnectionSourceFactory
extends SpyObject {
    private static ConnectionSourceFactory instance = null;
    private ConcurrentMap<String, ConnectionSource> sources = new ConcurrentHashMap<String, ConnectionSource>();

    private ConnectionSourceFactory() {
    }

    public static synchronized ConnectionSourceFactory getInstance() {
        if (instance == null) {
            instance = new ConnectionSourceFactory();
        }
        return instance;
    }

    public static synchronized void setInstance(ConnectionSourceFactory to) {
        instance = to;
    }

    public ConnectionSource getConnectionSource(SpyConfig conf) {
        String connectionClassName = conf.get("dbConnectionSource", "net.spy.db.ObjectPoolConnectionSource");
        ConnectionSource source = (ConnectionSource)this.sources.get(connectionClassName);
        if (source == null) {
            try {
                this.getLogger().debug("Instantiating %s", connectionClassName);
                Class<?> connectionSourceClass = Class.forName(connectionClassName);
                ConnectionSource newSource = (ConnectionSource)connectionSourceClass.newInstance();
                ConnectionSource oldSource = this.sources.putIfAbsent(connectionClassName, newSource);
                source = oldSource == null ? newSource : oldSource;
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException("Cannot initialize connection source: " + connectionClassName);
                re.initCause(e);
                throw re;
            }
        }
        return source;
    }
}

