/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.spy.SpyObject;
import net.spy.db.DBSQL;
import net.spy.db.FileResultSet;
import net.spy.db.GenericPreparedStatementStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDriver
extends SpyObject
implements Driver {
    public static final String URL_PREFIX = "jdbc:spy:";
    private Map<String, Map<ParameterizedQuery, Object>> queryMap = new HashMap<String, Map<ParameterizedQuery, Object>>();
    private Map<String, Map<ParameterizedQuery, Object>> updateMap = new HashMap<String, Map<ParameterizedQuery, Object>>();

    private Map<ParameterizedQuery, Object> getMap(String key, Map<String, Map<ParameterizedQuery, Object>> m) {
        Map<ParameterizedQuery, Object> rv = m.get(key);
        if (rv == null) {
            rv = new HashMap<ParameterizedQuery, Object>();
            m.put(key, rv);
        }
        return rv;
    }

    public void registerQuery(String url, String s, URL f) {
        this.registerQuery(url, s, new Object[0], f);
    }

    public void registerQuery(String url, String s, Object[] args, URL f) {
        ParameterizedQuery pq = new ParameterizedQuery(s, args);
        this.getMap(url, this.queryMap).put(pq, f);
    }

    public void registerQuery(String url, DBSQL db, Object[] args, URL path) {
        for (String query : db.getRegisteredQueries().values()) {
            this.registerQuery(url, query, args, path);
        }
    }

    public void registerUpdate(String url, String s, Object[] args, Updater action) {
        ParameterizedQuery pq = new ParameterizedQuery(s, args);
        this.getMap(url, this.updateMap).put(pq, action);
    }

    public void registerUpdate(String url, DBSQL db, Object[] args, Updater u) {
        for (String query : db.getRegisteredQueries().values()) {
            this.registerUpdate(url, query, args, u);
        }
    }

    public void registerUpdate(String url, DBSQL db, Object[] args, int rv) {
        this.registerUpdate(url, db, args, (Updater)new IntUpdater(rv));
    }

    public void registerUpdate(String url, String s, Object[] args, int rv) {
        ParameterizedQuery pq = new ParameterizedQuery(s, args);
        this.getMap(url, this.updateMap).put(pq, new IntUpdater(rv));
    }

    URL getQuery(String url, ParameterizedQuery pq) throws SQLException {
        URL rv = (URL)this.getMap(url, this.queryMap).get(pq);
        if (rv == null) {
            throw new SQLException("No mapping registered for query " + pq + " in DB specified as " + url);
        }
        return rv;
    }

    Updater getUpdate(String url, ParameterizedQuery pq) throws SQLException {
        Updater rv = (Updater)this.getMap(url, this.updateMap).get(pq);
        if (rv == null) {
            throw new SQLException("No mapping registered for update " + pq + " in DB specified as " + url);
        }
        return rv;
    }

    public void clearQueries() {
        this.queryMap.clear();
        this.updateMap.clear();
    }

    @Override
    public Connection connect(String url, Properties prop) throws SQLException {
        return new FileConnection(url);
    }

    @Override
    public boolean acceptsURL(String arg0) throws SQLException {
        return arg0.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new FileDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static final class FileDriverMetaData
    extends SpyObject
    implements DatabaseMetaData {
        private Connection conn = null;
        private String url = null;

        public FileDriverMetaData(Connection c, String u) {
            this.conn = c;
            this.url = u;
        }

        public boolean allProceduresAreCallable() throws SQLException {
            return false;
        }

        public boolean allTablesAreSelectable() throws SQLException {
            return false;
        }

        public String getURL() throws SQLException {
            return this.url;
        }

        public String getUserName() throws SQLException {
            return "user";
        }

        public boolean isReadOnly() throws SQLException {
            return false;
        }

        public boolean nullsAreSortedHigh() throws SQLException {
            return false;
        }

        public boolean nullsAreSortedLow() throws SQLException {
            return true;
        }

        public boolean nullsAreSortedAtStart() throws SQLException {
            return false;
        }

        public boolean nullsAreSortedAtEnd() throws SQLException {
            return true;
        }

        public String getDatabaseProductName() throws SQLException {
            return "SpyDB FileDriver";
        }

        public String getDatabaseProductVersion() throws SQLException {
            return "2.1";
        }

        public String getDriverName() throws SQLException {
            return "SpyDB FileDriver";
        }

        public String getDriverVersion() throws SQLException {
            return "2.1";
        }

        public int getDriverMajorVersion() {
            return 2;
        }

        public int getDriverMinorVersion() {
            return 1;
        }

        public boolean usesLocalFiles() throws SQLException {
            return true;
        }

        public boolean usesLocalFilePerTable() throws SQLException {
            return false;
        }

        public boolean supportsMixedCaseIdentifiers() throws SQLException {
            return true;
        }

        public boolean storesUpperCaseIdentifiers() throws SQLException {
            return true;
        }

        public boolean storesLowerCaseIdentifiers() throws SQLException {
            return true;
        }

        public boolean storesMixedCaseIdentifiers() throws SQLException {
            return true;
        }

        public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
            return true;
        }

        public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
            return false;
        }

        public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
            return true;
        }

        public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
            return true;
        }

        public String getIdentifierQuoteString() throws SQLException {
            return "\"";
        }

        public String getSQLKeywords() throws SQLException {
            return "";
        }

        public String getNumericFunctions() throws SQLException {
            return "";
        }

        public String getStringFunctions() throws SQLException {
            return "";
        }

        public String getSystemFunctions() throws SQLException {
            return "";
        }

        public String getTimeDateFunctions() throws SQLException {
            return "";
        }

        public String getSearchStringEscape() throws SQLException {
            return "";
        }

        public String getExtraNameCharacters() throws SQLException {
            return "";
        }

        public boolean supportsAlterTableWithAddColumn() throws SQLException {
            return true;
        }

        public boolean supportsAlterTableWithDropColumn() throws SQLException {
            return true;
        }

        public boolean supportsColumnAliasing() throws SQLException {
            return true;
        }

        public boolean nullPlusNonNullIsNull() throws SQLException {
            return true;
        }

        public boolean supportsConvert() throws SQLException {
            return true;
        }

        public boolean supportsConvert(int fromType, int toType) throws SQLException {
            return true;
        }

        public boolean supportsTableCorrelationNames() throws SQLException {
            return true;
        }

        public boolean supportsDifferentTableCorrelationNames() throws SQLException {
            return true;
        }

        public boolean supportsExpressionsInOrderBy() throws SQLException {
            return true;
        }

        public boolean supportsOrderByUnrelated() throws SQLException {
            return false;
        }

        public boolean supportsGroupBy() throws SQLException {
            return true;
        }

        public boolean supportsGroupByUnrelated() throws SQLException {
            return true;
        }

        public boolean supportsGroupByBeyondSelect() throws SQLException {
            return false;
        }

        public boolean supportsLikeEscapeClause() throws SQLException {
            return true;
        }

        public boolean supportsMultipleResultSets() throws SQLException {
            return false;
        }

        public boolean supportsMultipleTransactions() throws SQLException {
            return false;
        }

        public boolean supportsNonNullableColumns() throws SQLException {
            return false;
        }

        public boolean supportsMinimumSQLGrammar() throws SQLException {
            return true;
        }

        public boolean supportsCoreSQLGrammar() throws SQLException {
            return true;
        }

        public boolean supportsExtendedSQLGrammar() throws SQLException {
            return true;
        }

        public boolean supportsANSI92EntryLevelSQL() throws SQLException {
            return true;
        }

        public boolean supportsANSI92IntermediateSQL() throws SQLException {
            return true;
        }

        public boolean supportsANSI92FullSQL() throws SQLException {
            return true;
        }

        public boolean supportsIntegrityEnhancementFacility() throws SQLException {
            return false;
        }

        public boolean supportsOuterJoins() throws SQLException {
            return true;
        }

        public boolean supportsFullOuterJoins() throws SQLException {
            return true;
        }

        public boolean supportsLimitedOuterJoins() throws SQLException {
            return true;
        }

        public String getSchemaTerm() throws SQLException {
            return "schema";
        }

        public String getProcedureTerm() throws SQLException {
            return "procedure";
        }

        public String getCatalogTerm() throws SQLException {
            return "catalog";
        }

        public boolean isCatalogAtStart() throws SQLException {
            return false;
        }

        public String getCatalogSeparator() throws SQLException {
            return ".";
        }

        public boolean supportsSchemasInDataManipulation() throws SQLException {
            return true;
        }

        public boolean supportsSchemasInProcedureCalls() throws SQLException {
            return true;
        }

        public boolean supportsSchemasInTableDefinitions() throws SQLException {
            return true;
        }

        public boolean supportsSchemasInIndexDefinitions() throws SQLException {
            return true;
        }

        public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
            return true;
        }

        public boolean supportsCatalogsInDataManipulation() throws SQLException {
            return false;
        }

        public boolean supportsCatalogsInProcedureCalls() throws SQLException {
            return false;
        }

        public boolean supportsCatalogsInTableDefinitions() throws SQLException {
            return false;
        }

        public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
            return false;
        }

        public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
            return false;
        }

        public boolean supportsPositionedDelete() throws SQLException {
            return true;
        }

        public boolean supportsPositionedUpdate() throws SQLException {
            return true;
        }

        public boolean supportsSelectForUpdate() throws SQLException {
            return true;
        }

        public boolean supportsStoredProcedures() throws SQLException {
            return true;
        }

        public boolean supportsSubqueriesInComparisons() throws SQLException {
            return true;
        }

        public boolean supportsSubqueriesInExists() throws SQLException {
            return true;
        }

        public boolean supportsSubqueriesInIns() throws SQLException {
            return true;
        }

        public boolean supportsSubqueriesInQuantifieds() throws SQLException {
            return true;
        }

        public boolean supportsCorrelatedSubqueries() throws SQLException {
            return true;
        }

        public boolean supportsUnion() throws SQLException {
            return true;
        }

        public boolean supportsUnionAll() throws SQLException {
            return true;
        }

        public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
            return true;
        }

        public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
            return true;
        }

        public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
            return true;
        }

        public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
            return true;
        }

        public int getMaxBinaryLiteralLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxCharLiteralLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxColumnNameLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxColumnsInGroupBy() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxColumnsInIndex() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxColumnsInOrderBy() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxColumnsInSelect() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxColumnsInTable() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxConnections() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxCursorNameLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxIndexLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxSchemaNameLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxProcedureNameLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxCatalogNameLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxRowSize() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
            return false;
        }

        public int getMaxStatementLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxStatements() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxTableNameLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxTablesInSelect() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getMaxUserNameLength() throws SQLException {
            return Integer.MAX_VALUE;
        }

        public int getDefaultTransactionIsolation() throws SQLException {
            return 8;
        }

        public boolean supportsTransactions() throws SQLException {
            return true;
        }

        public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
            return true;
        }

        public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
            return true;
        }

        public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
            return false;
        }

        public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
            return false;
        }

        public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
            return false;
        }

        public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
            return null;
        }

        public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
            return null;
        }

        public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
            return null;
        }

        public ResultSet getSchemas() throws SQLException {
            return null;
        }

        public ResultSet getCatalogs() throws SQLException {
            return null;
        }

        public ResultSet getTableTypes() throws SQLException {
            return null;
        }

        public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
            return null;
        }

        public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
            return null;
        }

        public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
            return null;
        }

        public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
            return null;
        }

        public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
            return null;
        }

        public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
            return null;
        }

        public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
            return null;
        }

        public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
            return null;
        }

        public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
            return null;
        }

        public ResultSet getTypeInfo() throws SQLException {
            return null;
        }

        public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
            return null;
        }

        public boolean supportsResultSetType(int type) throws SQLException {
            return true;
        }

        public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
            return true;
        }

        public boolean ownUpdatesAreVisible(int type) throws SQLException {
            return true;
        }

        public boolean ownDeletesAreVisible(int type) throws SQLException {
            return true;
        }

        public boolean ownInsertsAreVisible(int type) throws SQLException {
            return true;
        }

        public boolean othersUpdatesAreVisible(int type) throws SQLException {
            return false;
        }

        public boolean othersDeletesAreVisible(int type) throws SQLException {
            return false;
        }

        public boolean othersInsertsAreVisible(int type) throws SQLException {
            return false;
        }

        public boolean updatesAreDetected(int type) throws SQLException {
            return false;
        }

        public boolean deletesAreDetected(int type) throws SQLException {
            return false;
        }

        public boolean insertsAreDetected(int type) throws SQLException {
            return false;
        }

        public boolean supportsBatchUpdates() throws SQLException {
            return true;
        }

        public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
            return null;
        }

        public Connection getConnection() throws SQLException {
            return this.conn;
        }

        public boolean supportsSavepoints() throws SQLException {
            return true;
        }

        public boolean supportsNamedParameters() throws SQLException {
            return false;
        }

        public boolean supportsMultipleOpenResults() throws SQLException {
            return true;
        }

        public boolean supportsGetGeneratedKeys() throws SQLException {
            return false;
        }

        public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
            return null;
        }

        public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
            return null;
        }

        public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
            return null;
        }

        public boolean supportsResultSetHoldability(int holdability) throws SQLException {
            return false;
        }

        public int getResultSetHoldability() throws SQLException {
            return 2;
        }

        public int getDatabaseMajorVersion() throws SQLException {
            return 2;
        }

        public int getDatabaseMinorVersion() throws SQLException {
            return 1;
        }

        public int getJDBCMajorVersion() throws SQLException {
            return 3;
        }

        public int getJDBCMinorVersion() throws SQLException {
            return 0;
        }

        public int getSQLStateType() throws SQLException {
            return 0;
        }

        public boolean locatorsUpdateCopy() throws SQLException {
            return false;
        }

        public boolean supportsStatementPooling() throws SQLException {
            return false;
        }
    }

    private static final class FilePreparedStatement
    extends GenericPreparedStatementStub
    implements PreparedStatement {
        private String url = null;
        private int maxRows = Integer.MAX_VALUE;

        public FilePreparedStatement(String u, String q) {
            super(q);
            this.url = u;
        }

        public ResultSet executeQuery() throws SQLException {
            FileDriver fd = (FileDriver)DriverManager.getDriver("jdbc:spy:blah");
            URL f = fd.getQuery(this.url, new ParameterizedQuery(this.getQuery(), this.getApplicableArgs()));
            FileResultSet rs = new FileResultSet(f, this.maxRows);
            return rs;
        }

        public int executeUpdate() throws SQLException {
            FileDriver fd = (FileDriver)DriverManager.getDriver("jdbc:spy:blah");
            Updater u = fd.getUpdate(this.url, new ParameterizedQuery(this.getQuery(), this.getApplicableArgs()));
            return u.doUpdate();
        }

        public void setByte(int arg0, byte arg1) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setBytes(int arg0, byte[] arg1) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void clearParameters() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public boolean execute() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void addBatch() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setRef(int arg0, Ref arg1) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setBlob(int arg0, Blob arg1) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setClob(int arg0, Clob arg1) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setArray(int arg0, Array arg1) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setNull(int arg0, int arg1, String arg2) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setURL(int arg0, URL arg1) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public ParameterMetaData getParameterMetaData() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public ResultSet executeQuery(String arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int executeUpdate(String arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int getMaxFieldSize() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setMaxFieldSize(int arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int getMaxRows() throws SQLException {
            return this.maxRows;
        }

        public void setMaxRows(int to) throws SQLException {
            assert (to >= 0);
            this.maxRows = to == 0 ? Integer.MAX_VALUE : to;
        }

        public void setEscapeProcessing(boolean arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int getQueryTimeout() throws SQLException {
            return 0;
        }

        public void setQueryTimeout(int arg0) throws SQLException {
        }

        public void cancel() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public SQLWarning getWarnings() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void clearWarnings() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setCursorName(String arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public boolean execute(String arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public ResultSet getResultSet() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int getUpdateCount() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public boolean getMoreResults() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setFetchDirection(int arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int getFetchDirection() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void setFetchSize(int arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int getFetchSize() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int getResultSetConcurrency() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int getResultSetType() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void addBatch(String arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public void clearBatch() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int[] executeBatch() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public Connection getConnection() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public boolean getMoreResults(int arg0) throws SQLException {
            throw new SQLException("Not supported.");
        }

        public ResultSet getGeneratedKeys() throws SQLException {
            throw new SQLException("Not supported.");
        }

        public int executeUpdate(String arg0, int arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        public int executeUpdate(String arg0, int[] arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        public int executeUpdate(String arg0, String[] arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        public boolean execute(String arg0, int arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        public boolean execute(String arg0, int[] arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        public boolean execute(String arg0, String[] arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        public int getResultSetHoldability() throws SQLException {
            throw new SQLException("Not supported.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileConnection
    extends SpyObject
    implements Connection {
        private String url = null;
        private boolean closed = false;
        private boolean autoCommit = false;
        private String catalog = "testCatalog";
        private int transactionIsolation = 8;
        private boolean readOnly = false;
        private int holdAbility = 0;
        private Map<String, Class<?>> typeMap = null;

        public FileConnection(String u) {
            this.url = u;
        }

        @Override
        public Statement createStatement() throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public PreparedStatement prepareStatement(String query) throws SQLException {
            return new FilePreparedStatement(this.url, query);
        }

        @Override
        public CallableStatement prepareCall(String arg0) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public String nativeSQL(String arg0) throws SQLException {
            return arg0;
        }

        @Override
        public void setAutoCommit(boolean arg0) throws SQLException {
            this.autoCommit = arg0;
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.autoCommit;
        }

        @Override
        public void commit() throws SQLException {
        }

        @Override
        public void rollback() throws SQLException {
        }

        @Override
        public void close() throws SQLException {
            this.closed = true;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.closed;
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return new FileDriverMetaData(this, this.url);
        }

        @Override
        public void setReadOnly(boolean arg0) throws SQLException {
            this.readOnly = arg0;
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.readOnly;
        }

        @Override
        public void setCatalog(String arg0) throws SQLException {
            this.catalog = arg0;
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.catalog;
        }

        @Override
        public void setTransactionIsolation(int arg0) throws SQLException {
            this.transactionIsolation = arg0;
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.transactionIsolation;
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return null;
        }

        @Override
        public void clearWarnings() throws SQLException {
        }

        @Override
        public Statement createStatement(int arg0, int arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.typeMap;
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
            this.typeMap = arg0;
        }

        @Override
        public void setHoldability(int arg0) throws SQLException {
            this.holdAbility = arg0;
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.holdAbility;
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public Savepoint setSavepoint(String arg0) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public void rollback(Savepoint arg0) throws SQLException {
        }

        @Override
        public void releaseSavepoint(Savepoint arg0) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("Not supported");
        }

        @Override
        public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }

        @Override
        public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
            throw new SQLException("Not implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassParamMatcher
    implements ParamMatcher {
        private Class<?> theClass = null;

        public ClassParamMatcher(Class<?> c) {
            this.theClass = c;
        }

        @Override
        public boolean matches(Object o) {
            return this.theClass.equals(o.getClass());
        }
    }

    public static class AnyParamMatcher
    implements ParamMatcher {
        public boolean matches(Object o) {
            return true;
        }
    }

    public static interface ParamMatcher {
        public boolean matches(Object var1);
    }

    private static final class ParameterizedQuery
    extends SpyObject {
        private String query = null;
        private Object[] args = null;

        public ParameterizedQuery(String q, Object[] a) {
            if (q == null) {
                throw new NullPointerException("Invalid null query");
            }
            if (a == null) {
                throw new NullPointerException("Invalid null arguments");
            }
            this.query = q;
            this.args = a;
        }

        public ParameterizedQuery(String q) {
            this(q, new Object[0]);
        }

        public int hashCode() {
            int rv = this.query.hashCode() ^ this.args.length;
            return rv;
        }

        public boolean equals(Object o) {
            boolean rv = false;
            if (o instanceof ParameterizedQuery) {
                ParameterizedQuery pq = (ParameterizedQuery)o;
                if (this.query.equals(pq.query) && this.args.length == pq.args.length) {
                    rv = true;
                    for (int i = 0; i < pq.args.length; ++i) {
                        if (pq.args[i] instanceof ParamMatcher) {
                            ParamMatcher pm = (ParamMatcher)pq.args[i];
                            rv &= pm.matches(this.args[i]);
                            continue;
                        }
                        if (pq.args[i] == null) {
                            rv &= this.args[i] == null;
                            continue;
                        }
                        rv &= pq.args[i].equals(this.args[i]);
                    }
                }
            }
            return rv;
        }

        public String toString() {
            ArrayList<String> paramStrings = new ArrayList<String>(this.args.length);
            for (int i = 0; i < this.args.length; ++i) {
                String type = "";
                if (this.args[i] != null) {
                    type = "(" + this.args[i].getClass().getName() + ")";
                }
                paramStrings.add(type + this.args[i]);
            }
            return "{ParameterizedQuery ``" + this.query + "'' with " + paramStrings + "}";
        }
    }

    private static class IntUpdater
    implements Updater {
        private int rv = 0;

        public IntUpdater(int v) {
            this.rv = v;
        }

        public int doUpdate() {
            return this.rv;
        }
    }

    public static interface Updater {
        public int doUpdate() throws SQLException;
    }
}

