/*
 * Decompiled with CFR 0.152.
 */
package net.spy.stat;

import net.spy.stat.Stat;

public class ComputingStat
extends Stat {
    private int n = 0;
    private double mean = Double.NaN;
    private double variance = Double.NaN;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private double decayAvg = Double.NaN;
    private double sum = 0.0;

    public synchronized void clear() {
        this.n = 0;
        this.decayAvg = Double.NaN;
        this.max = Double.NaN;
        this.min = Double.NaN;
        this.variance = Double.NaN;
        this.mean = Double.NaN;
        this.sum = 0.0;
    }

    public synchronized void add(double value) {
        if (++this.n == 1) {
            this.min = this.max = value;
            this.decayAvg = this.max;
            this.mean = this.max;
            this.variance = 0.0;
        } else {
            double newmean = this.mean + (value - this.mean) / (double)this.n;
            this.variance += (value - this.mean) * (value - newmean);
            this.mean = newmean;
            this.decayAvg = (this.decayAvg * (double)this.n + value) / (double)(this.n + 1);
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
        }
        this.sum += value;
    }

    public synchronized double getStddev() {
        if (this.n < 2) {
            return Double.NaN;
        }
        return Math.sqrt(this.variance / (double)(this.n - 1));
    }

    public synchronized double getDecayAvg() {
        return this.decayAvg;
    }

    public synchronized String getStat() {
        return String.format("compstat: count=%d sum=%f min=%f avg=%f davg=%f max=%f stddev=%f", this.n, this.sum, this.min, this.mean, this.decayAvg, this.max, this.getStddev());
    }

    public synchronized double getMax() {
        return this.max;
    }

    public synchronized double getMean() {
        return this.mean;
    }

    public synchronized double getMin() {
        return this.min;
    }

    public synchronized int getCount() {
        return this.n;
    }

    public synchronized double getSum() {
        return this.sum;
    }
}

