/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.spy.SpyObject;
import net.spy.util.Base64;

public class Digest
extends SpyObject {
    private static final String DEFAULTHASH = "SHA";
    private boolean prefixHash = true;
    private String hashAlg = null;
    private int digLen = 0;

    public Digest() {
        this(DEFAULTHASH);
    }

    public Digest(String alg) {
        this.hashAlg = alg;
        MessageDigest d = this.getMessageDigest();
        this.digLen = d.getDigestLength();
        assert (this.digLen != 0) : "Couldn't calculate digest length";
    }

    public String getHashAlg() {
        return this.hashAlg;
    }

    public void prefixHash(boolean doit) {
        this.prefixHash = doit;
    }

    public boolean checkPassword(String pw, String hash) {
        boolean rv = false;
        String htype = hash.substring(0, hash.indexOf(125) + 1).toUpperCase();
        if (htype.equals("{" + this.hashAlg + "}") || htype.equals("{S" + this.hashAlg + "}")) {
            String data = hash.substring(hash.indexOf(125) + 1);
            Base64 base64d = new Base64();
            byte[] datab = base64d.decode(data);
            byte[] salt = new byte[datab.length - this.digLen];
            System.arraycopy(datab, this.digLen, salt, 0, salt.length);
            String newhash = this.getHash(pw, salt);
            rv = hash.equals(newhash);
        } else {
            this.getLogger().warn("Invalid hash type ``%s'' in %s", htype, hash);
        }
        return rv;
    }

    private String getPrefix(String p) {
        String rv = "";
        if (this.prefixHash) {
            rv = p;
        }
        return rv;
    }

    protected String getHash(String word, byte[] salt) {
        MessageDigest md = this.getMessageDigest();
        md.update(word.getBytes());
        md.update(salt);
        byte[] pwhash = md.digest();
        String hout = this.getPrefix("{S" + this.hashAlg + "}") + Base64.getInstance().encode(this.cat(pwhash, salt));
        return hout.trim();
    }

    private MessageDigest getMessageDigest() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(this.hashAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No such digest:  " + this.hashAlg, e);
        }
        return md;
    }

    public byte[] getSaltFreeHashBytes(String s) {
        MessageDigest md = this.getMessageDigest();
        md.update(s.getBytes());
        byte[] hash = md.digest();
        return hash;
    }

    public String getSaltFreeHash(String s) {
        String hout = this.getPrefix("{" + this.hashAlg + "}") + Base64.getInstance().encode(this.getSaltFreeHashBytes(s));
        return hout;
    }

    public String getHash(String word) {
        byte[] salt = new byte[8];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(salt);
        return this.getHash(word, salt);
    }

    private byte[] cat(byte[] a, byte[] b) {
        byte[] r = new byte[a.length + b.length];
        System.arraycopy(a, 0, r, 0, a.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        return r;
    }
}

