/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.lang.ref.WeakReference;
import net.spy.util.SPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPVertex<N extends SPNode<N>>
implements Comparable<SPVertex<N>> {
    private WeakReference<N> to = null;
    private int cost = 0;
    public static final int DEFAULT_COST = 10;

    public SPVertex(N destination, int theCost) {
        if (destination == null) {
            throw new NullPointerException("Destination node may not be null.");
        }
        this.to = new WeakReference<N>(destination);
        this.cost = theCost;
    }

    public String toString() {
        return "{SPVertex cost=" + this.cost + " dest=" + this.to.get() + "}";
    }

    public SPVertex(N destination) {
        this(destination, 10);
    }

    public N getTo() {
        return (N)((SPNode)this.to.get());
    }

    public int getCost() {
        return this.cost;
    }

    @Override
    public int compareTo(SPVertex<N> other) {
        int rv = 0;
        rv = this.getCost() > other.getCost() ? 1 : (this.getCost() < other.getCost() ? -1 : this.getTo().compareTo(other.getTo()));
        return rv;
    }
}

