/*
 * Decompiled with CFR 0.152.
 */
package er.rest.entityDelegates;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.localization.ERXLocalizer;
import er.rest.ERXRestException;
import er.rest.ERXRestRequestNode;
import er.rest.entityDelegates.ERXDenyRestEntityDelegate;
import er.rest.entityDelegates.ERXRestContext;
import er.rest.entityDelegates.ERXRestEntityDelegateUtils;
import er.rest.entityDelegates.ERXRestKey;
import er.rest.entityDelegates.ERXRestNotFoundException;
import er.rest.entityDelegates.ERXRestRequest;
import er.rest.entityDelegates.ERXRestRequestHandler;
import er.rest.entityDelegates.ERXRestSecurityException;
import er.rest.entityDelegates.IERXRestDelegate;
import er.rest.entityDelegates.IERXRestEntityDelegate;
import java.util.Enumeration;

public class ERXDefaultRestDelegate
implements IERXRestDelegate {
    private NSMutableDictionary<String, String> _entityAliases = new NSMutableDictionary();
    private NSMutableDictionary<String, IERXRestEntityDelegate> _entityDelegates = new NSMutableDictionary();
    private IERXRestEntityDelegate _defaultDelegate;
    private boolean _guessDelegateNames;

    public ERXDefaultRestDelegate() {
        this(new ERXDenyRestEntityDelegate(), true);
    }

    public ERXDefaultRestDelegate(boolean guessDelegateNames) {
        this(new ERXDenyRestEntityDelegate(), guessDelegateNames);
    }

    public ERXDefaultRestDelegate(IERXRestEntityDelegate defaultDelegate) {
        this(defaultDelegate, true);
    }

    public ERXDefaultRestDelegate(IERXRestEntityDelegate defaultDelegate, boolean guessDelegateNames) {
        this._defaultDelegate = defaultDelegate;
        this._guessDelegateNames = guessDelegateNames;
    }

    public ERXRestKey process(ERXRestRequest restRequest, ERXRestContext context) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException {
        ERXRestKey restResult;
        ERXRestKey lastKey = restRequest.key();
        EOEntity entity = lastKey.entity();
        IERXRestEntityDelegate entityDelegate = this.entityDelegate(entity);
        if (lastKey.isKeyGID()) {
            EOEnterpriseObject eo = entityDelegate.processObjectFromDocument(entity, restRequest.rootNode(), context);
            restResult = new ERXRestKey(context, entity, "processed", eo);
        } else if (lastKey.isKeyAll()) {
            NSMutableArray eos = new NSMutableArray();
            Enumeration childrenNodesEnum = restRequest.rootNode().children().objectEnumerator();
            while (childrenNodesEnum.hasMoreElements()) {
                ERXRestRequestNode node = (ERXRestRequestNode)childrenNodesEnum.nextElement();
                EOEntity arrayEntity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, context.delegate().entityNameForAlias(node.name()));
                EOEnterpriseObject eo = entityDelegate.processObjectFromDocument(arrayEntity, node, context);
                if (eo == null) continue;
                eos.addObject((Object)eo);
            }
            restResult = new ERXRestKey(context, entity, "processed", eos);
        } else {
            throw new IllegalArgumentException("Unable to process " + lastKey);
        }
        return restResult;
    }

    public ERXRestKey view(ERXRestRequest restRequest, ERXRestContext restContext) {
        return restRequest.key();
    }

    public ERXRestKey insert(ERXRestRequest insertRequest, ERXRestContext context) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException {
        ERXRestKey insertResult;
        ERXRestKey lastKey = insertRequest.key();
        if (lastKey.isKeyAll()) {
            EOEntity lastEntity = lastKey.entity();
            insertResult = this.insertInto(lastEntity, insertRequest, null, null, null, context);
        } else {
            if (lastKey.isKeyGID()) {
                throw new ERXRestException("You can't insert an object with a specific id.");
            }
            ERXRestKey previousKey = lastKey.previousKey();
            Object nextToLastValue = previousKey.value();
            if (nextToLastValue instanceof EOEnterpriseObject) {
                EOEnterpriseObject nextToLastEO = (EOEnterpriseObject)nextToLastValue;
                EOEntity nextEntity = lastKey.nextEntity();
                insertResult = this.insertInto(nextEntity, insertRequest, previousKey.entity(), nextToLastEO, lastKey.key(), context);
            } else {
                throw new ERXRestException("You attempted to insert something that could not be processed.");
            }
        }
        return insertResult;
    }

    protected ERXRestKey insertInto(EOEntity entity, ERXRestRequest insertRequest, EOEntity parentEntity, EOEnterpriseObject parentObject, String parentKey, ERXRestContext context) throws ERXRestSecurityException, ERXRestException, ERXRestNotFoundException {
        ERXRestKey insertResult;
        ERXRestRequestNode insertRootNode = insertRequest.rootNode();
        IERXRestEntityDelegate entityDelegate = this.entityDelegate(entity);
        String entityAlias = entityDelegate.entityAliasForEntityNamed(entity.name());
        String pluralEntityAlias = ERXLocalizer.currentLocalizer().plurifiedString(entityAlias, 2);
        String nodeName = insertRootNode.name();
        if (entityAlias.equals(nodeName)) {
            EOEnterpriseObject eo = entityDelegate.insertObjectFromDocument(entity, insertRootNode, parentEntity, parentObject, parentKey, context);
            insertResult = new ERXRestKey(context, entity, "inserted", eo);
        } else if (pluralEntityAlias.equals(nodeName)) {
            NSMutableArray eos = new NSMutableArray();
            Enumeration insertNodesEnum = insertRootNode.children().objectEnumerator();
            while (insertNodesEnum.hasMoreElements()) {
                ERXRestRequestNode insertNode = (ERXRestRequestNode)insertNodesEnum.nextElement();
                EOEnterpriseObject eo = entityDelegate.insertObjectFromDocument(entity, insertNode, parentEntity, parentObject, parentKey, context);
                if (eo != null) {
                    eos.addObject((Object)eo);
                    continue;
                }
                ERXRestRequestHandler.log.warn((Object)"Skipping inserted entry.  This should possibly throw a SecurityException?");
            }
            insertResult = new ERXRestKey(context, entity, "inserted", eos);
        } else {
            throw new ERXRestException("You attempted to put a " + nodeName + " into a " + entityAlias + ".");
        }
        return insertResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(ERXRestRequest updateRequest, ERXRestContext context) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException {
        ERXRestKey lastKey = updateRequest.key();
        if (lastKey.isKeyAll()) {
            throw new ERXRestSecurityException("You are not allowed to update all " + this.entityDelegate(lastKey.entity()).entityAliasForEntityNamed(lastKey.entity().name()) + " objects.");
        }
        EOEntity lastEntity = lastKey.entity();
        Object lastValue = lastKey.value();
        if (lastValue instanceof EOEnterpriseObject) {
            EOEnterpriseObject eo = (EOEnterpriseObject)lastValue;
            ERXRestRequestNode updateNode = updateRequest.rootNode();
            context.delegate().entityDelegate(lastEntity).updateObjectFromDocument(lastEntity, eo, updateNode, context);
            return;
        } else if (lastValue instanceof NSArray) {
            ERXRestKey nextToLastKey = lastKey.previousKey();
            Object nextToLastValue = nextToLastKey.value();
            if (!(nextToLastValue instanceof EOEnterpriseObject)) throw new ERXRestException("You attempted to put an array into something other than a relationship of a single object.");
            EOEntity previousEntity = nextToLastKey.entity();
            EOEnterpriseObject eo = (EOEnterpriseObject)nextToLastValue;
            NSArray currentObjects = (NSArray)lastValue;
            ERXRestRequestNode arrayNode = updateRequest.rootNode();
            String arrayNodeName = arrayNode.name();
            String pluralToManyEntityName = ERXLocalizer.currentLocalizer().plurifiedString(this.entityDelegate(lastEntity).entityAliasForEntityNamed(lastEntity.name()), 2);
            if (!pluralToManyEntityName.equals(arrayNodeName)) {
                throw new ERXRestException("You attempted to put " + arrayNodeName + " into " + pluralToManyEntityName + ".");
            }
            NSArray<ERXRestRequestNode> toManyNodes = arrayNode.children();
            context.delegate().entityDelegate(lastEntity).updateArrayFromDocument(previousEntity, eo, nextToLastKey.key(), lastEntity, currentObjects, toManyNodes, context);
            return;
        } else {
            ERXRestKey nextToLastKey = lastKey.previousKey();
            Object nextToLastValue = nextToLastKey.value();
            EOEntity nextToLastEntity = nextToLastKey.entity();
            if (!(nextToLastValue instanceof EOEnterpriseObject)) throw new ERXRestException("You attempted to update a keypath that is not editable.");
            ERXRestRequestNode reformedEORequestNode = new ERXRestRequestNode(this.entityDelegate(nextToLastEntity).entityAliasForEntityNamed(nextToLastEntity.name()), true);
            ERXRestRequestNode reformedPrimitiveRequestNode = new ERXRestRequestNode(lastKey.keyAlias(), false);
            ERXRestRequestNode updateNode = updateRequest.rootNode();
            reformedPrimitiveRequestNode.setValue(updateNode.value());
            reformedEORequestNode.addChild(reformedPrimitiveRequestNode);
            ERXRestRequest primitiveRequest = new ERXRestRequest(nextToLastKey, reformedEORequestNode);
            this.update(primitiveRequest, context);
        }
    }

    public void delete(ERXRestRequest deleteRequest, ERXRestContext context) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException {
        ERXRestKey lastKey = deleteRequest.key();
        if (lastKey.isKeyAll()) {
            throw new ERXRestException("You are not allowed to delete all the objects for any entity.");
        }
        EOEntity entity = lastKey.entity();
        IERXRestEntityDelegate entityDelegate = this.entityDelegate(entity);
        Object value = lastKey.value();
        if (value instanceof NSArray) {
            NSArray values = (NSArray)value;
            Enumeration valuesEnum = values.objectEnumerator();
            while (valuesEnum.hasMoreElements()) {
                EOEnterpriseObject eo = (EOEnterpriseObject)valuesEnum.nextElement();
                entityDelegate.delete(entity, eo, context);
            }
        } else {
            entityDelegate.delete(entity, (EOEnterpriseObject)value, context);
        }
    }

    public String entityNameForAlias(String entityAlias) {
        String entityName = (String)this._entityAliases.objectForKey((Object)entityAlias);
        if (entityName == null) {
            entityName = entityAlias;
        }
        return entityName;
    }

    public IERXRestEntityDelegate entityDelegate(EOEntity entity) {
        IERXRestEntityDelegate entityDelegate = (IERXRestEntityDelegate)this._entityDelegates.objectForKey((Object)entity.name());
        if (entityDelegate == null) {
            String entityDelegateClassName = ERXProperties.stringForKey((String)("ERXRest." + entity.name() + ".delegate"));
            Class entityDelegateClass = null;
            if (entityDelegateClassName == null) {
                if (this._guessDelegateNames) {
                    entityDelegateClassName = entity.name() + "RestEntityDelegate";
                    entityDelegateClass = _NSUtilities.classWithName((String)entityDelegateClassName);
                }
            } else {
                entityDelegateClass = _NSUtilities.classWithName((String)entityDelegateClassName);
                if (entityDelegateClass == null) {
                    throw new IllegalArgumentException("There is no entity delegate named '" + entityDelegateClassName + "'.");
                }
            }
            if (entityDelegateClass != null) {
                try {
                    entityDelegate = (IERXRestEntityDelegate)entityDelegateClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to instantiate the entity delegate '" + entityDelegateClassName + "'.", e);
                }
            } else {
                entityDelegate = this._defaultDelegate;
            }
            this._entityDelegates.setObjectForKey((Object)entityDelegate, (Object)entity.name());
        }
        entityDelegate.initializeEntityNamed(entity.name());
        return entityDelegate;
    }

    public void addDelegateForEntityNamed(IERXRestEntityDelegate entityDelegate, String entityName) {
        this._entityDelegates.setObjectForKey((Object)entityDelegate, (Object)entityName);
        this._entityAliases.setObjectForKey((Object)entityName, (Object)entityDelegate.entityAliasForEntityNamed(entityName));
    }

    public void removeDelegateForEntityNamed(String entityName) {
        this._entityDelegates.removeObjectForKey((Object)entityName);
    }
}

